/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.lang.reflect.Field;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.core.Kernel;
import tigase.muc.AbstractMucTest;
import tigase.muc.MUCConfig;
import tigase.muc.PermissionChecker;
import tigase.muc.TestMUCCompoent;
import tigase.muc.exceptions.MUCException;
import tigase.server.CmdAcl;
import tigase.server.xmppserver.S2SConnManAbstractTest;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class PermissionCheckerTest
extends AbstractMucTest {
    private PermissionChecker permissionChecker;
    private final String vhost = "tigase.org";
    private final String componentName = "muc";
    private final JID regularUserJid = JID.jidInstanceNS((String)"wojtek", (String)"tigase.org", (String)"test");
    private final JID domainAdminJID = JID.jidInstanceNS((String)"domain_admin", (String)"tigase.org", (String)"resource");
    private final JID adminJID = JID.jidInstanceNS((String)"admin", (String)"tigase.org", (String)"resource");
    final BareJID roomJID = BareJID.bareJIDInstanceNS((String)"room", (String)"muc.tigase.org");

    @Override
    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        TestMUCCompoent mucComponent = (TestMUCCompoent)((Object)kernel.getInstance(TestMUCCompoent.class));
        mucComponent.setAdmins(Set.of(this.adminJID.getBareJID()));
        S2SConnManAbstractTest.DummyVHostManager vHostManager = (S2SConnManAbstractTest.DummyVHostManager)kernel.getInstance(S2SConnManAbstractTest.DummyVHostManager.class);
        vHostManager.addVhost("tigase.org");
        vHostManager.getVHostItem("tigase.org").setAdmins(new String[]{this.domainAdminJID.getBareJID().toString()});
        this.permissionChecker = (PermissionChecker)this.getMucKernel().getInstance(PermissionChecker.class);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testDefaultPermissionsRegularUser() throws RepositoryException, MUCException {
        PermissionChecker.ROOM_VISIBILITY_PERMISSION permission = this.permissionChecker.getCreateRoomPermission(this.roomJID, this.regularUserJid);
        Assert.assertEquals((Object)PermissionChecker.ROOM_VISIBILITY_PERMISSION.HIDDEN, (Object)permission);
    }

    @Test
    public void testDefaultPermissionsRegularDomainAdmin() throws RepositoryException, MUCException {
        PermissionChecker.ROOM_VISIBILITY_PERMISSION permission = this.permissionChecker.getCreateRoomPermission(this.roomJID, this.domainAdminJID);
        Assert.assertEquals((Object)PermissionChecker.ROOM_VISIBILITY_PERMISSION.PUBLIC, (Object)permission);
    }

    @Test
    public void testDefaultPermissionsRegularAdmin() throws RepositoryException, MUCException {
        PermissionChecker.ROOM_VISIBILITY_PERMISSION permission = this.permissionChecker.getCreateRoomPermission(this.roomJID, this.adminJID);
        Assert.assertEquals((Object)PermissionChecker.ROOM_VISIBILITY_PERMISSION.PUBLIC, (Object)permission);
    }

    @Test(expected=MUCException.class)
    public void testDisabledACLRegular() throws RepositoryException, MUCException {
        this.setPublicACL(CmdAcl.Type.NONE);
        this.setHiddenACL(CmdAcl.Type.NONE);
        PermissionChecker.ROOM_VISIBILITY_PERMISSION permission = this.permissionChecker.getCreateRoomPermission(this.roomJID, this.regularUserJid);
        Assert.assertEquals((Object)PermissionChecker.ROOM_VISIBILITY_PERMISSION.PUBLIC, (Object)permission);
    }

    @Test(expected=MUCException.class)
    public void testDisabledACLDomainAdmin() throws RepositoryException, MUCException {
        this.setPublicACL(CmdAcl.Type.NONE);
        this.setHiddenACL(CmdAcl.Type.NONE);
        PermissionChecker.ROOM_VISIBILITY_PERMISSION permission = this.permissionChecker.getCreateRoomPermission(this.roomJID, this.domainAdminJID);
        Assert.assertEquals((Object)PermissionChecker.ROOM_VISIBILITY_PERMISSION.PUBLIC, (Object)permission);
    }

    @Test(expected=MUCException.class)
    public void testDisabledACLAdmin() throws RepositoryException, MUCException {
        this.setPublicACL(CmdAcl.Type.NONE);
        this.setHiddenACL(CmdAcl.Type.NONE);
        PermissionChecker.ROOM_VISIBILITY_PERMISSION permission = this.permissionChecker.getCreateRoomPermission(this.roomJID, this.adminJID);
        Assert.assertEquals((Object)PermissionChecker.ROOM_VISIBILITY_PERMISSION.PUBLIC, (Object)permission);
    }

    @Test
    public void testDisabledACLAdminHidden() throws RepositoryException, MUCException {
        this.setPublicACL(CmdAcl.Type.NONE);
        this.setHiddenACL(CmdAcl.Type.ADMIN);
        PermissionChecker.ROOM_VISIBILITY_PERMISSION permission = this.permissionChecker.getCreateRoomPermission(this.roomJID, this.adminJID);
        Assert.assertEquals((Object)PermissionChecker.ROOM_VISIBILITY_PERMISSION.HIDDEN, (Object)permission);
    }

    private void setPublicACL(CmdAcl.Type acl) {
        MUCConfig config = (MUCConfig)this.getMucKernel().getInstance(MUCConfig.class);
        this.setACL("publicRoomCreationAcl", config, acl);
    }

    private void setHiddenACL(CmdAcl.Type acl) {
        MUCConfig config = (MUCConfig)this.getMucKernel().getInstance(MUCConfig.class);
        this.setACL("hiddenRoomCreationAcl", config, acl);
    }

    private void setACL(String field, MUCConfig config, CmdAcl.Type acl) {
        try {
            Field publicRoomCreationAcl = config.getClass().getDeclaredField(field);
            publicRoomCreationAcl.setAccessible(true);
            publicRoomCreationAcl.set(config, acl);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

