/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules.selfping;

import java.util.Collection;
import java.util.logging.Level;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.impl.XmppPingModule;
import tigase.component.responses.AsyncCallback;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.selfping.Request;
import tigase.muc.modules.selfping.SelfPingException;
import tigase.muc.modules.selfping.SelfPingerMonitor;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="urn:xmpp:ping", active=true)
public class SelfPingModule
extends XmppPingModule
implements Initializable {
    private static long idCounter;
    @Inject
    private SelfPingerMonitor pingMonitor;
    @Inject
    private IMucRepository repository;

    public void process(Packet packet) throws ComponentException {
        try {
            JID senderJID = packet.getStanzaFrom();
            BareJID roomJID = packet.getStanzaTo().getBareJID();
            String recipientNickname = packet.getStanzaTo().getResource();
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "Processing ping packet: {0}, module-ping: {1}, room-ping: {2}", new Object[]{packet, roomJID.getLocalpart() == null, recipientNickname == null});
            }
            if (roomJID.getLocalpart() == null) {
                super.process(packet);
                return;
            }
            if (recipientNickname == null) {
                super.process(packet);
                return;
            }
            Room room = this.repository.getRoom(roomJID);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND, "Room not found");
            }
            Collection<JID> recipientJids = room.getOccupantsJidsByNickname(recipientNickname);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "Processing ping packet[2]: {0}, recipientJids: {1}, room: {2}", new Object[]{packet, recipientJids, room});
            }
            if (recipientJids.isEmpty()) {
                throw new SelfPingException(Authorization.NOT_ACCEPTABLE, room.getRoomJID().toString(), recipientNickname + " is not in room");
            }
            this.pingAll(packet.getStanzaId(), packet.getStanzaFrom(), packet.getStanzaTo(), recipientJids);
        }
        catch (ComponentException e1) {
            throw e1;
        }
        catch (Exception e) {
            this.log.log(Level.FINEST, "Error during forwarding IQ", e);
            throw new RuntimeException(e);
        }
    }

    public void initialize() {
        this.pingMonitor.setHandler(this::onPingMultirequestFinished);
    }

    protected String nextStanzaId() {
        String id = "spng-" + ++idCounter;
        return id;
    }

    protected Packet createPingPacket(String id, String from, String to) throws TigaseStringprepException {
        Element ping = new Element("iq", new String[]{"type", "id", "from", "to"}, new String[]{"get", id, from, to});
        ping.addChild((XMLNodeIfc)new Element("ping", new String[]{"xmlns"}, new String[]{"urn:xmpp:ping"}));
        Packet packet = Packet.packetInstance((Element)ping);
        packet.setXMLNS("jabber:client");
        return packet;
    }

    private Element errorElement(Authorization auth, String message) {
        Element error = new Element("error", new String[]{"type"}, new String[]{auth.getErrorType()});
        error.addChild((XMLNodeIfc)new Element(auth.getCondition(), new String[]{"xmlns"}, new String[]{"urn:ietf:params:xml:ns:xmpp-stanzas"}));
        return error;
    }

    private void onPingMultirequestFinished(Request req, SelfPingerMonitor.ResultStatus resultStatus) {
        try {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "Finished processing, req: {0}, result: {1}", new Object[]{req, resultStatus});
            }
            Element ping = new Element("iq", new String[]{"id", "from", "to"}, new String[]{req.getId(), req.getJidTo().toString(), req.getJid().toString()});
            switch (resultStatus) {
                case AllSuccess: {
                    ping.setAttribute("type", "result");
                    break;
                }
                case Errors: {
                    ping.setAttribute("type", "error");
                    ping.addChild((XMLNodeIfc)this.errorElement(Authorization.SERVICE_UNAVAILABLE, "Some clients responded with error."));
                    break;
                }
                case Timeouts: {
                    ping.setAttribute("type", "error");
                    ping.addChild((XMLNodeIfc)this.errorElement(Authorization.SERVICE_UNAVAILABLE, "Some clients not responded."));
                }
            }
            Packet packet = Packet.packetInstance((Element)ping);
            packet.setXMLNS("jabber:client");
            this.write(packet);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Cannot send ping response", e);
        }
    }

    private void pingAll(String stanzaId, JID from, JID to, Collection<JID> recipientJids) {
        Request request = this.pingMonitor.register(from, to, stanzaId);
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "Pinging connections, stanzaId: {0}, from: {1}, to: {2}, recipientJids: {3}, request: {4}", new Object[]{stanzaId, from, to, recipientJids, request});
        }
        recipientJids.forEach(jid -> {
            try {
                String id = this.nextStanzaId();
                Packet pingPacket = this.createPingPacket(id, to.toString(), jid.toString());
                request.registerRequest((JID)jid, id);
                this.write(pingPacket, new PongCallback((JID)jid, id));
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "Problem when pinging", e);
            }
        });
    }

    private class PongCallback
    implements AsyncCallback {
        private final String id;
        private final JID jid;

        PongCallback(JID jid, String id) {
            this.jid = jid;
            this.id = id;
        }

        public void onError(Packet responseStanza, String errorCondition) {
            SelfPingModule.this.pingMonitor.registerResponse(responseStanza.getStanzaFrom(), responseStanza.getStanzaId(), Request.Result.Error);
        }

        public void onSuccess(Packet responseStanza) {
            SelfPingModule.this.pingMonitor.registerResponse(responseStanza.getStanzaFrom(), responseStanza.getStanzaId(), Request.Result.Ok);
        }

        public void onTimeout() {
            SelfPingModule.this.pingMonitor.registerResponse(this.jid, this.id, Request.Result.Timeout);
        }
    }
}

