/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.muc.Room;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;
import tigase.xmpp.mam.modules.QueryModule;

@Bean(name="mamQueryModule", active=true)
public class MAMQueryModule
extends QueryModule {
    @Inject
    private IMucRepository repository;

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        JID toJid = packet.getStanzaTo();
        if (toJid == null || toJid.getLocalpart() == null) {
            throw new ComponentException(Authorization.FEATURE_NOT_IMPLEMENTED);
        }
        try {
            Room room = this.repository.getRoom(toJid.getBareJID());
            if (room == null) {
                throw new ComponentException(Authorization.ITEM_NOT_FOUND, "There is no such room.");
            }
            JID fromJid = packet.getStanzaFrom();
            if (!room.isOccupantInRoom(fromJid)) {
                throw new ComponentException(Authorization.FORBIDDEN, "You need to be a room occupant");
            }
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Exception loading room " + toJid.getBareJID() + " from repository", ex);
        }
        super.process(packet);
    }
}

