/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.Optional;
import tigase.component.exceptions.RepositoryException;
import tigase.form.Form;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.muc.MUCComponent;
import tigase.muc.MUCConfig;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.exceptions.MUCException;
import tigase.muc.repository.IMucRepository;
import tigase.server.BasicComponent;
import tigase.server.CmdAcl;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="permissionChecker", parent=MUCComponent.class, active=true, exportable=true)
public class PermissionChecker {
    @Inject(nullAllowed=true, bean="service")
    private BasicComponent component;
    @Inject
    private MUCConfig config;
    @Inject
    private IMucRepository mucRepository;

    public void checkCreatePermission(BareJID roomJID, JID senderJid, Form roomConfiguration) throws MUCException, RepositoryException {
        RoomConfig roomConfig = this.mucRepository.getDefaultRoomConfig().clone();
        if (roomConfiguration != null) {
            roomConfig.copyFrom(roomConfiguration, false);
        }
        if (roomConfig.isRoomconfigPublicroom() && !this.checkAcl(roomJID, senderJid, this.config.getPublicRoomCreationAcl())) {
            throw new MUCException(Authorization.FORBIDDEN, "You don't have enough permissions to create public room");
        }
        if (!this.checkAcl(roomJID, senderJid, this.config.getHiddenRoomCreationAcl())) {
            throw new MUCException(Authorization.FORBIDDEN, "You don't have enough permissions to create hidden room");
        }
    }

    public void checkUpdateVisibilityPermission(Room room, JID senderJid, Form form) throws MUCException {
        Boolean willBePublic = form.getAsBoolean("muc#roomconfig_publicroom");
        if (willBePublic != null && room.getConfig().isRoomconfigPublicroom() != willBePublic.booleanValue() && willBePublic.booleanValue() && !this.checkAcl(room.getRoomJID(), senderJid, this.config.getPublicRoomCreationAcl())) {
            throw new MUCException(Authorization.FORBIDDEN, "You don't have enough permissions to make room public");
        }
    }

    private boolean checkAcl(BareJID roomJID, JID senderJid, CmdAcl.Type type) {
        switch (type) {
            case ALL: {
                return true;
            }
            case LOCAL: {
                return this.component.isLocalDomain(senderJid.getDomain());
            }
            case ADMIN: {
                return this.component.isAdmin(senderJid);
            }
            case DOMAIN: {
                String domain = roomJID.getDomain().substring(this.component.getName().length() + 1);
                return domain.equals(senderJid.getDomain());
            }
            case DOMAIN_ADMIN: {
                String domain = roomJID.getDomain().substring(this.component.getName().length() + 1);
                return Optional.ofNullable(this.component.getVHostItem(domain)).filter(vhost -> vhost.isAdmin(senderJid.toString())).isPresent() || this.component.isAdmin(senderJid);
            }
            case DOMAIN_OWNER: {
                String domain = roomJID.getDomain().substring(this.component.getName().length() + 1);
                return Optional.ofNullable(this.component.getVHostItem(domain)).filter(vhost -> vhost.isOwner(senderJid.toString())).isPresent();
            }
        }
        return false;
    }
}

