/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.component.DSLBeanConfigurator;
import tigase.component.PacketWriter;
import tigase.component.exceptions.RepositoryException;
import tigase.component.responses.AsyncCallback;
import tigase.component.responses.ResponseManager;
import tigase.conf.ConfigWriter;
import tigase.conf.ConfigurationException;
import tigase.db.beans.DataSourceBean;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.core.Kernel;
import tigase.muc.MockMucRepository;
import tigase.muc.Room;
import tigase.muc.TestMUCCompoent;
import tigase.server.CmdAcl;
import tigase.server.Packet;
import tigase.test.junit.JUnitXMLIO;
import tigase.test.junit.XMPPTestCase;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class RoomTest
extends XMPPTestCase {
    private TestMUCCompoent muc;
    private JUnitXMLIO xmlio;

    @Before
    public void init() throws RepositoryException, TigaseStringprepException, ConfigurationException {
        Kernel kernel = new Kernel();
        kernel.registerBean(DefaultTypesConverter.class).exportable().exec();
        kernel.registerBean("defaultBeanConfigurator").asClass(DSLBeanConfigurator.class).exportable().exec();
        Map<String, Object> props = new HashMap<String, Object>();
        props.put("muc/multi-user-chat", BareJID.bareJIDInstance((String)"multi-user-chat"));
        props.put("muc/message-filter-enabled", Boolean.TRUE);
        props.put("muc/presence-filter-enabled", Boolean.FALSE);
        props.put("muc/room-log-directory", "./");
        props.put("muc/hidden-room-creation-acl", CmdAcl.Type.ALL);
        props.put("muc/public-room-creation-acl", CmdAcl.Type.ALL);
        props = ConfigWriter.buildTree(props);
        ((DSLBeanConfigurator)kernel.getInstance(DSLBeanConfigurator.class)).setProperties(props);
        kernel.registerBean("eventBus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
        kernel.registerBean("dataSourceBean").asClass(DataSourceBean.class).exportable().exec();
        kernel.registerBean("mucRepository").asInstance((Object)new MockMucRepository()).exportable().exec();
        kernel.registerBean("muc").asClass(TestMUCCompoent.class).exec();
        this.muc = (TestMUCCompoent)((Object)kernel.getInstance(TestMUCCompoent.class));
        ResponseManager rm = (ResponseManager)((Kernel)kernel.getInstance("muc#KERNEL")).getInstance(ResponseManager.class);
        final ArrayWriter writer = new ArrayWriter(rm);
        ((Kernel)kernel.getInstance("muc#KERNEL")).registerBean("writer").asInstance((Object)writer).exec();
        this.xmlio = new JUnitXMLIO(){

            public void close() {
            }

            public void setIgnorePresence(boolean arg0) {
            }

            public void write(Element data) throws IOException {
                try {
                    writer.clear();
                    Packet p = Packet.packetInstance((Element)data);
                    p.setXMLNS("jabber:client");
                    RoomTest.this.muc.processPacket(p);
                    this.send(writer.getElements());
                }
                catch (TigaseStringprepException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    @Test
    public void test_destroyRoom() {
        RoomTest.test((String)"src/test/scripts/destroying-room.cor", (JUnitXMLIO)this.xmlio);
        try {
            Room room = this.muc.getMucRepository().getRoom(BareJID.bareJIDInstance((String)"darkcave@macbeth.shakespeare.lit"));
            Assert.assertNull((String)"Room should be destroyed", (Object)room);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void test_getting_members_list() {
        RoomTest.test((String)"src/test/scripts/gettingMembersList-ext.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_ghostUser() {
        RoomTest.test((String)"src/test/scripts/ghostUser.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_mucSelfPing() {
        RoomTest.test((String)"src/test/scripts/selfPing.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_hiddenRoomProblem() {
        RoomTest.test((String)"src/test/scripts/hidden-room-problem.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_invitations_allowed() {
        RoomTest.test((String)"src/test/scripts/invitation_allowed.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_invitations_allowed_membersonly() {
        RoomTest.test((String)"src/test/scripts/invitation_allowed_membersonly.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_invitations_notallowed() {
        RoomTest.test((String)"src/test/scripts/invitation_not_allowed.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_invitations_notallowed_membersonly() {
        RoomTest.test((String)"src/test/scripts/invitation_not_allowed_membersonly.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_members_only_subject() {
        RoomTest.test((String)"src/test/scripts/members-only-subject.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_messages() {
        RoomTest.test((String)"src/test/scripts/messagesGroupchat.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_nonpersistentRoomProblem() {
        RoomTest.test((String)"src/test/scripts/nonpersistent-room-problem.cor", (JUnitXMLIO)this.xmlio);
        try {
            Room room = this.muc.getMucRepository().getRoom(BareJID.bareJIDInstance((String)"darkcave@macbeth.shakespeare.lit"));
            Assert.assertNull((String)"Room should be destroyed", (Object)room);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void test_pings() {
        RoomTest.test((String)"src/test/scripts/ping.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_presences2() {
        RoomTest.test((String)"src/test/scripts/processPresence2.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_presences2_exiting() throws Exception {
        RoomTest.test((String)"src/test/scripts/processPresence2-exiting.cor", (JUnitXMLIO)this.xmlio);
        Room room = this.muc.getMucRepository().getRoom(BareJID.bareJIDInstanceNS((String)"darkcave@macbeth.shakespeare.lit"));
        Assert.assertNotNull((Object)room);
        Collection nicknames = room.getOccupantsNicknames(false);
        Assert.assertEquals((long)1L, (long)nicknames.size());
        Assert.assertTrue((boolean)nicknames.contains("firstwitch"));
        Assert.assertEquals((Object)"firstwitch", (Object)room.getOccupantsNickname(JID.jidInstanceNS((String)"crone1@shakespeare.lit/desktop")));
        Assert.assertEquals((Object)BareJID.bareJIDInstance((String)"crone1@shakespeare.lit"), (Object)room.getOccupantsJidByNickname("firstwitch"));
    }

    @Test
    public void test_presences2_non_anonymous() {
        RoomTest.test((String)"src/test/scripts/processPresence2-nonanonymous.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_room_config() {
        RoomTest.test((String)"src/test/scripts/room-configuration.cor", (JUnitXMLIO)this.xmlio);
    }

    static class ArrayWriter
    implements PacketWriter {
        private final ArrayList<Element> elements = new ArrayList();
        private final ResponseManager responseManager;

        public ArrayWriter(ResponseManager responseManager) {
            this.responseManager = responseManager;
        }

        public void clear() {
            this.elements.clear();
        }

        public ArrayList<Element> getElements() {
            return this.elements;
        }

        public void write(Collection<Packet> elements) {
            for (Packet packet : elements) {
                this.elements.add(packet.getElement());
            }
        }

        public void write(Packet element) {
            this.elements.add(element.getElement());
        }

        public void write(Packet packet, AsyncCallback callback) {
            this.responseManager.registerResponseHandler(packet, Long.valueOf(60000L), callback);
            this.write(packet);
        }
    }
}

