/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import tigase.component.DSLBeanConfigurator;
import tigase.component.PacketWriter;
import tigase.component.exceptions.RepositoryException;
import tigase.component.responses.AsyncCallback;
import tigase.conf.ConfigWriter;
import tigase.conf.ConfigurationException;
import tigase.db.beans.DataSourceBean;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.core.Kernel;
import tigase.muc.MUCComponent;
import tigase.muc.MockMucRepository;
import tigase.muc.TestMUCCompoent;
import tigase.server.CmdAcl;
import tigase.server.Packet;
import tigase.test.junit.JUnitXMLIO;
import tigase.test.junit.XMPPTestCase;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;

public class PresenceTestNAMultiPresenceTest
extends XMPPTestCase {
    private MUCComponent pubsub;
    private JUnitXMLIO xmlio;

    @Before
    public void init() throws RepositoryException, TigaseStringprepException, ConfigurationException {
        Kernel kernel = new Kernel();
        kernel.registerBean(DefaultTypesConverter.class).exportable().exec();
        kernel.registerBean("defaultBeanConfigurator").asClass(DSLBeanConfigurator.class).exportable().exec();
        Map<String, Object> props = new HashMap<String, Object>();
        props.put("muc/multi-user-chat", BareJID.bareJIDInstance((String)"multi-user-chat"));
        props.put("muc/message-filter-enabled", Boolean.TRUE);
        props.put("muc/presence-filter-enabled", Boolean.FALSE);
        props.put("muc/room-log-directory", "./");
        props.put("muc/hidden-room-creation-acl", CmdAcl.Type.ALL);
        props.put("muc/public-room-creation-acl", CmdAcl.Type.ALL);
        props = ConfigWriter.buildTree(props);
        ((DSLBeanConfigurator)kernel.getInstance(DSLBeanConfigurator.class)).setProperties(props);
        kernel.registerBean("eventBus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
        kernel.registerBean("dataSourceBean").asClass(DataSourceBean.class).exportable().exec();
        kernel.registerBean("mucRepository").asInstance((Object)new MockMucRepository()).exportable().exec();
        final ArrayWriter writer = new ArrayWriter();
        kernel.registerBean("muc").asClass(TestMUCCompoent.class).exec();
        this.pubsub = (MUCComponent)kernel.getInstance(TestMUCCompoent.class);
        ((Kernel)kernel.getInstance("muc#KERNEL")).registerBean("writer").asInstance((Object)writer).exec();
        this.xmlio = new JUnitXMLIO(){

            public void close() {
            }

            public void setIgnorePresence(boolean arg0) {
            }

            public void write(Element data) throws IOException {
                try {
                    writer.clear();
                    Packet p = Packet.packetInstance((Element)data);
                    p.setXMLNS("jabber:client");
                    PresenceTestNAMultiPresenceTest.this.pubsub.processPacket(p);
                    this.send(writer.elements);
                }
                catch (TigaseStringprepException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    @Test
    public void test_presences2_non_anonymous() {
        PresenceTestNAMultiPresenceTest.test((String)"src/test/scripts/processPresence2-nonanonymous-multipresence.cor", (JUnitXMLIO)this.xmlio);
    }

    private final class ArrayWriter
    implements PacketWriter {
        private final ArrayList<Element> elements = new ArrayList();

        private ArrayWriter() {
        }

        public void clear() {
            this.elements.clear();
        }

        public void write(Collection<Packet> elements) {
            for (Packet packet : elements) {
                this.elements.add(packet.getElement());
            }
        }

        public void write(Packet element) {
            this.elements.add(element.getElement());
        }

        public void write(Packet packet, AsyncCallback callback) {
            this.write(packet);
        }
    }
}

