/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import tigase.muc.Affiliation;

public class RoomAffiliation {
    public static final RoomAffiliation none = new RoomAffiliation(Affiliation.none, false, null);
    public static final RoomAffiliation outcast = new RoomAffiliation(Affiliation.outcast, false, null);
    public static final RoomAffiliation member = new RoomAffiliation(Affiliation.member, false, null);
    public static final RoomAffiliation admin = new RoomAffiliation(Affiliation.admin, false, null);
    public static final RoomAffiliation owner = new RoomAffiliation(Affiliation.owner, false, null);
    public static final RoomAffiliation memberPersistent = new RoomAffiliation(Affiliation.member, true, null);
    public static final RoomAffiliation adminPersistent = new RoomAffiliation(Affiliation.admin, true, null);
    public static final RoomAffiliation ownerPersistent = new RoomAffiliation(Affiliation.owner, true, null);
    private final Affiliation affiliation;
    private final String nickname;
    private final boolean persistentOccupant;

    public static RoomAffiliation from(Affiliation affiliation, boolean persistentOccupant, String nickname) {
        if (nickname != null) {
            return new RoomAffiliation(affiliation, persistentOccupant, nickname);
        }
        if (persistentOccupant) {
            switch (affiliation) {
                case admin: {
                    return adminPersistent;
                }
                case member: {
                    return memberPersistent;
                }
                case owner: {
                    return ownerPersistent;
                }
                case none: {
                    return none;
                }
                case outcast: {
                    return outcast;
                }
            }
        } else {
            switch (affiliation) {
                case admin: {
                    return admin;
                }
                case member: {
                    return member;
                }
                case none: {
                    return none;
                }
                case outcast: {
                    return outcast;
                }
                case owner: {
                    return owner;
                }
            }
        }
        throw new IllegalArgumentException();
    }

    private RoomAffiliation(Affiliation affiliation, boolean persistentOccupant, String nickname) {
        this.affiliation = affiliation;
        this.nickname = nickname;
        this.persistentOccupant = persistentOccupant;
    }

    public Affiliation getAffiliation() {
        return this.affiliation;
    }

    public boolean isPersistentOccupant() {
        return this.persistentOccupant;
    }

    public String getRegisteredNickname() {
        return this.nickname;
    }

    public String toString() {
        return "[aff: " + this.affiliation.name() + ",persistent: " + this.persistentOccupant + ",nickname: " + this.nickname + "]";
    }
}

