/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.repository;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import tigase.component.exceptions.RepositoryException;
import tigase.db.AbstractDataSourceAwareTestCase;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceAware;
import tigase.kernel.core.Kernel;
import tigase.muc.Affiliation;
import tigase.muc.MUCConfig;
import tigase.muc.Room;
import tigase.muc.RoomAffiliation;
import tigase.muc.RoomConfig;
import tigase.muc.RoomWithId;
import tigase.muc.repository.IMucDAO;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class AbstractMucDAOTest<DS extends DataSource>
extends AbstractDataSourceAwareTestCase<DS, IMucDAO> {
    protected static JID adminJID = JID.jidInstanceNS((String)UUID.randomUUID().toString(), (String)"test.local", (String)UUID.randomUUID().toString());
    protected static Date creationDate = null;
    protected static JID creatorJID = JID.jidInstanceNS((String)UUID.randomUUID().toString(), (String)"test.local", (String)UUID.randomUUID().toString());
    protected static String emoji = "\ud83d\ude97\ud83d\udca9\ud83d\ude21";
    protected static BareJID roomJID = BareJID.bareJIDInstanceNS((String)UUID.randomUUID().toString(), (String)"muc.test.local");
    protected boolean checkEmoji = true;
    protected IMucDAO dao;
    protected Room.RoomFactory roomFactory;

    @Before
    public void setup() throws RepositoryException, DBInitException, IllegalAccessException, InstantiationException {
        this.roomFactory = (Room.RoomFactory)this.getInstance(Room.RoomFactory.class);
        this.dao = (IMucDAO)this.getDataSourceAware();
    }

    @After
    public void tearDown() {
        this.dao = null;
    }

    @Test
    public void test1_createRoomWithAffiliation() throws RepositoryException {
        RoomConfig rc = new RoomConfig(roomJID);
        rc.setValue("muc#roomconfig_persistentroom", (Object)Boolean.TRUE);
        String roomName = roomJID.getLocalpart();
        if (this.checkEmoji) {
            roomName = roomName + emoji;
        }
        rc.setValue("muc#roomconfig_roomname", (Object)roomName);
        creationDate = new Date();
        RoomWithId room = this.roomFactory.newInstance(null, rc, creationDate, creatorJID.getBareJID());
        room.addAffiliationByJid(creatorJID.getBareJID(), RoomAffiliation.owner);
        Object roomId = this.dao.createRoom(room);
        Assert.assertNotNull((Object)room.getId());
        Assert.assertNotNull((Object)roomId);
        Assert.assertEquals((Object)roomId, (Object)room.getId());
        Assert.assertNotNull((Object)this.dao.getRoom(roomJID));
        Map affiliations = this.dao.getAffiliations(room);
        Assert.assertNotNull((Object)affiliations);
        Assert.assertEquals((Object)Affiliation.owner, affiliations.get(creatorJID.getBareJID()));
    }

    @Test
    public void test2_getRoom() throws RepositoryException {
        RoomWithId room = this.dao.getRoom(roomJID);
        room.setAffiliations(this.dao.getAffiliations(room));
        Assert.assertNotNull((Object)room);
        Assert.assertNotNull((Object)room.getId());
        if (this.checkEmoji) {
            Assert.assertTrue((boolean)room.getConfig().getRoomName().contains(emoji));
        }
        Assert.assertEquals((Object)roomJID, (Object)room.getRoomJID());
        Assert.assertEquals((long)(creationDate.getTime() / 10L), (long)(room.getCreationDate().getTime() / 10L));
        Assert.assertEquals((Object)creatorJID.getBareJID(), (Object)room.getCreatorJid());
        Assert.assertEquals((Object)Affiliation.owner, (Object)room.getAffiliation(creatorJID.getBareJID()));
        Assert.assertEquals((long)1L, (long)room.getAffiliations().size());
    }

    @Test
    public void test3_setRoomAffiliation() throws RepositoryException {
        RoomWithId room = this.dao.getRoom(roomJID);
        room.setAffiliations(this.dao.getAffiliations(room));
        room.addAffiliationByJid(adminJID.getBareJID(), RoomAffiliation.admin);
        this.dao.setAffiliation(room, adminJID.getBareJID(), RoomAffiliation.admin);
        HashMap roomAffiliations = new HashMap();
        room.getAffiliations().forEach(jid -> roomAffiliations.put(jid, room.getAffiliation(jid).getAffiliation()));
        Assert.assertEquals(roomAffiliations, (Object)this.dao.getAffiliations(room));
        room.addAffiliationByJid(adminJID.getBareJID(), RoomAffiliation.none);
        this.dao.setAffiliation(room, adminJID.getBareJID(), RoomAffiliation.none);
        roomAffiliations.clear();
        room.getAffiliations().forEach(jid -> roomAffiliations.put(jid, room.getAffiliation(jid).getAffiliation()));
        Assert.assertEquals(roomAffiliations, (Object)this.dao.getAffiliations(room));
    }

    @Test
    public void test4_getRoomJids() throws RepositoryException {
        Assert.assertTrue((boolean)this.dao.getRoomsJIDList().contains(roomJID));
    }

    @Test
    public void test5_setRoomSubject() throws RepositoryException {
        RoomWithId room = this.dao.getRoom(roomJID);
        String subject = UUID.randomUUID().toString();
        if (this.checkEmoji) {
            subject = subject + emoji;
        }
        Date changeDate = new Date();
        this.dao.setSubject(room, subject, adminJID.getResource(), changeDate);
        room = this.dao.getRoom(roomJID);
        Assert.assertEquals((Object)subject, (Object)room.getSubject());
        Assert.assertEquals((Object)adminJID.getResource(), (Object)room.getSubjectChangerNick());
        Assert.assertEquals((long)(changeDate.getTime() / 10L), (long)(room.getSubjectChangeDate().getTime() / 10L));
    }

    @Test
    public void test6_updateRoomConfig() throws RepositoryException {
        RoomWithId room = this.dao.getRoom(roomJID);
        RoomConfig roomConfig = room.getConfig();
        Assert.assertNull((Object)roomConfig.getMaxUsers());
        roomConfig.setValue("muc#roomconfig_maxusers", (Object)"10");
        String roomName = roomJID.getLocalpart().toUpperCase();
        if (this.checkEmoji) {
            roomName = roomName + emoji;
        }
        roomConfig.setValue("muc#roomconfig_roomname", (Object)roomName);
        this.dao.updateRoomConfig(roomConfig);
        room = this.dao.getRoom(roomJID);
        Assert.assertEquals((Object)10, (Object)room.getConfig().getMaxUsers());
        Assert.assertEquals((Object)roomName, (Object)room.getConfig().getRoomName());
    }

    @Test
    public void test7_destroyRoom() throws RepositoryException {
        Assert.assertTrue((boolean)this.dao.getRoomsJIDList().contains(roomJID));
        this.dao.destroyRoom(roomJID);
        Assert.assertFalse((boolean)this.dao.getRoomsJIDList().contains(roomJID));
        Assert.assertNull((Object)this.dao.getRoom(roomJID));
    }

    protected Class<? extends DataSourceAware> getDataSourceAwareIfc() {
        return IMucDAO.class;
    }

    protected void registerBeans(Kernel kernel) {
        super.registerBeans(kernel);
        kernel.registerBean(Room.RoomFactoryImpl.class).exec();
        kernel.registerBean(MUCConfig.class).exec();
    }
}

