/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules.selfping;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tigase.muc.modules.selfping.SelfPingerMonitor;
import tigase.xmpp.jid.JID;

public class Request {
    private final String id;
    private final JID jid;
    private final JID jidTo;
    private final SelfPingerMonitor monitor;
    private final Map<String, JID> subrequests = new ConcurrentHashMap<String, JID>();
    private final long timestampt = System.currentTimeMillis();
    private long requestsCounter = 0L;
    private long resultErrorCounter = 0L;
    private long resultOkCounter = 0L;
    private long resultTimeoutCounter = 0L;

    public Request(SelfPingerMonitor monitor, JID jid, JID to, String id) {
        this.monitor = monitor;
        this.jid = jid;
        this.jidTo = to;
        this.id = id;
    }

    public JID getJidTo() {
        return this.jidTo;
    }

    public long getResultErrorCounter() {
        return this.resultErrorCounter;
    }

    public long getResultOkCounter() {
        return this.resultOkCounter;
    }

    public long getNoResultCounter() {
        return this.subrequests.size();
    }

    public String getId() {
        return this.id;
    }

    public JID getJid() {
        return this.jid;
    }

    public long getTimestampt() {
        return this.timestampt;
    }

    public void registerRequest(JID jid, String stanzaId) {
        String key = SelfPingerMonitor.key(jid, stanzaId);
        this.subrequests.put(key, jid);
        this.monitor.registerSubRequest(key, this);
        ++this.requestsCounter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Request)) {
            return false;
        }
        Request request = (Request)o;
        if (!this.id.equals(request.id)) {
            return false;
        }
        return this.jid.equals((Object)request.jid);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.jid.hashCode();
        return result;
    }

    public Collection<JID> getTimeoutedJIDs() {
        return Collections.unmodifiableCollection(this.subrequests.values());
    }

    public void registerResponse(JID jid, String stanzaId, Result result) {
        String key = SelfPingerMonitor.key(jid, stanzaId);
        if (this.subrequests.containsKey(key)) {
            switch (result) {
                case Ok: {
                    ++this.resultOkCounter;
                    this.subrequests.remove(key);
                    break;
                }
                case Error: {
                    ++this.resultErrorCounter;
                    this.subrequests.remove(key);
                    this.monitor.kickOut(jid);
                    break;
                }
                case Timeout: {
                    ++this.resultTimeoutCounter;
                    this.monitor.kickOut(jid);
                }
            }
        }
        if (this.subrequests.isEmpty() || this.resultOkCounter + this.resultErrorCounter + this.resultTimeoutCounter == this.requestsCounter) {
            this.monitor.finish(this);
        }
    }

    public static enum Result {
        Ok,
        Error,
        Timeout;

    }
}

