/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.script.Bindings;
import tigase.component.AbstractKernelBasedComponent;
import tigase.component.exceptions.RepositoryException;
import tigase.component.modules.impl.AdHocCommandModule;
import tigase.component.modules.impl.JabberVersionModule;
import tigase.form.Field;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.config.ConfigField;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.core.Kernel;
import tigase.muc.Ghostbuster2;
import tigase.muc.RoomConfig;
import tigase.muc.modules.GroupchatMessageModule;
import tigase.muc.modules.IqStanzaForwarderModule;
import tigase.muc.modules.MAMQueryModule;
import tigase.muc.modules.MediatedInvitationModule;
import tigase.muc.modules.ModeratorModule;
import tigase.muc.modules.PrivateMessageModule;
import tigase.muc.modules.RoomConfigurationModule;
import tigase.muc.modules.UniqueRoomNameModule;
import tigase.muc.modules.VCardModule;
import tigase.muc.modules.selfping.SelfPingModule;
import tigase.muc.modules.selfping.SelfPingerMonitor;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.xmpp.mam.MAMItemHandler;
import tigase.xmpp.mam.MAMQueryParser;
import tigase.xmpp.mam.modules.GetFormModule;

@Bean(name="muc", parent=Kernel.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode})
@ClusterModeRequired(active=false)
public class MUCComponent
extends AbstractKernelBasedComponent {
    public static final String DEFAULT_ROOM_CONFIG_KEY = "default_room_config";
    public static final String DEFAULT_ROOM_CONFIG_PREFIX_KEY = "default_room_config/";
    @ConfigField(alias="default_room_config", desc="Default room configuration", allowAliasFromParent=false)
    private HashMap<String, String> defaultRoomConfig = new HashMap();
    @Inject
    private Ghostbuster2 ghostbuster;

    protected static void addIfExists(Bindings binds, String name, Object value) {
        if (value != null) {
            binds.put(name, value);
        }
    }

    public String getComponentVersion() {
        String version = ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
        return version == null ? "0.0.0" : version;
    }

    public String getDiscoCategory() {
        return "conference";
    }

    public String getDiscoCategoryType() {
        return "text";
    }

    public String getDiscoDescription() {
        return "Multi User Chat";
    }

    public int hashCodeForPacket(Packet packet) {
        if (packet.getStanzaFrom() != null && packet.getPacketFrom() != null && !this.getComponentId().equals((Object)packet.getPacketFrom())) {
            return packet.getStanzaFrom().hashCode();
        }
        if (packet.getStanzaTo() != null) {
            return packet.getStanzaTo().hashCode();
        }
        return 1;
    }

    public boolean isDiscoNonAdmin() {
        return true;
    }

    public boolean isSubdomain() {
        return true;
    }

    public void processPacket(Packet packet) {
        if (this.ghostbuster != null) {
            try {
                this.ghostbuster.update(packet);
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "There is no Dana, there is only Zuul", e);
            }
        }
        super.processPacket(packet);
    }

    public int processingInThreads() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    public int processingOutThreads() {
        return Runtime.getRuntime().availableProcessors() * 4;
    }

    public void initialize() {
        try {
            this.updateDefaultRoomConfig();
        }
        catch (Exception ex) {
            this.log.log(Level.FINEST, "Exception during modification of default room config", ex);
        }
        super.initialize();
    }

    protected void registerModules(Kernel kernel) {
        kernel.registerBean(SelfPingerMonitor.class).exec();
        kernel.registerBean(SelfPingModule.class).exec();
        kernel.registerBean(JabberVersionModule.class).exec();
        kernel.registerBean(GroupchatMessageModule.class).exec();
        kernel.registerBean(IqStanzaForwarderModule.class).exec();
        kernel.registerBean(MediatedInvitationModule.class).exec();
        kernel.registerBean(ModeratorModule.class).exec();
        kernel.registerBean(PrivateMessageModule.class).exec();
        kernel.registerBean(RoomConfigurationModule.class).exec();
        kernel.registerBean(UniqueRoomNameModule.class).exec();
        kernel.registerBean(AdHocCommandModule.class).exec();
        kernel.registerBean(MAMItemHandler.class).exec();
        kernel.registerBean(MAMQueryParser.class).exec();
        kernel.registerBean(MAMQueryModule.class).exec();
        kernel.registerBean(GetFormModule.class).exec();
        kernel.registerBean(VCardModule.class).exec();
        kernel.registerBean(Ghostbuster2.class).exec();
    }

    private void updateDefaultRoomConfig() throws RepositoryException {
        IMucRepository mucRepository = (IMucRepository)this.kernel.getInstance(IMucRepository.class);
        if (this.defaultRoomConfig.isEmpty()) {
            return;
        }
        this.log.config("Updating Default Room Config");
        RoomConfig defaultRoomConfig = mucRepository.getDefaultRoomConfig();
        boolean changed = false;
        for (Map.Entry<String, String> x : this.defaultRoomConfig.entrySet()) {
            String var = x.getKey();
            Field field = defaultRoomConfig.getConfigForm().get(var);
            if (field != null) {
                changed = true;
                String[] values = x.getValue().split(",");
                field.setValues(values);
                continue;
            }
            if (!this.log.isLoggable(Level.WARNING)) continue;
            this.log.warning("Default config room doesn't contains variable '" + var + "'!");
        }
        if (changed) {
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("Default room configuration is udpated");
            }
            mucRepository.updateDefaultRoomConfig(defaultRoomConfig);
        }
    }
}

