/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.repository.migration;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.DSLBeanConfigurator;
import tigase.component.exceptions.RepositoryException;
import tigase.conf.ConfiguratorAbstract;
import tigase.db.DataSource;
import tigase.db.DataSourceHelper;
import tigase.db.beans.DataSourceBean;
import tigase.db.beans.UserRepositoryMDPoolBean;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.beans.config.AbstractBeanConfigurator;
import tigase.kernel.core.Kernel;
import tigase.muc.MUCConfig;
import tigase.muc.Room;
import tigase.muc.RoomWithId;
import tigase.muc.repository.IMucDAO;
import tigase.muc.repository.MucDAOOld;
import tigase.xmpp.jid.BareJID;

public class Converter {
    private static final Logger log = Logger.getLogger(Converter.class.getCanonicalName());
    private IMucDAO newRepo;
    private MucDAOOld oldRepo;

    public static void initLogger() {
        String initial_config = "tigase.level=ALL\ntigase.db.jdbc.level=INFO\ntigase.xml.level=INFO\ntigase.form.level=INFO\nhandlers=java.util.logging.ConsoleHandler java.util.logging.FileHandler\njava.util.logging.ConsoleHandler.level=ALL\njava.util.logging.ConsoleHandler.formatter=tigase.util.LogFormatter\njava.util.logging.FileHandler.formatter=tigase.util.LogFormatter\njava.util.logging.FileHandler.pattern=muc_db_migration.log\ntigase.useParentHandlers=true\n";
        ConfiguratorAbstract.loadLogManagerConfig((String)initial_config);
    }

    public static void main(String[] argv) throws IOException {
        Converter.initLogger();
        if (argv == null || argv.length == 0) {
            System.out.println("\nConverter paramters:\n");
            System.out.println(" -in-repo-class tigase.db.jdbc.DataRepositoryImpl                           -      class implementing UserRepository");
            System.out.println(" -in 'jdbc:xxxx://localhost/tigasedb?user=tigase&password=tigase_pass'      -\t\turi of source database");
            System.out.println(" -out 'jdbc:xxxx://localhost/tigasedb?user=tigase&password=tigase_pass'     -\t\turi of destination database");
            return;
        }
        Converter converter = new Converter();
        log.config("parsing configuration parameters");
        String repoClass = null;
        String oldRepoUri = null;
        String newRepoUri = null;
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if ("-in".equals(arg)) {
                oldRepoUri = argv[++i];
                continue;
            }
            if ("-out".equals(arg)) {
                newRepoUri = argv[++i];
                continue;
            }
            if (!"-in-repo-class".equals(arg)) continue;
            repoClass = argv[++i];
        }
        log.config("initializing converter");
        try {
            converter.init(repoClass, oldRepoUri, newRepoUri);
            log.info("starting migration");
            converter.convert();
            log.info("migration finished");
            System.exit(0);
        }
        catch (RepositoryException e) {
            log.info("Migration failed");
            System.exit(1);
        }
    }

    public void convert() throws RepositoryException {
        this.oldRepo.getRoomsJIDList().forEach(roomJid -> {
            try {
                RoomWithId room = (RoomWithId)this.oldRepo.readRoom((BareJID)roomJid);
                String subject = this.oldRepo.getSubject((BareJID)roomJid);
                Date subjectDate = this.oldRepo.getSubjectCreationDate((BareJID)roomJid);
                String subjectNick = this.oldRepo.getSubjectCreatorNickname((BareJID)roomJid);
                if (room == null || room.getConfig() == null) {
                    log.log(Level.WARNING, "skipping conversion of room with jid " + roomJid + " - room configuration is missing!");
                    this.oldRepo.destroyRoom((BareJID)roomJid);
                    return;
                }
                if (this.newRepo.getRoom((BareJID)roomJid) != null) {
                    return;
                }
                this.newRepo.createRoom(room);
                if (subjectDate != null) {
                    this.newRepo.setSubject(room, subject, subjectNick, subjectDate);
                }
                this.oldRepo.destroyRoom((BareJID)roomJid);
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Repository conversion failed", e);
            }
        });
    }

    public void init(String repoClass, String oldRepoUri, String newRepoUri) throws RepositoryException {
        Kernel kernel = new Kernel();
        try {
            kernel.registerBean(DefaultTypesConverter.class).exec();
            kernel.registerBean(DSLBeanConfigurator.class).exec();
            DSLBeanConfigurator configurator = (DSLBeanConfigurator)kernel.getInstance(DSLBeanConfigurator.class);
            HashMap props = new HashMap();
            HashMap dataSourceProps = new HashMap();
            HashMap<String, String> defaultProps = new HashMap<String, String>();
            defaultProps.put("uri", oldRepoUri);
            dataSourceProps.put("default", defaultProps);
            AbstractBeanConfigurator.BeanDefinition mucDataSourceProps = new AbstractBeanConfigurator.BeanDefinition();
            mucDataSourceProps.setBeanName("new-repo");
            mucDataSourceProps.put((Object)"uri", (Object)newRepoUri);
            dataSourceProps.put("new-repo", mucDataSourceProps);
            props.put("dataSource", dataSourceProps);
            if (repoClass != null) {
                HashMap userRepo = new HashMap();
                HashMap<String, String> userDefaultProps = new HashMap<String, String>();
                userDefaultProps.put("cls", repoClass);
                userRepo.put("default", userDefaultProps);
                props.put("userRepository", userRepo);
            }
            configurator.setProperties(props);
            kernel.registerBean("eventBus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
            kernel.registerBean(DataSourceBean.class).exportable().exec();
            kernel.registerBean(Room.RoomFactoryImpl.class).exec();
            kernel.registerBean(UserRepositoryMDPoolBean.class).exportable().exec();
            kernel.registerBean("muc-dao-old").asClass(MucDAOOld.class).exec();
            Class daoClass = DataSourceHelper.getDefaultClass(IMucDAO.class, (String)newRepoUri);
            kernel.registerBean(MUCConfig.class).exec();
            kernel.registerBean("muc-dao").asClass(daoClass).exec();
            DataSource ds = ((DataSourceBean)kernel.getInstance("dataSource")).getRepository("new-repo");
            this.oldRepo = (MucDAOOld)kernel.getInstance(MucDAOOld.class);
            this.newRepo = (IMucDAO)kernel.getInstance(IMucDAO.class);
            this.newRepo.setDataSource(ds);
        }
        catch (Exception ex) {
            throw new RepositoryException("could not initialize converter", (Throwable)ex);
        }
    }
}

