/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.security.MessageDigest;
import java.util.logging.Level;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.muc.Affiliation;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractMucModule;
import tigase.muc.modules.GroupchatMessageModule;
import tigase.muc.modules.RoomFeatures;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.util.Algorithms;
import tigase.util.Base64;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="vcard", active=true)
public class VCardModule
extends AbstractMucModule
implements RoomFeatures,
Initializable,
UnregisterAware {
    public static final String ID = "vcard";
    public static final String NAME = "vCard";
    public static final String XMLNS = "vcard-temp";
    private static final Criteria CRIT = new Criteria(){

        public Criteria add(Criteria criteria) {
            return null;
        }

        public boolean match(Element element) {
            try {
                String to = element.getAttributeStaticStr("to");
                return to != null && !JID.jidInstance((String)to).hasResource() && ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)VCardModule.NAME, (String)VCardModule.XMLNS)).match(element);
            }
            catch (TigaseStringprepException e) {
                return false;
            }
        }
    };
    private static final String SEPARATOR = ";";
    @Inject(nullAllowed=false)
    private GroupchatMessageModule messageModule;
    @Inject
    private IMucRepository repository;

    private static String calculatePhotoHash(byte[] photo) {
        if (photo == null) {
            return null;
        }
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            return Algorithms.bytesToHex((byte[])sha.digest(photo));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Photo getPhoto(Packet packet) {
        Element vcard = packet.getElement().getChild(NAME, XMLNS);
        if (vcard == null) {
            return null;
        }
        Element photo = vcard.getChild("PHOTO");
        if (photo == null) {
            return null;
        }
        Element type = photo.getChild("TYPE");
        Element binval = photo.getChild("BINVAL");
        return new Photo(type.getCData(), Base64.decode((String)binval.getCData()));
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public String[] getFeatures() {
        return new String[]{XMLNS};
    }

    @Override
    public String[] getRoomFeatures(Room room) {
        return this.getFeatures();
    }

    public void process(Packet packet) throws ComponentException, TigaseStringprepException {
        block5: {
            try {
                if (packet.getType() == StanzaType.get) {
                    this.processGet(packet);
                    break block5;
                }
                if (packet.getType() == StanzaType.set) {
                    this.processSet(packet);
                    break block5;
                }
                throw new ComponentException(Authorization.BAD_REQUEST);
            }
            catch (MUCException e1) {
                throw e1;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void initialize() {
        this.eventBus.registerEvent(VCardChangedEvent.class.getName(), "FIred when room avatar is changed", false);
        this.eventBus.registerAll((Object)this);
    }

    public void beforeUnregister() {
        this.eventBus.unregisterAll((Object)this);
    }

    @HandleEvent(filter=HandleEvent.Type.remote)
    public void onAvatarChanged(VCardChangedEvent event) {
        try {
            Room room = this.repository.getRoom(event.getRoomJID());
            if (room != null) {
                room.setAvatarHash(event.getHash());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void processGet(Packet packet) throws MUCException, RepositoryException {
        BareJID roomJID = packet.getStanzaTo().getBareJID();
        Room room = this.repository.getRoom(roomJID);
        if (room == null) {
            throw new MUCException(Authorization.ITEM_NOT_FOUND);
        }
        Element vCard = new Element(NAME, new String[]{"xmlns"}, new String[]{XMLNS});
        String encodedAvatar = this.repository.getRoomAvatar(room);
        if (encodedAvatar != null && encodedAvatar.length() > 0) {
            String[] items = encodedAvatar.split(SEPARATOR);
            Element photo = new Element("PHOTO");
            photo.addChild((XMLNodeIfc)new Element("TYPE", items[0]));
            photo.addChild((XMLNodeIfc)new Element("BINVAL", items[1]));
            vCard.addChild((XMLNodeIfc)photo);
        }
        this.write(packet.okResult(vCard, 0));
    }

    private void processSet(Packet packet) throws MUCException, RepositoryException {
        BareJID roomJID = packet.getStanzaTo().getBareJID();
        Room room = this.repository.getRoom(roomJID);
        if (room == null) {
            throw new MUCException(Authorization.ITEM_NOT_FOUND);
        }
        if (!room.getConfig().isPersistentRoom()) {
            throw new MUCException(Authorization.FEATURE_NOT_IMPLEMENTED);
        }
        JID senderJid = packet.getStanzaFrom();
        String nickName = room.getOccupantsNickname(senderJid);
        Affiliation senderAffiliation = room.getAffiliation(senderJid.getBareJID()).getAffiliation();
        if (senderAffiliation != Affiliation.owner) {
            throw new MUCException(Authorization.NOT_ALLOWED);
        }
        Photo photo = VCardModule.getPhoto(packet);
        if (photo != null) {
            String hash = VCardModule.calculatePhotoHash(photo.photo);
            this.repository.updateRoomAvatar(room, photo.type + SEPARATOR + Base64.encode((byte[])photo.photo), hash);
            room.setAvatarHash(hash);
            this.eventBus.fire((Object)new VCardChangedEvent(room.getRoomJID(), hash));
        } else {
            this.repository.updateRoomAvatar(room, null, null);
            room.setAvatarHash(null);
            this.eventBus.fire((Object)new VCardChangedEvent(room.getRoomJID(), null));
        }
        this.write(packet.okResult((Element)null, 0));
        this.sendConfigurationChangeInfo(room);
    }

    private void sendConfigurationChangeInfo(Room room) {
        try {
            Element x = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
            x.addChild((XMLNodeIfc)new Element("status", new String[]{"code"}, new String[]{"104"}));
            this.messageModule.sendMessagesToAllOccupants(room, JID.jidInstance((BareJID)room.getRoomJID()), x);
        }
        catch (TigaseStringprepException e) {
            this.log.log(Level.WARNING, "Invalid JID. ", e);
        }
    }

    public static class VCardChangedEvent {
        private String hash;
        private BareJID roomJID;

        public VCardChangedEvent() {
        }

        public VCardChangedEvent(BareJID roomJID, String hash) {
            this.roomJID = roomJID;
            this.hash = hash;
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public BareJID getRoomJID() {
            return this.roomJID;
        }

        public void setRoomJID(BareJID roomJID) {
            this.roomJID = roomJID;
        }
    }

    private static class Photo {
        private final byte[] photo;
        private final String type;

        public Photo(String type, byte[] photo) {
            this.type = type;
            this.photo = photo;
        }
    }
}

