/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.component.DSLBeanConfigurator;
import tigase.component.exceptions.RepositoryException;
import tigase.conf.ConfigWriter;
import tigase.db.beans.DataSourceBean;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.DefaultTypesConverter;
import tigase.kernel.core.Kernel;
import tigase.muc.Affiliation;
import tigase.muc.MUCComponent;
import tigase.muc.MockMucRepository;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomAffiliation;
import tigase.muc.TestMUCCompoent;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.ModeratorModule;
import tigase.muc.utils.ArrayWriter;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class ModeratorModuleTest {
    private final ModeratorModule m = new ModeratorModule();
    private JID admin;
    private JID member;
    private ModeratorModule moderatorModule;
    private MUCComponent mucComponent;
    private Room room;

    @Before
    public void init() throws RepositoryException, TigaseStringprepException {
        Kernel kernel = new Kernel();
        kernel.registerBean(DefaultTypesConverter.class).exportable().exec();
        kernel.registerBean("defaultBeanConfigurator").asClass(DSLBeanConfigurator.class).exportable().exec();
        Map<String, Object> props = new HashMap<String, Object>();
        props.put("muc/multi-user-chat", BareJID.bareJIDInstance((String)"multi-user-chat"));
        props.put("muc/message-filter-enabled", Boolean.TRUE);
        props.put("muc/presence-filter-enabled", Boolean.FALSE);
        props.put("muc/room-log-directory", "./");
        props = ConfigWriter.buildTree(props);
        ((DSLBeanConfigurator)kernel.getInstance(DSLBeanConfigurator.class)).setProperties(props);
        kernel.registerBean("eventBus").asInstance((Object)EventBusFactory.getInstance()).exportable().exec();
        kernel.registerBean("dataSourceBean").asClass(DataSourceBean.class).exportable().exec();
        kernel.registerBean("mucRepository").asInstance((Object)new MockMucRepository()).exportable().exec();
        ArrayWriter writer = new ArrayWriter();
        kernel.registerBean("muc").asClass(TestMUCCompoent.class).exec();
        this.mucComponent = (MUCComponent)kernel.getInstance(TestMUCCompoent.class);
        ((Kernel)kernel.getInstance("muc#KERNEL")).registerBean("writer").asInstance((Object)writer).exec();
        this.admin = JID.jidInstance((String)"admin@example.com/res1");
        this.member = JID.jidInstance((String)"member@example.com/res1");
        this.room = ((MockMucRepository)kernel.getInstance(MockMucRepository.class)).createNewRoom(BareJID.bareJIDInstance((String)"darkcave@macbeth.shakespeare.lit"), this.admin);
        this.room.addAffiliationByJid(this.admin.getBareJID(), RoomAffiliation.admin);
        this.room.addAffiliationByJid(this.member.getBareJID(), RoomAffiliation.member);
        this.moderatorModule = new ModeratorModule();
    }

    @Test
    public void testCheckItem() throws Exception {
        Element item = new Element("item", new String[]{"jid"}, new String[]{"occupand@b.c"});
        try {
            this.m.checkItem(item, "occupant", Affiliation.none, null, Affiliation.admin, JID.jidInstanceNS((String)"sender@b.c/res"), Role.none, Affiliation.owner);
        }
        catch (MUCException e) {
            Assert.fail((String)("Invalid result: " + e.getMessage()));
        }
        try {
            this.m.checkItem(item, "occupant", Affiliation.none, null, Affiliation.member, JID.jidInstanceNS((String)"sender@b.c/res"), Role.none, Affiliation.admin);
        }
        catch (MUCException e) {
            Assert.fail((String)("Invalid result: " + e.getMessage()));
        }
        try {
            this.m.checkItem(item, "occupant", Affiliation.none, null, Affiliation.admin, JID.jidInstanceNS((String)"sender@b.c/res"), Role.none, Affiliation.admin);
            Assert.fail();
        }
        catch (MUCException e) {
            Assert.assertEquals((Object)Authorization.NOT_ALLOWED, (Object)e.getErrorCondition());
            System.out.println("OK: " + e.getMessage());
        }
        try {
            this.m.checkItem(item, "occupant", Affiliation.none, null, Affiliation.admin, JID.jidInstanceNS((String)"sender@b.c/res"), Role.none, Affiliation.none);
            Assert.fail();
        }
        catch (MUCException e) {
            Assert.assertEquals((Object)Authorization.NOT_ALLOWED, (Object)e.getErrorCondition());
            System.out.println("OK: " + e.getMessage());
        }
        try {
            this.m.checkItem(item, "occupant", Affiliation.none, Role.moderator, null, JID.jidInstanceNS((String)"sender@b.c/res"), Role.none, Affiliation.none);
            Assert.fail();
        }
        catch (MUCException e) {
            Assert.assertEquals((Object)Authorization.NOT_ALLOWED, (Object)e.getErrorCondition());
            System.out.println("OK: " + e.getMessage());
        }
    }

    @Test(expected=MUCException.class)
    public void checkEmptyItem() throws Exception {
        Element item = new Element("item");
        this.moderatorModule.checkItem(this.room, item, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test(expected=MUCException.class)
    public void checkModifyVoiceItemRoleWithoutNick() throws Exception {
        Element item1 = new Element("item", new String[]{"jid", "role"}, new String[]{"member@example.com", Role.participant.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test(expected=MUCException.class)
    public void checkModifyVoiceItemRoleWithoutNickAndWithAffiliation() throws Exception {
        Element item1 = new Element("item", new String[]{"role", "affiliation"}, new String[]{Role.none.toString(), Affiliation.owner.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test(expected=MUCException.class)
    public void checkModifyVoiceItemRoleOnly() throws Exception {
        Element item1 = new Element("item", new String[]{"role"}, new String[]{Role.participant.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test(expected=MUCException.class)
    public void checkModifyOwnerItemAffiliationWithoutJid() throws Exception {
        Element item1 = new Element("item", new String[]{"nick", "affiliation"}, new String[]{"member_user", Affiliation.owner.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test(expected=MUCException.class)
    public void checkModifyOwnerItemAffiliationOnly() throws Exception {
        Element item1 = new Element("item", new String[]{"affiliation"}, new String[]{Affiliation.owner.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test
    public void checkModifyVoiceItem() throws Exception {
        Element item1 = new Element("item", new String[]{"nick", "role"}, new String[]{"member_user", Role.participant.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test
    public void checkModifyOwnerItem() throws Exception {
        Element item1 = new Element("item", new String[]{"jid", "affiliation"}, new String[]{"member@example.com", Affiliation.owner.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }
}

