/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.repository.inmemory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.db.UserExistsException;
import tigase.db.UserRepository;
import tigase.eventbus.EventBus;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.muc.Affiliation;
import tigase.muc.MUCComponent;
import tigase.muc.MUCConfig;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.RoomWithId;
import tigase.muc.repository.IMucDAO;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="mucRepository", parent=MUCComponent.class, active=true)
public class InMemoryMucRepository
implements IMucRepository,
Initializable {
    private static final String ROOMS_KEY = "rooms/";
    protected final Map<BareJID, InternalRoom> allRooms = new ConcurrentHashMap<BareJID, InternalRoom>();
    protected final Map<BareJID, RoomWithId> rooms = new ConcurrentHashMap<BareJID, RoomWithId>();
    private final RoomConfig.RoomConfigListener roomConfigListener;
    private final Room.RoomListener roomListener;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    @Inject(nullAllowed=false)
    private IMucDAO dao;
    private RoomConfig defaultConfig;
    @Inject
    private EventBus eventBus;
    @Inject
    private MUCConfig mucConfig;
    @Inject
    private Room.RoomFactory roomFactory;
    @Inject
    private UserRepository userRepository;

    public InMemoryMucRepository() {
        this.roomListener = new Room.RoomListener(){

            @Override
            public void onChangeSubject(Room room, String nick, String newSubject, Date changeDate) {
                try {
                    if (room.getConfig().isPersistentRoom()) {
                        InMemoryMucRepository.this.dao.setSubject((RoomWithId)room, newSubject, nick, changeDate);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void onMessageToOccupants(Room room, JID from, Packet msg) {
            }

            @Override
            public void onSetAffiliation(Room room, BareJID jid, Affiliation newAffiliation) {
                try {
                    RoomWithId roomWithId;
                    if (room.getConfig().isPersistentRoom() && (roomWithId = (RoomWithId)room).getId() != null) {
                        InMemoryMucRepository.this.dao.setAffiliation(roomWithId, jid, newAffiliation);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.roomConfigListener = new RoomConfig.RoomConfigListener(){

            @Override
            public void onConfigChanged(RoomConfig roomConfig, Set<String> modifiedVars) {
                InMemoryMucRepository.this.roomConfigChanged(roomConfig, modifiedVars);
            }

            @Override
            public void onInitialRoomConfig(RoomConfig roomConfig) {
                try {
                    if (roomConfig.isPersistentRoom()) {
                        Room room = InMemoryMucRepository.this.getRoom(roomConfig.getRoomJID());
                        InMemoryMucRepository.this.dao.createRoom((RoomWithId)room);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Override
    public Room createNewRoom(BareJID roomJID, JID senderJid) throws RepositoryException {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Creating new room '" + roomJID + "'");
        }
        RoomConfig rc = new RoomConfig(roomJID);
        rc.copyFrom(this.getDefaultRoomConfig(), false);
        RoomWithId<Object> room = this.roomFactory.newInstance(null, rc, new Date(), senderJid.getBareJID());
        room.getConfig().addListener(this.roomConfigListener);
        room.addListener(this.roomListener);
        this.rooms.put(roomJID, room);
        InternalRoom ir = new InternalRoom();
        ir.isPersistent = room.getConfig().isPersistentRoom();
        ir.isPublic = room.getConfig().isRoomconfigPublicroom();
        this.addToAllRooms(roomJID, ir);
        return room;
    }

    @Override
    public void destroyRoom(Room room, Element destroyElement) throws RepositoryException {
        BareJID roomJID = room.getRoomJID();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Destroying room '" + roomJID);
        }
        this.rooms.remove(roomJID);
        this.removeFromAllRooms(roomJID);
        this.dao.destroyRoom(roomJID);
        this.fireDestroyRoom(room);
    }

    @Override
    public Map<BareJID, Room> getActiveRooms() {
        return Collections.unmodifiableMap(this.rooms);
    }

    @Override
    public RoomConfig getDefaultRoomConfig() throws RepositoryException {
        if (this.defaultConfig == null) {
            this.defaultConfig = new RoomConfig(null);
            try {
                this.defaultConfig.read(this.userRepository, this.mucConfig, "rooms/default_room_config/config");
            }
            catch (Exception e) {
                this.log.log(Level.FINEST, "Error reading default room configuration", e);
            }
        }
        return this.defaultConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<BareJID, String> getPublicVisibleRooms(String domain) throws RepositoryException {
        HashMap<BareJID, String> result = new HashMap<BareJID, String>();
        for (Map.Entry<BareJID, InternalRoom> entry : this.allRooms.entrySet()) {
            Room room;
            BareJID jid;
            if (entry.getValue().isPublic == null) {
                InternalRoom ir = entry.getValue();
                try {
                    RoomWithId room2 = this.dao.getRoom(entry.getKey());
                    InternalRoom internalRoom = ir;
                    synchronized (internalRoom) {
                        ir.isPublic = room2 == null ? false : room2.getConfig().isRoomconfigPublicroom();
                    }
                }
                catch (RepositoryException ex) {
                    entry.getValue().isPublic = false;
                }
            }
            if (!entry.getValue().isPublic.booleanValue() || !domain.equals((jid = entry.getKey()).getDomain())) continue;
            String name = entry.getValue().name;
            if (name == null && (room = this.getRoom(jid)) != null && (name = room.getConfig().getRoomName()) != null && name.isEmpty()) {
                name = null;
            }
            if (name == null) {
                name = jid.getLocalpart();
            }
            result.put(jid, name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BareJID[] getPublicVisibleRoomsIdList() throws RepositoryException {
        ArrayList<BareJID> result = new ArrayList<BareJID>();
        for (Map.Entry<BareJID, InternalRoom> entry : this.allRooms.entrySet()) {
            if (entry.getValue().isPublic == null) {
                InternalRoom ir = entry.getValue();
                try {
                    RoomWithId room = this.dao.getRoom(entry.getKey());
                    InternalRoom internalRoom = ir;
                    synchronized (internalRoom) {
                        ir.isPublic = room == null ? false : room.getConfig().isRoomconfigPublicroom();
                    }
                }
                catch (RepositoryException ex) {
                    entry.getValue().isPublic = false;
                }
            }
            if (!entry.getValue().isPublic.booleanValue()) continue;
            result.add(entry.getKey());
        }
        return result.toArray(new BareJID[0]);
    }

    @Override
    public Room getRoom(BareJID roomJID) throws RepositoryException {
        RoomWithId room = this.rooms.get(roomJID);
        if (room == null && (room = this.dao.getRoom(roomJID)) != null) {
            room.setAffiliations(this.dao.getAffiliations(room));
            room.getConfig().addListener(this.roomConfigListener);
            room.addListener(this.roomListener);
            this.rooms.put(roomJID, room);
        }
        return room;
    }

    public void initialize() {
        try {
            block9: {
                try {
                    this.getDefaultRoomConfig();
                }
                catch (RepositoryException e) {
                    if (this.userRepository.userExists(this.mucConfig.getServiceName())) break block9;
                    try {
                        this.userRepository.addUser(this.mucConfig.getServiceName());
                    }
                    catch (UserExistsException userExistsException) {
                        // empty catch block
                    }
                }
            }
            List<BareJID> roomJids = this.dao.getRoomsJIDList();
            if (roomJids != null) {
                for (BareJID jid : roomJids) {
                    if (jid.getLocalpart() == null) {
                        this.dao.destroyRoom(jid);
                        continue;
                    }
                    this.addToAllRooms(jid, new InternalRoom());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isRoomIdExists(String newRoomName) {
        return this.allRooms.containsKey(newRoomName);
    }

    @Override
    public void leaveRoom(Room room) {
        BareJID roomJID = room.getRoomJID();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Removing room '" + roomJID + "' from memory");
        }
        this.rooms.remove(roomJID);
        if (!room.getConfig().isPersistentRoom()) {
            this.removeFromAllRooms(roomJID);
        }
        this.fireDestroyRoom(room);
    }

    @Override
    public void updateDefaultRoomConfig(RoomConfig config) throws RepositoryException {
        RoomConfig roomConfig = this.getDefaultRoomConfig();
        roomConfig.copyFrom(config);
        try {
            String roomJID;
            String string = roomJID = roomConfig.getRoomJID() != null ? roomConfig.getRoomJID().toString() : null;
            if (roomJID == null) {
                roomJID = "default_room_config";
            }
            roomConfig.write(this.userRepository, this.mucConfig, ROOMS_KEY + roomJID + "/config");
        }
        catch (Exception e) {
            this.log.log(Level.FINEST, "error during updating default room configuration", e);
            throw new RepositoryException("Room config writing error", (Throwable)e);
        }
    }

    protected void addToAllRooms(BareJID roomJid, InternalRoom internalRoom) {
        this.allRooms.put(roomJid, internalRoom);
    }

    protected void removeFromAllRooms(BareJID roomJid) {
        this.allRooms.remove(roomJid);
    }

    protected void roomConfigChanged(RoomConfig roomConfig, Set<String> modifiedVars) {
        try {
            InternalRoom ir;
            if (modifiedVars.contains("muc#roomconfig_publicroom") && (ir = this.allRooms.get(roomConfig.getRoomJID())) != null) {
                ir.isPublic = roomConfig.isRoomconfigPublicroom();
            }
            if (modifiedVars.contains("muc#roomconfig_roomname") && (ir = this.allRooms.get(roomConfig.getRoomJID())) != null) {
                String name = roomConfig.getRoomName();
                if (name != null && name.isEmpty()) {
                    name = null;
                }
                this.log.log(Level.FINEST, "setting room name '" + name + "'");
                ir.name = name;
            }
            if (modifiedVars.contains("muc#roomconfig_persistentroom")) {
                if (roomConfig.isPersistentRoom()) {
                    Room room = this.getRoom(roomConfig.getRoomJID());
                    this.dao.createRoom((RoomWithId)room);
                } else {
                    this.dao.destroyRoom(roomConfig.getRoomJID());
                }
                ir = this.allRooms.get(roomConfig.getRoomJID());
                if (ir != null) {
                    ir.isPersistent = roomConfig.isPersistentRoom();
                }
            } else if (roomConfig.isPersistentRoom()) {
                this.dao.updateRoomConfig(roomConfig);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void fireDestroyRoom(Room room) {
        Element emptyRoomEvent = new Element("RoomDestroyed", new String[]{"xmlns"}, new String[]{"tigase:events:muc"});
        emptyRoomEvent.addChild((XMLNodeIfc)new Element("room", room.getRoomJID().toString()));
        this.eventBus.fire((Object)emptyRoomEvent);
    }

    public static class InternalRoom {
        public boolean isPersistent = false;
        public Boolean isPublic = null;
        public String name;
    }
}

