/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.repository;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DBInitException;
import tigase.db.DataSource;
import tigase.db.DataSourceHelper;
import tigase.db.beans.MDRepositoryBean;
import tigase.db.beans.MDRepositoryBeanWithStatistics;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.config.ConfigField;
import tigase.muc.Affiliation;
import tigase.muc.MUCComponent;
import tigase.muc.RoomConfig;
import tigase.muc.RoomWithId;
import tigase.muc.repository.IMucDAO;
import tigase.server.BasicComponent;
import tigase.xmpp.jid.BareJID;

@Bean(name="muc-dao", parent=MUCComponent.class, active=true)
public class MucDAOMDBean
extends MDRepositoryBeanWithStatistics<IMucDAO>
implements IMucDAO {
    private static final Logger log = Logger.getLogger(MucDAOMDBean.class.getCanonicalName());
    @ConfigField(desc="Use domain without component name to lookup for repository", alias="map-component-to-bare-domain")
    private boolean mapComponentToBareDomain = false;

    public MucDAOMDBean() {
        super(new Class[]{IMucDAO.class});
    }

    public boolean belongsTo(Class<? extends BasicComponent> component) {
        return MUCComponent.class.isAssignableFrom(component);
    }

    public Object createRoom(RoomWithId room) throws RepositoryException {
        return this.getRepository(room.getRoomJID().getDomain()).createRoom(room);
    }

    @Override
    public void destroyRoom(BareJID roomJID) throws RepositoryException {
        this.getRepository(roomJID.getDomain()).destroyRoom(roomJID);
    }

    public Map<BareJID, Affiliation> getAffiliations(RoomWithId room) throws RepositoryException {
        return this.getRepository(room.getRoomJID().getDomain()).getAffiliations(room);
    }

    public RoomWithId getRoom(BareJID roomJID) throws RepositoryException {
        return this.getRepository(roomJID.getDomain()).getRoom(roomJID);
    }

    @Override
    public List<BareJID> getRoomsJIDList() throws RepositoryException {
        return this.repositoriesStream().flatMap(repo -> {
            Stream<Object> result = null;
            try {
                result = repo.getRoomsJIDList().stream();
            }
            catch (RepositoryException e) {
                log.log(Level.WARNING, "Failed to retrieve list of room jids from " + repo.toString(), e);
                result = Stream.empty();
            }
            return result;
        }).collect(Collectors.toList());
    }

    public void setAffiliation(RoomWithId room, BareJID jid, Affiliation affiliation) throws RepositoryException {
        this.getRepository(room.getRoomJID().getDomain()).setAffiliation(room, jid, affiliation);
    }

    public void setSubject(RoomWithId room, String subject, String creatorNickname, Date changeDate) throws RepositoryException {
        this.getRepository(room.getRoomJID().getDomain()).setSubject(room, subject, creatorNickname, changeDate);
    }

    @Override
    public void updateRoomConfig(RoomConfig roomConfig) throws RepositoryException {
        this.getRepository(roomConfig.getRoomJID().getDomain()).updateRoomConfig(roomConfig);
    }

    public Class<?> getDefaultBeanClass() {
        return MucDAOProviderConfigBean.class;
    }

    public void setDataSource(DataSource dataSource) {
    }

    protected IMucDAO getRepository(String domain) {
        int idx;
        if (this.mapComponentToBareDomain && (idx = domain.indexOf(".")) > 0) {
            domain = domain.substring(idx + 1);
        }
        return (IMucDAO)super.getRepository(domain);
    }

    protected Class<? extends IMucDAO> findClassForDataSource(DataSource dataSource) throws DBInitException {
        return DataSourceHelper.getDefaultClass(IMucDAO.class, (String)dataSource.getResourceUri());
    }

    public static class MucDAOProviderConfigBean
    extends MDRepositoryBean.MDRepositoryConfigBean<IMucDAO> {
    }
}

