/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.repository;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.db.DataRepository;
import tigase.db.Repository;
import tigase.db.util.RepositoryVersionAware;
import tigase.kernel.beans.Inject;
import tigase.muc.Affiliation;
import tigase.muc.MUCConfig;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.RoomWithId;
import tigase.muc.repository.AbstractMucDAO;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xmpp.jid.BareJID;

@Repository.Meta(supportedUris={"jdbc:.*"}, isDefault=true)
@Repository.SchemaId(id="muc", name="Tigase MUC Component")
public class JDBCMucDAO
extends AbstractMucDAO<DataRepository, Long>
implements RepositoryVersionAware {
    private static final Logger log = Logger.getLogger(JDBCMucDAO.class.getName());
    private static final String CREATE_ROOM_QUERY = "{ call Tig_MUC_CreateRoom(?,?,?,?,?) }";
    private static final String DESTROY_ROOM_QUERY = "{ call Tig_MUC_DestroyRoom(?) }";
    private static final String GET_ROOM_AFFILIATIONS_QUERY = "{ call Tig_MUC_GetRoomAffiliations(?) }";
    private static final String GET_ROOM_QUERY = "{ call Tig_MUC_GetRoom(?) }";
    private static final String GET_ROOMS_JIDS_QUERY = "{ call Tig_MUC_GetRoomsJids() }";
    private static final String SET_ROOM_AFFILIATION_QUERY = "{ call Tig_MUC_SetRoomAffiliation(?,?,?) }";
    private static final String SET_ROOM_SUBJECT_QUERY = "{ call Tig_MUC_SetRoomSubject(?,?,?,?) }";
    private static final String SET_ROOM_CONFIG_QUERY = "{ call Tig_MUC_SetRoomConfig(?,?,?) }";
    protected DataRepository data_repo;
    @Inject
    private MUCConfig mucConfig;
    @Inject
    private Room.RoomFactory roomFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long createRoom(RoomWithId<Long> room) throws RepositoryException {
        try {
            PreparedStatement stmt;
            String roomName = room.getConfig().getRoomName();
            ResultSet rs = null;
            PreparedStatement preparedStatement = stmt = this.data_repo.getPreparedStatement(room.getRoomJID(), CREATE_ROOM_QUERY);
            synchronized (preparedStatement) {
                try {
                    stmt.setString(1, room.getRoomJID().toString());
                    stmt.setString(2, room.getCreatorJid().toString());
                    this.data_repo.setTimestamp(stmt, 3, new Timestamp(room.getCreationDate().getTime()));
                    stmt.setString(4, roomName != null && !roomName.isEmpty() ? roomName : null);
                    stmt.setString(5, room.getConfig().getAsElement().toString());
                    rs = stmt.executeQuery();
                    if (rs.next()) {
                        room.setId(rs.getLong(1));
                    }
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
                this.data_repo.release(null, rs);
            }
        }
        catch (SQLException ex) {
            throw new RepositoryException("Error while saving room " + room.getRoomJID() + " to database", (Throwable)ex);
        }
        if (room.getId() == null) {
            throw new RepositoryException("Failed to save room " + room.getRoomJID() + " to database, did not get room id");
        }
        for (BareJID affJid : room.getAffiliations()) {
            Affiliation a = room.getAffiliation(affJid);
            this.setAffiliation(room, affJid, a);
        }
        return room.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyRoom(BareJID roomJID) throws RepositoryException {
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.data_repo.getPreparedStatement(roomJID, DESTROY_ROOM_QUERY);
            synchronized (preparedStatement) {
                stmt.setString(1, roomJID.toString());
                stmt.execute();
            }
        }
        catch (SQLException ex) {
            throw new RepositoryException("Error while removing room " + roomJID + " from database", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<BareJID, Affiliation> getAffiliations(RoomWithId<Long> room) throws RepositoryException {
        HashMap<BareJID, Affiliation> affiliations = new HashMap<BareJID, Affiliation>();
        try {
            PreparedStatement stmt;
            ResultSet rs = null;
            PreparedStatement preparedStatement = stmt = this.data_repo.getPreparedStatement(room.getRoomJID(), GET_ROOM_AFFILIATIONS_QUERY);
            synchronized (preparedStatement) {
                try {
                    stmt.setLong(1, room.getId());
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        Affiliation affiliation = Affiliation.valueOf(rs.getString(2));
                        affiliations.put(BareJID.bareJIDInstance((String)rs.getString(1)), affiliation);
                    }
                }
                catch (Throwable throwable) {
                    this.data_repo.release(null, rs);
                    throw throwable;
                }
                this.data_repo.release(null, rs);
            }
        }
        catch (SQLException | TigaseStringprepException ex) {
            throw new RepositoryException("Error while reading room " + room.getRoomJID() + " affiliations from database", ex);
        }
        return affiliations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RoomWithId<Long> getRoom(BareJID roomJID) throws RepositoryException {
        try {
            PreparedStatement stmt;
            ResultSet rs = null;
            PreparedStatement preparedStatement = stmt = this.data_repo.getPreparedStatement(roomJID, GET_ROOM_QUERY);
            synchronized (preparedStatement) {
                block7: {
                    RoomWithId<Long> roomWithId;
                    try {
                        stmt.setString(1, roomJID.toString());
                        rs = stmt.executeQuery();
                        if (!rs.next()) break block7;
                        long roomId = rs.getLong(1);
                        Timestamp date = this.data_repo.getTimestamp(rs, 2);
                        BareJID creator = BareJID.bareJIDInstance((String)rs.getString(3));
                        RoomConfig roomConfig = new RoomConfig(roomJID);
                        roomConfig.readFromElement(this.parseConfigElement(rs.getString(4)));
                        RoomWithId<Long> room = this.roomFactory.newInstance(roomId, roomConfig, date, creator);
                        String subject = rs.getString(5);
                        String subjectCreator = rs.getString(6);
                        room.setNewSubject(subject, subjectCreator);
                        Timestamp subjectDate = this.data_repo.getTimestamp(rs, 7);
                        room.setSubjectChangeDate(subjectDate);
                        roomWithId = room;
                    }
                    catch (Throwable throwable) {
                        this.data_repo.release(null, rs);
                        throw throwable;
                    }
                    this.data_repo.release(null, rs);
                    return roomWithId;
                }
                RoomWithId<Long> roomWithId = null;
                this.data_repo.release(null, rs);
                return roomWithId;
            }
        }
        catch (SQLException | TigaseStringprepException ex) {
            throw new RepositoryException("Error while reading room " + roomJID + " from database", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BareJID> getRoomsJIDList() throws RepositoryException {
        ArrayList<BareJID> jids = new ArrayList<BareJID>();
        try {
            PreparedStatement stmt;
            ResultSet rs = null;
            PreparedStatement preparedStatement = stmt = this.data_repo.getPreparedStatement(this.mucConfig.getServiceName(), GET_ROOMS_JIDS_QUERY);
            synchronized (preparedStatement) {
                try {
                    rs = stmt.executeQuery();
                    while (rs.next()) {
                        BareJID jid = BareJID.bareJIDInstance((String)rs.getString(1));
                        jids.add(jid);
                    }
                }
                finally {
                    this.data_repo.release(null, rs);
                }
            }
        }
        catch (SQLException | TigaseStringprepException ex) {
            throw new RepositoryException("Error while reading list of rooms jids from database", ex);
        }
        return jids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAffiliation(RoomWithId<Long> room, BareJID jid, Affiliation affiliation) throws RepositoryException {
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.data_repo.getPreparedStatement(this.mucConfig.getServiceName(), SET_ROOM_AFFILIATION_QUERY);
            synchronized (preparedStatement) {
                stmt.setLong(1, room.getId());
                stmt.setString(2, jid.toString());
                stmt.setString(3, affiliation.name());
                stmt.execute();
            }
        }
        catch (SQLException ex) {
            throw new RepositoryException("Error while setting affiliation for room " + room.getRoomJID() + " for jid " + jid + " to " + affiliation.name(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSubject(RoomWithId<Long> room, String subject, String creatorNickname, Date changeDate) throws RepositoryException {
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.data_repo.getPreparedStatement(this.mucConfig.getServiceName(), SET_ROOM_SUBJECT_QUERY);
            synchronized (preparedStatement) {
                stmt.setLong(1, room.getId());
                stmt.setString(2, subject);
                stmt.setString(3, creatorNickname);
                this.data_repo.setTimestamp(stmt, 4, new Timestamp(changeDate.getTime()));
                stmt.execute();
            }
        }
        catch (SQLException ex) {
            throw new RepositoryException("Error while setting subject for room " + room.getRoomJID() + " to " + subject + " by " + creatorNickname, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRoomConfig(RoomConfig roomConfig) throws RepositoryException {
        try {
            PreparedStatement stmt;
            String roomName = roomConfig.getRoomName();
            PreparedStatement preparedStatement = stmt = this.data_repo.getPreparedStatement(this.mucConfig.getServiceName(), SET_ROOM_CONFIG_QUERY);
            synchronized (preparedStatement) {
                stmt.setString(1, roomConfig.getRoomJID().toString());
                stmt.setString(2, roomName != null && !roomName.isEmpty() ? roomName : null);
                stmt.setString(3, roomConfig.getAsElement().toString());
                stmt.execute();
            }
        }
        catch (SQLException ex) {
            throw new RepositoryException("Error updating configuration of room " + roomConfig.getRoomJID(), (Throwable)ex);
        }
    }

    public void setDataSource(DataRepository dataSource) {
        try {
            this.initPreparedStatements(dataSource);
        }
        catch (SQLException ex) {
            new RuntimeException("Failed to initialize access to SQL database for PubSubDAOJDBC", ex);
        }
        this.data_repo = dataSource;
    }

    protected void initPreparedStatements(DataRepository repo) throws SQLException {
        repo.initPreparedStatement(CREATE_ROOM_QUERY, CREATE_ROOM_QUERY);
        repo.initPreparedStatement(DESTROY_ROOM_QUERY, DESTROY_ROOM_QUERY);
        repo.initPreparedStatement(GET_ROOM_AFFILIATIONS_QUERY, GET_ROOM_AFFILIATIONS_QUERY);
        repo.initPreparedStatement(GET_ROOM_QUERY, GET_ROOM_QUERY);
        repo.initPreparedStatement(GET_ROOMS_JIDS_QUERY, GET_ROOMS_JIDS_QUERY);
        repo.initPreparedStatement(SET_ROOM_AFFILIATION_QUERY, SET_ROOM_AFFILIATION_QUERY);
        repo.initPreparedStatement(SET_ROOM_SUBJECT_QUERY, SET_ROOM_SUBJECT_QUERY);
        repo.initPreparedStatement(SET_ROOM_CONFIG_QUERY, SET_ROOM_CONFIG_QUERY);
    }
}

