/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.muc.Affiliation;
import tigase.muc.Ghostbuster2;
import tigase.muc.MUCComponent;
import tigase.muc.MUCConfig;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.exceptions.MUCException;
import tigase.muc.history.HistoryProvider;
import tigase.muc.logger.MucLogger;
import tigase.muc.modules.AbstractMucModule;
import tigase.muc.modules.GroupchatMessageModule;
import tigase.muc.modules.PresenceModule;
import tigase.muc.modules.RoomConfigurationModule;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.util.datetime.TimestampHelper;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="presences", parent=MUCComponent.class, active=true)
public class PresenceModuleImpl
extends AbstractMucModule
implements PresenceModule {
    protected static final Logger log = Logger.getLogger(PresenceModule.class.getName());
    private static final Criteria CRIT = ElementCriteria.name((String)"presence");
    private final Set<Criteria> allowedElements = new HashSet<Criteria>();
    @Inject
    private MUCConfig config;
    @Inject
    private Ghostbuster2 ghostbuster;
    @Inject
    private HistoryProvider historyProvider;
    @Inject(nullAllowed=true)
    private MucLogger mucLogger;
    @Inject
    private IMucRepository repository;
    private TimestampHelper dateTimeFormatter = new TimestampHelper();

    public static void addCodes(PresenceModule.PresenceWrapper wrapper, boolean newRoomCreated, String newNickName) {
        if (newRoomCreated) {
            wrapper.addStatusCode(201);
        }
        if (newNickName != null) {
            wrapper.addStatusCode(303);
            for (Element item : wrapper.items) {
                item.setAttribute("nick", newNickName);
            }
        }
    }

    public static Role getDefaultRole(RoomConfig config, Affiliation affiliation) {
        Role newRole;
        if (config.isRoomModerated() && affiliation == Affiliation.none) {
            newRole = Role.visitor;
        } else {
            switch (affiliation) {
                case admin: {
                    newRole = Role.moderator;
                    break;
                }
                case member: {
                    newRole = Role.participant;
                    break;
                }
                case none: {
                    newRole = Role.participant;
                    break;
                }
                case outcast: {
                    newRole = Role.none;
                    break;
                }
                case owner: {
                    newRole = Role.moderator;
                    break;
                }
                default: {
                    newRole = Role.none;
                }
            }
        }
        return newRole;
    }

    private Integer toInteger(String v, Integer defaultValue) throws NumberFormatException {
        if (v == null) {
            return defaultValue;
        }
        return Integer.parseInt(v);
    }

    private Integer attrToInteger(Element elem, String attr, Integer defaultValue) throws MUCException {
        try {
            return this.toInteger(elem.getAttributeStaticStr(attr), defaultValue);
        }
        catch (NumberFormatException ex) {
            throw new MUCException(Authorization.BAD_REQUEST, "Invalid value for attribute " + attr);
        }
    }

    public PresenceModuleImpl() {
        this.allowedElements.add((Criteria)ElementCriteria.name((String)"show"));
        this.allowedElements.add((Criteria)ElementCriteria.name((String)"status"));
        this.allowedElements.add((Criteria)ElementCriteria.name((String)"priority"));
        this.allowedElements.add((Criteria)ElementCriteria.xmlns((String)"http://jabber.org/protocol/caps"));
    }

    private void addJoinToHistory(Room room, Date date, JID senderJID, String nickName) {
        if (this.historyProvider != null) {
            this.historyProvider.addJoinEvent(room, date, senderJID, nickName);
        }
        if (this.mucLogger != null && room.getConfig().isLoggingEnabled()) {
            this.mucLogger.addJoinEvent(room, date, senderJID, nickName);
        }
    }

    private void addLeaveToHistory(Room room, Date date, JID senderJID, String nickName) {
        if (this.historyProvider != null) {
            this.historyProvider.addLeaveEvent(room, date, senderJID, nickName);
        }
        if (this.mucLogger != null && room.getConfig().isLoggingEnabled()) {
            this.mucLogger.addLeaveEvent(room, date, senderJID, nickName);
        }
    }

    protected Element clonePresence(Element element) {
        Element toRemove;
        List cc;
        Element presence = new Element(element);
        if (this.config.isPresenceFilterEnabled() && (cc = element.getChildren()) != null) {
            ArrayList<Element> children = new ArrayList<Element>();
            block0: for (Element c : cc) {
                for (Criteria crit : this.allowedElements) {
                    if (!crit.match(c)) continue;
                    children.add(c);
                    continue block0;
                }
            }
            presence.setChildren(children);
        }
        if ((toRemove = presence.getChild("x", "http://jabber.org/protocol/muc")) != null) {
            presence.removeChild(toRemove);
        }
        return presence;
    }

    @Override
    public void doQuit(Room room, JID senderJID) throws TigaseStringprepException {
        String leavingNickname = room.getOccupantsNickname(senderJID);
        if (leavingNickname == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("JID " + senderJID + " has no name. It is not occupant of room " + room.getRoomJID());
            }
            return;
        }
        Affiliation leavingAffiliation = room.getAffiliation(leavingNickname);
        Role leavingRole = room.getRole(leavingNickname);
        Element presenceElement = new Element("presence");
        if (log.isLoggable(Level.FINER)) {
            log.finer("Occupant " + senderJID + " known as " + leavingNickname + " is leaving room " + room.getRoomJID());
        }
        presenceElement.setAttribute("type", "unavailable");
        ArrayList<JID> occupantJIDs = new ArrayList<JID>(room.getOccupantsJidsByNickname(leavingNickname));
        boolean nicknameGone = room.removeOccupant(senderJID);
        this.ghostbuster.remove(senderJID, room);
        room.updatePresenceByJid(senderJID, leavingNickname, null);
        if (this.config.isMultiItemMode()) {
            PresenceModule.PresenceWrapper selfPresence = PresenceModule.PresenceWrapper.preparePresenceW(room, senderJID, presenceElement, senderJID.getBareJID(), occupantJIDs, leavingNickname, leavingAffiliation, Role.none);
            this.write(selfPresence.packet);
        } else {
            ArrayList<JID> z = new ArrayList<JID>(1);
            z.add(senderJID);
            PresenceModule.PresenceWrapper presenceWrapper = PresenceModule.PresenceWrapper.preparePresenceW(room, senderJID, presenceElement, senderJID.getBareJID(), z, leavingNickname, leavingAffiliation, Role.none);
            this.write(presenceWrapper.packet);
        }
        if (nicknameGone) {
            for (String string : room.getOccupantsNicknames()) {
                for (JID occupantJid : room.getOccupantsJidsByNickname(string)) {
                    presenceElement = new Element("presence");
                    presenceElement.setAttribute("type", "unavailable");
                    PresenceModule.PresenceWrapper presence = PresenceModule.PresenceWrapper.preparePresenceW(room, occupantJid, presenceElement, senderJID.getBareJID(), occupantJIDs, leavingNickname, leavingAffiliation, Role.none);
                    this.write(presence.packet);
                }
            }
            if (room.getConfig().isLoggingEnabled()) {
                this.addLeaveToHistory(room, new Date(), senderJID, leavingNickname);
            }
        } else {
            occupantJIDs = new ArrayList<JID>(room.getOccupantsJidsByNickname(leavingNickname));
            Element pe = room.getLastPresenceCopy(senderJID.getBareJID(), leavingNickname);
            if (pe == null) {
                pe = new Element("presence", new String[]{"type"}, new String[]{"unavailable"});
            }
            for (String occupantNickname : room.getOccupantsNicknames()) {
                for (JID occupantJid : room.getOccupantsJidsByNickname(occupantNickname)) {
                    if (this.config.isMultiItemMode()) {
                        PresenceModule.PresenceWrapper presence = PresenceModule.PresenceWrapper.preparePresenceW(room, occupantJid, pe.clone(), senderJID.getBareJID(), occupantJIDs, leavingNickname, leavingAffiliation, Role.none);
                        this.write(presence.packet);
                        continue;
                    }
                    for (JID jid : occupantJIDs) {
                        ArrayList<JID> z = new ArrayList<JID>(1);
                        z.add(jid);
                        PresenceModule.PresenceWrapper presence = PresenceModule.PresenceWrapper.preparePresenceW(room, occupantJid, pe.clone(), senderJID.getBareJID(), z, leavingNickname, leavingAffiliation, Role.none);
                        this.write(presence.packet);
                    }
                }
            }
        }
        Element event = new Element("RoomLeave", new String[]{"xmlns"}, new String[]{"tigase:events:muc"});
        event.addChild((XMLNodeIfc)new Element("room", room.getRoomJID().toString()));
        event.addChild((XMLNodeIfc)new Element("nickname", leavingNickname));
        event.addChild((XMLNodeIfc)new Element("jid", senderJID.toString()));
        this.fireEvent(event);
        if (room.getOccupantsCount() == 0) {
            if (!room.getConfig().isPersistentRoom()) {
                if (this.historyProvider != null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Removing history of room " + room.getRoomJID());
                    }
                    this.historyProvider.removeHistory(room);
                } else if (log.isLoggable(Level.FINE)) {
                    log.fine("Cannot remove history of room " + room.getRoomJID() + " because history provider is not available.");
                }
            } else if (log.isLoggable(Level.FINE)) {
                log.fine("Room persistent. History will not be removed.");
            }
            this.repository.leaveRoom(room);
            Element element = new Element("EmptyRoom", new String[]{"xmlns"}, new String[]{"tigase:events:muc"});
            element.addChild((XMLNodeIfc)new Element("room", room.getRoomJID().toString()));
            this.fireEvent(element);
        }
    }

    public String[] getFeatures() {
        return null;
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    protected PresenceModule.PresenceWrapper preparePresence(JID destinationJID, Element presence, Room room, JID occupantJID, boolean newRoomCreated, String newNickName) throws TigaseStringprepException {
        PresenceModule.PresenceWrapper wrapper = PresenceModule.PresenceWrapper.preparePresenceW(room, destinationJID, presence, occupantJID);
        PresenceModuleImpl.addCodes(wrapper, newRoomCreated, newNickName);
        return wrapper;
    }

    public void process(Packet element) throws MUCException, TigaseStringprepException {
        JID senderJID = JID.jidInstance((String)element.getAttributeStaticStr("from"));
        BareJID roomJID = BareJID.bareJIDInstance((String)element.getAttributeStaticStr("to"));
        String nickName = PresenceModuleImpl.getNicknameFromJid(JID.jidInstance((String)element.getAttributeStaticStr("to")));
        String presenceType = element.getAttributeStaticStr("type");
        if (presenceType != null && "error".equals(presenceType)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Ignoring presence with type='" + presenceType + "' from " + senderJID);
            }
            return;
        }
        if (nickName == null) {
            throw new MUCException(Authorization.JID_MALFORMED);
        }
        try {
            boolean probablyReEnter;
            String knownNickname;
            boolean roomCreated;
            Room room = this.repository.getRoom(roomJID);
            if (presenceType != null && "unavailable".equals(presenceType)) {
                this.processExit(room, element.getElement(), senderJID);
                return;
            }
            if (room == null) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Creating new room '" + roomJID + "' by user " + nickName + "' <" + senderJID.toString() + ">");
                }
                room = this.repository.createNewRoom(roomJID, senderJID);
                room.addAffiliationByJid(senderJID.getBareJID(), Affiliation.owner);
                room.setRoomLocked(this.config.isNewRoomLocked());
                roomCreated = true;
                knownNickname = null;
                room.getConfig().notifyConfigUpdate(true);
                room.setNewSubject(null, nickName);
            } else {
                roomCreated = false;
                knownNickname = room.getOccupantsNickname(senderJID);
            }
            boolean bl = probablyReEnter = element.getElement().getChild("x", "http://jabber.org/protocol/muc") != null;
            if (knownNickname != null && !knownNickname.equals(nickName)) {
                this.processChangeNickname(room, element.getElement(), senderJID, knownNickname, nickName);
            } else if (probablyReEnter || knownNickname == null) {
                this.processEntering(room, roomCreated, element.getElement(), senderJID, nickName);
            } else if (knownNickname.equals(nickName)) {
                this.processChangeAvailabilityStatus(room, element.getElement(), senderJID, knownNickname);
            }
        }
        catch (MUCException e) {
            throw e;
        }
        catch (TigaseStringprepException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    protected void processChangeAvailabilityStatus(Room room, Element presenceElement, JID senderJID, String nickname) throws TigaseStringprepException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing stanza " + presenceElement.toString());
        }
        if (!room.getConfig().isPresenceFilterEnabled() || room.getConfig().isPresenceFilterEnabled() && !room.getConfig().getPresenceFilteredAffiliations().isEmpty() && room.getConfig().getPresenceFilteredAffiliations().contains((Object)room.getAffiliation(senderJID.getBareJID()))) {
            room.updatePresenceByJid(null, nickname, this.clonePresence(presenceElement));
        }
        Element pe = room.getLastPresenceCopyByJid(senderJID.getBareJID());
        this.sendPresenceToAllOccupants(pe, room, senderJID, false, null);
    }

    protected void processChangeNickname(Room room, Element element, JID senderJID, String senderNickname, String newNickName) throws TigaseStringprepException, MUCException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing stanza " + element.toString());
        }
        throw new MUCException(Authorization.FEATURE_NOT_IMPLEMENTED, "Changing nickname is not supported yet.");
    }

    protected void processEntering(Room room, boolean roomCreated, Element element, JID senderJID, String nickname) throws MUCException, TigaseStringprepException {
        Element hist;
        Element password;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing stanza " + element.toString());
        }
        Affiliation affiliation = room.getAffiliation(senderJID.getBareJID());
        Element xElement = element.getChild("x", "http://jabber.org/protocol/muc");
        Element element2 = password = xElement == null ? null : xElement.getChild("password");
        if (room.getConfig().isPasswordProtectedRoom()) {
            String psw = password == null ? null : password.getCData();
            String roomPassword = room.getConfig().getPassword();
            if (psw == null || !psw.equals(roomPassword)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Password '" + psw + "' is not match to room password '" + roomPassword + "' ");
                }
                throw new MUCException(Authorization.NOT_AUTHORIZED);
            }
        }
        if (room.isRoomLocked() && affiliation != Affiliation.owner) {
            throw new MUCException(Authorization.ITEM_NOT_FOUND, null, "Room exists but is locked");
        }
        if (!affiliation.isEnterOpenRoom()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("User " + nickname + "' <" + senderJID.toString() + "> is on rooms '" + room.getRoomJID() + "' blacklist");
            }
            throw new MUCException(Authorization.FORBIDDEN);
        }
        if (room.getConfig().isRoomMembersOnly() && !affiliation.isEnterMembersOnlyRoom()) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("User " + nickname + "' <" + senderJID.toString() + "> is NOT on rooms '" + room.getRoomJID() + "' member list.");
            }
            throw new MUCException(Authorization.REGISTRATION_REQUIRED);
        }
        BareJID currentOccupantJid = room.getOccupantsJidByNickname(nickname);
        if (!(currentOccupantJid == null || this.config.isMultiItemMode() && currentOccupantJid.equals((Object)senderJID.getBareJID()))) {
            throw new MUCException(Authorization.CONFLICT);
        }
        Integer roomMaxUsers = room.getConfig().getMaxUsers();
        if (roomMaxUsers != null && currentOccupantJid == null && room.getOccupantsCount() >= roomMaxUsers) {
            log.finest("User " + nickname + "' <" + senderJID.toString() + "> cannot join to room '" + room.getRoomJID() + "' because maximum number of occupants is reached.");
            throw new MUCException(Authorization.SERVICE_UNAVAILABLE, "Reached maximum number of occupants.");
        }
        Integer roomMaxResources = room.getConfig().getMaxUserResources();
        if (roomMaxResources != null && roomMaxResources >= room.getOccupantsJidsByNickname(nickname).size()) {
            log.finest("User " + nickname + "' <" + senderJID.toString() + "> cannot join to room '" + room.getRoomJID() + "' because maximum number of the same occupant resources is reached.");
            throw new MUCException(Authorization.SERVICE_UNAVAILABLE, "Reached maximum number of occupant resources");
        }
        Integer maxchars = null;
        Integer maxstanzas = null;
        Integer seconds = null;
        Date since = null;
        Element element3 = hist = xElement == null ? null : xElement.getChild("history");
        if (hist != null) {
            maxchars = this.attrToInteger(hist, "maxchars", null);
            maxstanzas = this.attrToInteger(hist, "maxstanzas", null);
            seconds = this.attrToInteger(hist, "seconds", null);
            try {
                since = this.dateTimeFormatter.parseTimestamp(hist.getAttributeStaticStr("since"));
            }
            catch (ParseException ex) {
                throw new MUCException(Authorization.BAD_REQUEST, "Invalid value for attribute since");
            }
        }
        this.sendPresencesToNewOccupant(room, senderJID);
        Role newRole = PresenceModuleImpl.getDefaultRole(room.getConfig(), affiliation);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Occupant '" + nickname + "' <" + senderJID.toString() + "> is entering room " + room.getRoomJID() + " as role=" + newRole.name() + ", affiliation=" + affiliation.name());
        }
        Element pe = this.clonePresence(element);
        room.addOccupantByJid(senderJID, nickname, newRole, pe);
        this.ghostbuster.add(senderJID, room);
        this.sendPresenceToAllOccupants(room, senderJID, roomCreated, null);
        Element event = new Element("RoomJoin", new String[]{"xmlns"}, new String[]{"tigase:events:muc"});
        event.addChild((XMLNodeIfc)new Element("room", room.getRoomJID().toString()));
        event.addChild((XMLNodeIfc)new Element("nickname", nickname));
        event.addChild((XMLNodeIfc)new Element("jid", senderJID.toString()));
        this.fireEvent(event);
        this.sendHistoryToUser(room, senderJID, maxchars, maxstanzas, seconds, since);
        if (room.getSubjectChangerNick() != null && room.getSubjectChangeDate() != null) {
            Element message = new Element("message", new String[]{"type", "from", "to", "id"}, new String[]{"groupchat", room.getRoomJID() + "/" + room.getSubjectChangerNick(), senderJID.toString(), GroupchatMessageModule.generateSubjectId(room.getSubjectChangeDate(), room.getSubject())});
            message.addChild((XMLNodeIfc)new Element("subject", room.getSubject()));
            String stamp = this.dateTimeFormatter.formatWithMs(room.getSubjectChangeDate());
            Element delay = new Element("delay", new String[]{"xmlns", "stamp"}, new String[]{"urn:xmpp:delay", stamp});
            delay.setAttribute("jid", room.getRoomJID() + "/" + room.getSubjectChangerNick());
            message.addChild((XMLNodeIfc)delay);
            if (this.config.useLegacyDelayedDelivery()) {
                Element x = new Element("x", new String[]{"xmlns", "stamp"}, new String[]{"jabber:x:delay", this.dateTimeFormatter.formatInLegacyDelayedDelivery(room.getSubjectChangeDate())});
                message.addChild((XMLNodeIfc)x);
            }
            Packet p = Packet.packetInstance((Element)message);
            p.setXMLNS("jabber:client");
            this.write(p);
        }
        if (room.isRoomLocked() && this.config.isWelcomeMessagesEnabled() && room.getConfig().isWelcomeMessageEnabled()) {
            this.sendMucMessage(room, room.getOccupantsNickname(senderJID), "Room is locked. Please configure.");
        }
        if (roomCreated) {
            this.fireEvent(RoomConfigurationModule.createRoomCreatedEvent(room));
            if (this.config.isWelcomeMessagesEnabled() && room.getConfig().isWelcomeMessageEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Welcome! You created new Multi User Chat Room.");
                if (room.isRoomLocked()) {
                    sb.append(" Room is locked now. Configure it please!");
                } else if (this.config.isNewRoomLocked()) {
                    sb.append(" Room is unlocked and ready for occupants!");
                }
                this.sendMucMessage(room, room.getOccupantsNickname(senderJID), sb.toString());
            }
        }
        if (room.getConfig().isLoggingEnabled()) {
            this.addJoinToHistory(room, new Date(), senderJID, nickname);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest(room.getDebugInfoOccupants());
        }
    }

    protected void processExit(Room room, Element presenceElement, JID senderJID) throws MUCException, TigaseStringprepException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing stanza " + presenceElement.toString());
        }
        if (room == null) {
            throw new MUCException(Authorization.ITEM_NOT_FOUND, "Unknown room");
        }
        String leavingNickname = room.getOccupantsNickname(senderJID);
        if (leavingNickname == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("JID " + senderJID + " has no name. It is not occupant of room " + room.getRoomJID());
            }
            return;
        }
        this.doQuit(room, senderJID);
    }

    private void sendHistoryToUser(Room room, JID senderJID, Integer maxchars, Integer maxstanzas, Integer seconds, Date since) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Sending history to user using: " + this.historyProvider + " history provider");
        }
        if (this.historyProvider != null) {
            this.historyProvider.getHistoryMessages(room, senderJID, maxchars, maxstanzas, seconds, since, this.writer);
        }
    }

    protected void sendPresenceToAllOccupants(Element $presence, Room room, JID senderJID, boolean newRoomCreated, String newNickName) throws TigaseStringprepException {
        String occupantNickname = room.getOccupantsNickname(senderJID);
        BareJID occupantJID = room.getOccupantsJidByNickname(occupantNickname);
        Affiliation occupantAffiliation = room.getAffiliation(occupantJID);
        Role occupantRole = room.getRole(occupantNickname);
        Collection<String> occupantsNicknames = room.getConfig().isPresenceFilterEnabled() ? (room.getConfig().getPresenceFilteredAffiliations().contains((Object)occupantAffiliation) ? room.getPresenceFiltered().getOccupantsPresenceFilteredNicknames() : Arrays.asList(occupantNickname)) : room.getOccupantsNicknames();
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Sending presence to all occupants, filtering enabled: " + room.getConfig().isPresenceFilterEnabled() + ", occupantsNicknames: " + Arrays.asList(occupantsNicknames));
        }
        for (String destinationNickname : occupantsNicknames) {
            for (JID destinationJID : room.getOccupantsJidsByNickname(destinationNickname)) {
                if (this.config.isMultiItemMode()) {
                    PresenceModule.PresenceWrapper presence = this.preparePresence(destinationJID, $presence.clone(), room, senderJID, newRoomCreated, newNickName);
                    this.write(presence.packet);
                    continue;
                }
                for (JID jid : room.getOccupantsJidsByNickname(occupantNickname)) {
                    ArrayList<JID> z = new ArrayList<JID>(1);
                    z.add(jid);
                    PresenceModule.PresenceWrapper l = PresenceModule.PresenceWrapper.preparePresenceW(room, destinationJID, $presence.clone(), occupantJID, z, occupantNickname, occupantAffiliation, occupantRole);
                    PresenceModuleImpl.addCodes(l, newRoomCreated, newNickName);
                    this.write(l.packet);
                }
            }
        }
    }

    protected void sendPresenceToAllOccupants(Room room, JID senderJID, boolean newRoomCreated, String newNickName) throws TigaseStringprepException {
        Element presence;
        if (newNickName != null) {
            presence = new Element("presence");
            presence.setAttribute("type", "unavailable");
        } else if (room.getOccupantsNickname(senderJID) == null) {
            presence = new Element("presence");
            presence.setAttribute("type", "unavailable");
        } else {
            presence = room.getLastPresenceCopyByJid(senderJID.getBareJID());
        }
        if (presence != null) {
            this.sendPresenceToAllOccupants(presence, room, senderJID, newRoomCreated, newNickName);
        }
    }

    @Override
    public void sendPresencesToNewOccupant(Room room, JID senderJID) throws TigaseStringprepException {
        BareJID currentOccupantJid = senderJID.getBareJID();
        Affiliation senderAffiliation = room.getAffiliation(currentOccupantJid);
        if (room.getConfig().isPresenceFilterEnabled() && !room.getConfig().getPresenceFilteredAffiliations().contains((Object)senderAffiliation)) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Filtering enabled: " + room.getConfig().isPresenceFilterEnabled() + "; new occupant doesn't have propper affiliation -  skip sending occupants list");
            }
            return;
        }
        for (String occupantNickname : room.getOccupantsNicknames()) {
            BareJID occupantJid = room.getOccupantsJidByNickname(occupantNickname);
            if (occupantJid == null || currentOccupantJid != null && currentOccupantJid.equals((Object)occupantJid)) continue;
            Affiliation affiliation = room.getAffiliation(occupantJid);
            if (room.getConfig().isPresenceFilterEnabled() && !room.getConfig().getPresenceFilteredAffiliations().contains((Object)affiliation)) {
                if (!log.isLoggable(Level.FINEST)) continue;
                log.log(Level.FINEST, "Filtering enabled: " + room.getConfig().isPresenceFilterEnabled() + "; target occupant doesn't have propper affiliation -  don't include him in the list");
                continue;
            }
            Element op = room.getLastPresenceCopyByJid(occupantJid);
            if (op == null) continue;
            Collection<JID> occupantJIDs = room.getOccupantsJidsByNickname(occupantNickname);
            BareJID occupantBareJID = room.getOccupantsJidByNickname(occupantNickname);
            Affiliation occupantAffiliation = room.getAffiliation(occupantBareJID);
            Role occupantRole = room.getRole(occupantNickname);
            if (this.config.isMultiItemMode()) {
                PresenceModule.PresenceWrapper l = PresenceModule.PresenceWrapper.preparePresenceW(room, senderJID, op.clone(), occupantBareJID, occupantJIDs, occupantNickname, occupantAffiliation, occupantRole);
                this.write(l.packet);
                continue;
            }
            for (JID jid : occupantJIDs) {
                ArrayList<JID> z = new ArrayList<JID>(1);
                z.add(jid);
                PresenceModule.PresenceWrapper l = PresenceModule.PresenceWrapper.preparePresenceW(room, senderJID, op.clone(), occupantBareJID, z, occupantNickname, occupantAffiliation, occupantRole);
                this.write(l.packet);
            }
        }
    }

    public static class DelayDeliveryThread
    extends Thread {
        private final LinkedList<Element[]> items = new LinkedList();
        private final DelDeliverySend sender;

        public DelayDeliveryThread(DelDeliverySend component) {
            this.sender = component;
        }

        public void put(Collection<Element> elements) {
            if (elements != null && elements.size() > 0) {
                this.items.push(elements.toArray(new Element[0]));
            }
        }

        public void put(Element element) {
            this.items.add(new Element[]{element});
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                block4: while (true) {
                    DelayDeliveryThread.sleep(553L);
                    if (this.items.size() <= 0 || (toSend = this.items.poll()) == null) continue;
                    var2_3 = toSend;
                    var3_4 = var2_3.length;
                    var4_5 = 0;
                    while (true) {
                        block6: {
                            if (var4_5 < var3_4) ** break;
                            continue block4;
                            element = var2_3[var4_5];
                            try {
                                p = Packet.packetInstance((Element)element);
                                p.setXMLNS("jabber:client");
                                this.sender.sendDelayedPacket(p);
                            }
                            catch (TigaseStringprepException ex) {
                                if (!PresenceModuleImpl.log.isLoggable(Level.INFO)) break block6;
                                PresenceModuleImpl.log.info("Packet addressing problem, stringprep failed: " + element);
                            }
                        }
                        ++var4_5;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                PresenceModuleImpl.log.log(Level.WARNING, "Error during delayed delivery", e);
                return;
            }
        }

        public static interface DelDeliverySend {
            public void sendDelayedPacket(Packet var1);
        }
    }
}

