/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.muc.Affiliation;
import tigase.muc.MUCComponent;
import tigase.muc.PresenceFiltered;
import tigase.muc.PresenceStore;
import tigase.muc.Role;
import tigase.muc.RoomConfig;
import tigase.muc.RoomWithId;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class Room
implements RoomConfig.RoomConfigListener {
    public static final String FILTERED_OCCUPANTS_COLLECTION = "filtered_occupants_collection";
    protected static final Logger log = Logger.getLogger(Room.class.getName());
    protected final PresenceFiltered presenceFiltered;
    protected final PresenceStore presences = new PresenceStore();
    private final Map<BareJID, Affiliation> affiliations = new ConcurrentHashMap<BareJID, Affiliation>();
    private final RoomConfig config;
    private final Date creationDate;
    private final BareJID creatorJid;
    private final List<RoomListener> listeners = new CopyOnWriteArrayList<RoomListener>();
    private final List<RoomOccupantListener> occupantListeners = new CopyOnWriteArrayList<RoomOccupantListener>();
    private final Map<String, OccupantEntry> occupants = new ConcurrentHashMap<String, OccupantEntry>();
    private final Map<String, Object> roomCustomData = new ConcurrentHashMap<String, Object>();
    private boolean roomLocked;
    private String subject;
    private Date subjectChangeDate;
    private String subjectChangerNick;

    protected Room(RoomConfig rc, Date creationDate, BareJID creatorJid) {
        this.config = rc;
        this.creationDate = creationDate;
        this.creatorJid = creatorJid;
        this.presenceFiltered = new PresenceFiltered(this);
        this.addOccupantListener(this.presenceFiltered);
        this.addListener(this.presenceFiltered);
        rc.addListener(this);
        this.presences.setOrdening(rc.getPresenceDeliveryLogic());
    }

    public void addAffiliationByJid(BareJID jid, Affiliation affiliation) throws RepositoryException {
        if (affiliation == Affiliation.none) {
            this.affiliations.remove(jid);
        } else {
            this.affiliations.put(jid, affiliation);
        }
        this.fireOnSetAffiliation(jid, affiliation);
    }

    public void addListener(RoomListener listener) {
        this.listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOccupantByJid(JID senderJid, String nickName, Role role, Element pe) throws TigaseStringprepException {
        OccupantEntry entry = this.occupants.get(nickName);
        this.presences.update(pe);
        if (entry == null) {
            entry = new OccupantEntry();
            entry.nickname = nickName;
            entry.jid = senderJid.getBareJID();
            this.occupants.put(nickName, entry);
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Room {0}. Created OccupantEntry for {1}, nickname={2}", new Object[]{this.config.getRoomJID(), senderJid, nickName});
            }
        }
        entry.role = role;
        boolean added = false;
        Set set = entry.jids;
        synchronized (set) {
            added = entry.jids.add(senderJid);
        }
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Room {0}. {1} occupant {2} ({3}) to room with role={4}; filtering enabled: {5}", new Object[]{this.config.getRoomJID(), added ? "Added" : "Updated", senderJid, nickName, role, this.config.isPresenceFilterEnabled()});
        }
        if (added && (!this.config.isPresenceFilterEnabled() || this.config.isPresenceFilterEnabled() && !this.config.getPresenceFilteredAffiliations().isEmpty() && this.config.getPresenceFilteredAffiliations().contains((Object)this.getAffiliation(senderJid.getBareJID())))) {
            this.fireOnOccupantAdded(senderJid);
            this.fireOnOccupantChangedPresence(senderJid, nickName, pe, true);
        }
    }

    public void addOccupantListener(RoomOccupantListener listener) {
        this.occupantListeners.add(listener);
    }

    public void changeNickName(JID senderJid, String nickName) {
        OccupantEntry occ = this.getBySenderJid(senderJid);
        String oldNickname = occ.nickname;
        this.occupants.remove(oldNickname);
        occ.nickname = nickName;
        this.occupants.put(nickName, occ);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Room " + this.config.getRoomJID() + ". Occupant " + senderJid + " changed nickname from " + oldNickname + " to " + nickName);
        }
    }

    public void fireOnMessageToOccupants(JID fromJID, Packet msg) {
        for (RoomListener listener : this.listeners) {
            listener.onMessageToOccupants(this, fromJID, msg);
        }
    }

    public Affiliation getAffiliation(BareJID jid) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting affiliations for: " + jid + " from set: " + this.affiliations.toString());
        }
        Affiliation result = null;
        if (jid != null) {
            result = this.affiliations.get(jid);
        }
        return result == null ? Affiliation.none : result;
    }

    public Affiliation getAffiliation(String nickname) {
        OccupantEntry entry = this.occupants.get(nickname);
        return this.getAffiliation(entry == null ? null : entry.jid);
    }

    public Collection<BareJID> getAffiliations() {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Getting affiliations: " + this.affiliations.toString());
        }
        return this.affiliations.keySet();
    }

    public void setAffiliations(Map<BareJID, Affiliation> affiliations) {
        this.affiliations.clear();
        this.affiliations.putAll(affiliations);
    }

    public Collection<JID> getAllOccupantsJID() {
        if (this.config.isPresenceFilterEnabled()) {
            return this.presenceFiltered.getOccupantsPresenceFilteredJIDs();
        }
        return this.presences.getAllKnownJIDs();
    }

    public RoomConfig getConfig() {
        return this.config;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public BareJID getCreatorJid() {
        return this.creatorJid;
    }

    public String getDebugInfoOccupants() {
        StringBuilder sb = new StringBuilder();
        sb.append("Occupants in room " + this.config.getRoomJID() + "[" + this.occupants.entrySet().size() + "]: ");
        for (Map.Entry<String, OccupantEntry> o : this.occupants.entrySet()) {
            sb.append(o.getKey()).append('=').append(o.getValue().toString()).append(" ");
        }
        return sb.toString();
    }

    public Element getLastPresenceCopy(BareJID occupantJid, String nickname) {
        return this.getLastPresenceCopyByJid(occupantJid);
    }

    public Element getLastPresenceCopyByJid(BareJID occupantJid) {
        Element e = this.presences.getBestPresence(occupantJid);
        if (e != null) {
            return e.clone();
        }
        return null;
    }

    public int getOccupantsCount() {
        return this.occupants.size();
    }

    public BareJID getOccupantsJidByNickname(String nickname) {
        OccupantEntry entry = this.occupants.get(nickname);
        if (entry == null) {
            return null;
        }
        return entry.jid;
    }

    public Collection<JID> getOccupantsJidsByNickname(String nickname) {
        OccupantEntry entry = this.occupants.get(nickname);
        if (entry == null) {
            return new ArrayList<JID>();
        }
        return Collections.unmodifiableCollection(new ConcurrentSkipListSet(entry.jids));
    }

    public String getOccupantsNickname(JID jid) {
        OccupantEntry e = this.getBySenderJid(jid);
        if (e == null) {
            return null;
        }
        String nickname = e.nickname;
        return nickname;
    }

    public Collection<String> getOccupantsNicknames() {
        return Collections.unmodifiableCollection(new ConcurrentSkipListSet<String>(this.occupants.keySet()));
    }

    public Collection<String> getOccupantsNicknames(BareJID bareJid) {
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<String, OccupantEntry> e : this.occupants.entrySet()) {
            if (!e.getValue().jid.equals((Object)bareJid)) continue;
            result.add(e.getKey());
        }
        return Collections.unmodifiableCollection(new ConcurrentSkipListSet(result));
    }

    public PresenceFiltered getPresenceFiltered() {
        return this.presenceFiltered;
    }

    public Role getRole(String nickname) {
        if (nickname == null) {
            return Role.none;
        }
        OccupantEntry entry = this.occupants.get(nickname);
        if (entry == null) {
            return Role.none;
        }
        return entry.role == null ? Role.none : entry.role;
    }

    public Object getRoomCustomData(String key) {
        return this.roomCustomData.get(key);
    }

    public BareJID getRoomJID() {
        return this.config.getRoomJID();
    }

    public String getSubject() {
        return this.subject;
    }

    public Date getSubjectChangeDate() {
        return this.subjectChangeDate;
    }

    public void setSubjectChangeDate(Date subjectChangeDate) {
        this.subjectChangeDate = subjectChangeDate;
    }

    public String getSubjectChangerNick() {
        return this.subjectChangerNick;
    }

    public boolean isOccupantInRoom(JID jid) {
        return this.getBySenderJid(jid) != null;
    }

    public boolean isRoomLocked() {
        return this.roomLocked;
    }

    public void setRoomLocked(boolean roomLocked) {
        this.roomLocked = roomLocked;
    }

    @Override
    public void onConfigChanged(RoomConfig roomConfig, Set<String> modifiedVars) {
        this.presences.setOrdening(roomConfig.getPresenceDeliveryLogic());
    }

    @Override
    public void onInitialRoomConfig(RoomConfig roomConfig) {
    }

    public void removeListener(RoomListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeOccupant(JID jid) {
        OccupantEntry e = this.getBySenderJid(jid);
        if (e != null) {
            try {
                Set set = e.jids;
                synchronized (set) {
                    block11: {
                        e.jids.remove(jid);
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("Room " + this.config.getRoomJID() + ". Removed JID " + jid + " of occupant");
                        }
                        if (!e.jids.isEmpty()) break block11;
                        this.occupants.remove(e.nickname);
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("Room " + this.config.getRoomJID() + ". Removed occupant " + jid);
                        }
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            finally {
                this.fireOnOccupantRemoved(jid);
            }
        }
        return false;
    }

    public void removeOccupant(String occupantNick) {
        OccupantEntry e = this.occupants.remove(occupantNick);
        if (e != null) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Room " + this.config.getRoomJID() + ". Removed occupant " + occupantNick);
            }
            for (JID jid : e.jids) {
                this.fireOnOccupantRemoved(jid);
            }
        }
    }

    public void setNewAffiliation(BareJID user, Affiliation affiliation) {
        this.affiliations.put(user, affiliation);
    }

    public void setNewRole(String nickname, Role newRole) {
        OccupantEntry entry = this.occupants.get(nickname);
        if (entry != null) {
            entry.role = newRole;
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Room " + this.config.getRoomJID() + ". Changed role of occupant " + nickname + " to " + (Object)((Object)newRole));
            }
        }
    }

    public void setNewSubject(String msg, String senderNickname) throws RepositoryException {
        this.subjectChangerNick = senderNickname;
        this.subject = msg;
        this.subjectChangeDate = new Date();
        this.fireOnSetSubject(senderNickname, msg, this.subjectChangeDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoomCustomData(String key, Object data) {
        Map<String, Object> map = this.roomCustomData;
        synchronized (map) {
            this.roomCustomData.put(key, data);
        }
    }

    public void updatePresenceByJid(JID jid, String nickname, Element cp) throws TigaseStringprepException {
        if (cp == null) {
            this.presences.remove(jid);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Room " + this.config.getRoomJID() + ". Removed presence from " + jid + " (" + nickname + ")");
            }
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Room " + this.config.getRoomJID() + ". Updated presence from " + jid + " (" + nickname + ")");
            }
            this.presences.update(cp);
        }
        this.fireOnOccupantChangedPresence(jid, nickname, cp, false);
    }

    private void fireOnOccupantAdded(JID occupantJid) {
        for (RoomOccupantListener listener : this.occupantListeners) {
            listener.onOccupantAdded(this, occupantJid);
        }
    }

    private void fireOnOccupantChangedPresence(JID occupantJid, String nickname, Element cp, boolean newOccupant) {
        for (RoomOccupantListener listener : this.occupantListeners) {
            listener.onOccupantChangedPresence(this, occupantJid, nickname, cp, newOccupant);
        }
    }

    private void fireOnOccupantRemoved(JID occupantJid) {
        for (RoomOccupantListener listener : this.occupantListeners) {
            listener.onOccupantRemoved(this, occupantJid);
        }
    }

    private void fireOnSetAffiliation(BareJID jid, Affiliation affiliation) {
        for (RoomListener listener : this.listeners) {
            listener.onSetAffiliation(this, jid, affiliation);
        }
    }

    private void fireOnSetSubject(String nick, String subject, Date changeDate) {
        for (RoomListener listener : this.listeners) {
            listener.onChangeSubject(this, nick, subject, changeDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OccupantEntry getBySenderJid(JID sender) {
        for (Map.Entry<String, OccupantEntry> e : this.occupants.entrySet()) {
            Set set = e.getValue().jids;
            synchronized (set) {
                if (e.getValue().jids.contains(sender)) {
                    return e.getValue();
                }
            }
        }
        return null;
    }

    @Bean(name="roomFactory", parent=MUCComponent.class, active=true, exportable=true)
    public static class RoomFactoryImpl
    implements RoomFactory {
        @Override
        public <T> RoomWithId<T> newInstance(T id, RoomConfig rc, Date creationDate, BareJID creatorJid) {
            return new RoomWithId<T>(id, rc, creationDate, creatorJid);
        }
    }

    private static class OccupantEntry {
        private final Set<JID> jids = new HashSet<JID>();
        public BareJID jid;
        private String nickname;
        private Role role = Role.none;

        private OccupantEntry() {
        }

        public String toString() {
            return "[" + this.nickname + "; " + (Object)((Object)this.role) + "; " + this.jid + "; " + this.jids.toString() + "]";
        }
    }

    public static interface RoomOccupantListener {
        public void onOccupantAdded(Room var1, JID var2);

        public void onOccupantChangedPresence(Room var1, JID var2, String var3, Element var4, boolean var5);

        public void onOccupantRemoved(Room var1, JID var2);
    }

    public static interface RoomListener {
        public void onChangeSubject(Room var1, String var2, String var3, Date var4);

        public void onMessageToOccupants(Room var1, JID var2, Packet var3);

        public void onSetAffiliation(Room var1, BareJID var2, Affiliation var3);
    }

    public static interface RoomFactory {
        public <T> RoomWithId<T> newInstance(T var1, RoomConfig var2, Date var3, BareJID var4);
    }
}

