/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.form.Field;
import tigase.form.Form;
import tigase.muc.Affiliation;
import tigase.muc.MUCConfig;
import tigase.muc.PresenceStore;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;

public class RoomConfig {
    public static final String MUC_ROOMCONFIG_ANONYMITY_KEY = "muc#roomconfig_anonymity";
    public static final String MUC_ROOMCONFIG_CHANGESUBJECT_KEY = "muc#roomconfig_changesubject";
    public static final String MUC_ROOMCONFIG_ENABLELOGGING_KEY = "muc#roomconfig_enablelogging";
    public static final String MUC_ROOMCONFIG_MAXHISTORY_KEY = "muc#maxhistoryfetch";
    public static final String MUC_ROOMCONFIG_MAXUSERS_KEY = "muc#roomconfig_maxusers";
    public static final String MUC_ROOMCONFIG_MAX_USER_RESOURCES_KEY = "muc#roomconfig_maxresources";
    public static final String MUC_ROOMCONFIG_MEMBERSONLY_KEY = "muc#roomconfig_membersonly";
    public static final String MUC_ROOMCONFIG_ALLOWINVITES_KEY = "muc#roomconfig_allowinvites";
    public static final String MUC_ROOMCONFIG_MODERATEDROOM_KEY = "muc#roomconfig_moderatedroom";
    public static final String MUC_ROOMCONFIG_PASSWORDPROTECTEDROOM_KEY = "muc#roomconfig_passwordprotectedroom";
    public static final String MUC_ROOMCONFIG_PERSISTENTROOM_KEY = "muc#roomconfig_persistentroom";
    public static final String MUC_ROOMCONFIG_PUBLICROOM_KEY = "muc#roomconfig_publicroom";
    public static final String MUC_ROOMCONFIG_ROOMDESC_KEY = "muc#roomconfig_roomdesc";
    public static final String MUC_ROOMCONFIG_ROOMNAME_KEY = "muc#roomconfig_roomname";
    public static final String MUC_ROOMCONFIG_ROOMSECRET_KEY = "muc#roomconfig_roomsecret";
    public static final String TIGASE_ROOMCONFIG_PRESENCE_DELIVERY_LOGIC = "tigase#presence_delivery_logic";
    public static final String TIGASE_ROOMCONFIG_PRESENCE_FILTERED_AFFILIATIONS = "tigase#presence_filtered_affiliations";
    public static final String TIGASE_ROOMCONFIG_PRESENCE_FILTERING = "tigase#presence_filtering";
    public static final String TIGASE_ROOMCONFIG_WELCOME_MESSAGES = "tigase#welcome_messages";
    private static final String LOGGING_FORMAT_KEY = "logging_format";
    protected final Set<String> blacklist = new HashSet<String>();
    protected final Form form = new Form("form", null, null);
    private final ArrayList<RoomConfigListener> listeners = new ArrayList();
    private final BareJID roomJID;

    protected static <T extends Enum<T>> List<T> asEnum(Class<T> clazz, String[] values, Enum<?>[] defaultValues) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (values != null && values.length > 0) {
            for (String val : values) {
                list.add(Enum.valueOf(clazz, val));
            }
        } else if (null != defaultValues) {
            list.addAll(Arrays.asList(defaultValues));
        }
        return list;
    }

    protected static String[] asStringTable(Enum<?>[] values) {
        String[] result = new String[values.length];
        int i = 0;
        for (Enum<?> v : values) {
            result[i++] = v.name();
        }
        return result;
    }

    public RoomConfig(BareJID roomJID) {
        this.roomJID = roomJID;
        this.init();
    }

    public void addListener(RoomConfigListener listener) {
        this.listeners.add(listener);
    }

    private boolean asBoolean(Boolean value, boolean defaultValue) {
        return value == null ? defaultValue : value;
    }

    private String asString(String value, String defaultValue) {
        return value == null ? defaultValue : value;
    }

    public RoomConfig clone() {
        RoomConfig rc = new RoomConfig(this.getRoomJID());
        rc.blacklist.addAll(this.blacklist);
        rc.form.copyValuesFrom(this.form);
        return rc;
    }

    public String[] compareTo(RoomConfig oldConfig) {
        HashSet<String> result = new HashSet<String>();
        Set<String> vars = this.equals(oldConfig.form);
        for (String var : vars) {
            if (MUC_ROOMCONFIG_ANONYMITY_KEY.equals(var)) {
                switch (this.getRoomAnonymity()) {
                    case nonanonymous: {
                        result.add("172");
                        break;
                    }
                    case semianonymous: {
                        result.add("173");
                        break;
                    }
                    case fullanonymous: {
                        result.add("174");
                    }
                }
                continue;
            }
            if (MUC_ROOMCONFIG_ENABLELOGGING_KEY.equals(var)) {
                result.add(this.isLoggingEnabled() ? "170" : "171");
                continue;
            }
            result.add("104");
        }
        return result.size() == 0 ? null : result.toArray(new String[0]);
    }

    public void copyFrom(Form configForm) {
        this.copyFrom(configForm, true);
    }

    public void copyFrom(Form configForm, boolean fireEvents) {
        Set<String> modifiedVars = fireEvents ? this.equals(configForm) : null;
        this.form.copyValuesFrom(configForm);
        if (modifiedVars != null && modifiedVars.size() > 0) {
            this.fireConfigChanged(modifiedVars);
        }
    }

    public void copyFrom(RoomConfig c) {
        this.copyFrom(c.form, true);
    }

    public void copyFrom(RoomConfig c, boolean fireEvents) {
        this.copyFrom(c.form, fireEvents);
    }

    private Set<String> equals(Form form) {
        HashSet<String> result = new HashSet<String>();
        for (Field field : form.getAllFields()) {
            Field of = this.form.get(field.getVar());
            if (of == null) {
                result.add(field.getVar());
                continue;
            }
            boolean tmp = Arrays.equals(field.getValues(), of.getValues());
            if (tmp) continue;
            result.add(field.getVar());
        }
        return result;
    }

    private void fireConfigChanged(Set<String> modifiedVars) {
        this.fireConfigChanged(modifiedVars, false);
    }

    private void fireConfigChanged(Set<String> modifiedVars, boolean initialConfigUpdate) {
        for (RoomConfigListener listener : this.listeners) {
            if (!initialConfigUpdate) {
                listener.onConfigChanged(this, modifiedVars);
                continue;
            }
            listener.onInitialRoomConfig(this);
        }
    }

    public Element getAsElement() {
        Form form = new Form("form", null, null);
        this.init(form);
        form.copyValuesFrom(this.form);
        for (String field : this.blacklist) {
            form.removeField(field);
        }
        return form.getElement();
    }

    public Form getConfigForm() {
        return this.form;
    }

    public LogFormat getLoggingFormat() {
        try {
            String tmp = this.form.getAsString(LOGGING_FORMAT_KEY);
            return tmp == null ? LogFormat.html : LogFormat.valueOf(tmp);
        }
        catch (Exception e) {
            return LogFormat.html;
        }
    }

    public Integer getMaxHistory() {
        try {
            return this.form.getAsInteger(MUC_ROOMCONFIG_MAXHISTORY_KEY);
        }
        catch (Exception e) {
            return 50;
        }
    }

    public Integer getMaxUserResources() {
        try {
            String v = this.form.getAsString(MUC_ROOMCONFIG_MAX_USER_RESOURCES_KEY);
            if (v == null || v.isEmpty()) {
                return null;
            }
            return Integer.valueOf(v);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Integer getMaxUsers() {
        try {
            String v = this.form.getAsString(MUC_ROOMCONFIG_MAXUSERS_KEY);
            if (v == null || v.isEmpty()) {
                return null;
            }
            return Integer.valueOf(v);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getPassword() {
        return this.asString(this.form.getAsString(MUC_ROOMCONFIG_ROOMSECRET_KEY), "");
    }

    public PresenceStore.PresenceDeliveryLogic getPresenceDeliveryLogic() {
        String PDLasString = this.form.getAsString(TIGASE_ROOMCONFIG_PRESENCE_DELIVERY_LOGIC);
        PresenceStore.PresenceDeliveryLogic pdl = PresenceStore.PresenceDeliveryLogic.valueOf(PDLasString);
        return pdl;
    }

    public Collection<Affiliation> getPresenceFilteredAffiliations() {
        String[] presenceFrom = this.form.getAsStrings(TIGASE_ROOMCONFIG_PRESENCE_FILTERED_AFFILIATIONS);
        return RoomConfig.asEnum(Affiliation.class, presenceFrom, null);
    }

    public Anonymity getRoomAnonymity() {
        try {
            String tmp = this.form.getAsString(MUC_ROOMCONFIG_ANONYMITY_KEY);
            return tmp == null ? Anonymity.semianonymous : Anonymity.valueOf(tmp);
        }
        catch (Exception e) {
            return Anonymity.semianonymous;
        }
    }

    public String getRoomDesc() {
        return this.form.getAsString(MUC_ROOMCONFIG_ROOMDESC_KEY);
    }

    public BareJID getRoomJID() {
        return this.roomJID;
    }

    public String getRoomName() {
        return this.form.getAsString(MUC_ROOMCONFIG_ROOMNAME_KEY);
    }

    protected void init() {
        this.init(this.form);
    }

    protected void init(Form form) {
        form.addField(Field.fieldTextSingle((String)MUC_ROOMCONFIG_ROOMNAME_KEY, (String)"", (String)"Natural-Language Room Name"));
        form.addField(Field.fieldTextSingle((String)MUC_ROOMCONFIG_ROOMDESC_KEY, (String)"", (String)"Short Description of Room"));
        form.addField(Field.fieldBoolean((String)MUC_ROOMCONFIG_PERSISTENTROOM_KEY, (Boolean)Boolean.FALSE, (String)"Make Room Persistent?"));
        form.addField(Field.fieldBoolean((String)MUC_ROOMCONFIG_PUBLICROOM_KEY, (Boolean)Boolean.TRUE, (String)"Make Room Publicly Searchable?"));
        form.addField(Field.fieldBoolean((String)MUC_ROOMCONFIG_MODERATEDROOM_KEY, (Boolean)Boolean.FALSE, (String)"Make Room Moderated?"));
        form.addField(Field.fieldBoolean((String)MUC_ROOMCONFIG_MEMBERSONLY_KEY, (Boolean)Boolean.FALSE, (String)"Make Room Members Only?"));
        form.addField(Field.fieldBoolean((String)MUC_ROOMCONFIG_ALLOWINVITES_KEY, (Boolean)Boolean.TRUE, (String)"Allow Occupants to Invite Others?"));
        form.addField(Field.fieldBoolean((String)MUC_ROOMCONFIG_PASSWORDPROTECTEDROOM_KEY, (Boolean)Boolean.FALSE, (String)"Password Required to Enter?"));
        form.addField(Field.fieldTextSingle((String)MUC_ROOMCONFIG_ROOMSECRET_KEY, (String)"", (String)"Password"));
        form.addField(Field.fieldListSingle((String)MUC_ROOMCONFIG_ANONYMITY_KEY, (String)Anonymity.semianonymous.name(), (String)"Room anonymity level:", (String[])new String[]{"Non-Anonymous Room", "Semi-Anonymous Room", "Fully-Anonymous Room"}, (String[])new String[]{Anonymity.nonanonymous.name(), Anonymity.semianonymous.name(), Anonymity.fullanonymous.name()}));
        form.addField(Field.fieldBoolean((String)MUC_ROOMCONFIG_CHANGESUBJECT_KEY, (Boolean)Boolean.FALSE, (String)"Allow Occupants to Change Subject?"));
        form.addField(Field.fieldBoolean((String)MUC_ROOMCONFIG_ENABLELOGGING_KEY, (Boolean)Boolean.FALSE, (String)"Enable Public Logging?"));
        form.addField(Field.fieldListSingle((String)LOGGING_FORMAT_KEY, (String)LogFormat.html.name(), (String)"Logging format:", (String[])new String[]{"HTML", "Plain text"}, (String[])new String[]{LogFormat.html.name(), LogFormat.plain.name()}));
        form.addField(Field.fieldTextSingle((String)MUC_ROOMCONFIG_MAXHISTORY_KEY, (String)"50", (String)"Maximum Number of History Messages Returned by Room"));
        form.addField(Field.fieldListSingle((String)MUC_ROOMCONFIG_MAXUSERS_KEY, (String)"", (String)"Maximum Number of Occupants", (String[])new String[]{"10", "20", "30", "50", "100", "None"}, (String[])new String[]{"10", "20", "30", "50", "100", ""}));
        form.addField(Field.fieldListSingle((String)MUC_ROOMCONFIG_MAX_USER_RESOURCES_KEY, (String)"", (String)"Maximum Number of Single Occupant Resources", (String[])new String[]{"5", "10", "20", "30", "50", "100", "None"}, (String[])new String[]{"5", "10", "20", "30", "50", "100", ""}));
        form.addField(Field.fieldListSingle((String)TIGASE_ROOMCONFIG_PRESENCE_DELIVERY_LOGIC, (String)PresenceStore.PresenceDeliveryLogic.PREFERE_PRIORITY.toString(), (String)"Presence delivery logic", (String[])RoomConfig.asStringTable(PresenceStore.PresenceDeliveryLogic.values()), (String[])RoomConfig.asStringTable(PresenceStore.PresenceDeliveryLogic.values())));
        form.addField(Field.fieldBoolean((String)TIGASE_ROOMCONFIG_PRESENCE_FILTERING, (Boolean)Boolean.FALSE, (String)"Enable filtering of presence (broadcasting presence only between selected groups"));
        form.addField(Field.fieldListMulti((String)TIGASE_ROOMCONFIG_PRESENCE_FILTERED_AFFILIATIONS, null, (String)"Affiliations for which presence should be delivered", (String[])RoomConfig.asStringTable(Affiliation.values()), (String[])RoomConfig.asStringTable(Affiliation.values())));
        form.addField(Field.fieldBoolean((String)TIGASE_ROOMCONFIG_WELCOME_MESSAGES, (Boolean)Boolean.TRUE, (String)"Send welcome messages on room creation"));
    }

    public boolean isChangeSubject() {
        return this.asBoolean(this.form.getAsBoolean(MUC_ROOMCONFIG_CHANGESUBJECT_KEY), false);
    }

    public boolean isInvitingAllowed() {
        return this.asBoolean(this.form.getAsBoolean(MUC_ROOMCONFIG_ALLOWINVITES_KEY), true);
    }

    public boolean isLoggingEnabled() {
        return this.asBoolean(this.form.getAsBoolean(MUC_ROOMCONFIG_ENABLELOGGING_KEY), false);
    }

    public boolean isPasswordProtectedRoom() {
        return this.asBoolean(this.form.getAsBoolean(MUC_ROOMCONFIG_PASSWORDPROTECTEDROOM_KEY), false);
    }

    public boolean isPersistentRoom() {
        return this.asBoolean(this.form.getAsBoolean(MUC_ROOMCONFIG_PERSISTENTROOM_KEY), false);
    }

    public boolean isPresenceFilterEnabled() {
        return this.asBoolean(this.form.getAsBoolean(TIGASE_ROOMCONFIG_PRESENCE_FILTERING), false);
    }

    public boolean isRoomMembersOnly() {
        return this.asBoolean(this.form.getAsBoolean(MUC_ROOMCONFIG_MEMBERSONLY_KEY), false);
    }

    public boolean isRoomModerated() {
        return this.asBoolean(this.form.getAsBoolean(MUC_ROOMCONFIG_MODERATEDROOM_KEY), false);
    }

    public boolean isRoomconfigPublicroom() {
        return this.asBoolean(this.form.getAsBoolean(MUC_ROOMCONFIG_PUBLICROOM_KEY), true);
    }

    public boolean isWelcomeMessageEnabled() {
        return this.asBoolean(this.form.getAsBoolean(TIGASE_ROOMCONFIG_WELCOME_MESSAGES), true);
    }

    public void notifyConfigUpdate() {
        this.notifyConfigUpdate(false);
    }

    public void notifyConfigUpdate(boolean initialConfigUpdate) {
        HashSet<String> vars = new HashSet<String>();
        for (Field f : this.form.getAllFields()) {
            vars.add(f.getVar());
        }
        this.fireConfigChanged(vars, initialConfigUpdate);
    }

    @Deprecated
    public void read(UserRepository repository, MUCConfig config, String subnode) throws UserNotFoundException, TigaseDBException {
        String[] keys = repository.getKeys(config.getServiceName(), subnode);
        if (keys != null) {
            for (String key : keys) {
                String[] values = repository.getDataList(config.getServiceName(), subnode, key);
                this.setValues(key, values);
            }
        }
    }

    public void readFromElement(Element element) {
        this.form.copyValuesFrom(element);
    }

    public void removeListener(RoomConfigListener listener) {
        this.listeners.remove(listener);
    }

    public void setValue(String var, Object data) {
        Field f = this.form.get(var);
        if (f == null) {
            return;
        }
        if (data == null) {
            f.setValues(new String[0]);
        } else if (data instanceof String) {
            String str = (String)data;
            if (!(f.getType() != Field.FieldType.bool || "0".equals(str) || "1".equals(str) || "true".equalsIgnoreCase(str) || "false".equalsIgnoreCase(str))) {
                throw new RuntimeException("Boolean fields allows only '1', 'true', '0', 'false' values");
            }
            f.setValues(new String[]{str});
        } else if (data instanceof Boolean && f.getType() == Field.FieldType.bool) {
            boolean b = (Boolean)data;
            f.setValues(new String[]{b ? "1" : "0"});
        } else if (data instanceof String[] && (f.getType() == Field.FieldType.list_multi || f.getType() == Field.FieldType.text_multi)) {
            String[] d = (String[])data;
            f.setValues(d);
        } else {
            throw new RuntimeException("Cannot match type " + data.getClass().getCanonicalName() + " to field type " + f.getType().name());
        }
    }

    public void setValues(String var, String[] data) {
        if (data == null || data.length > 1) {
            this.setValue(var, data);
        } else if (data.length == 0) {
            this.setValue(var, null);
        } else {
            this.setValue(var, data[0]);
        }
    }

    @Deprecated
    public void write(UserRepository repo, MUCConfig config, String subnode) throws UserNotFoundException, TigaseDBException {
        List fields = this.form.getAllFields();
        for (Field field : fields) {
            if (field.getVar() == null || this.blacklist.contains(field.getVar())) continue;
            String[] values = field.getValues();
            String value = field.getValue();
            if (values == null || values.length == 0) {
                repo.removeData(config.getServiceName(), subnode, field.getVar());
                continue;
            }
            if (values.length == 1) {
                repo.setData(config.getServiceName(), subnode, field.getVar(), value);
                continue;
            }
            repo.setDataList(config.getServiceName(), subnode, field.getVar(), values);
        }
    }

    public static interface RoomConfigListener {
        public void onConfigChanged(RoomConfig var1, Set<String> var2);

        public void onInitialRoomConfig(RoomConfig var1);
    }

    public static enum LogFormat {
        html,
        plain,
        xml;

    }

    public static enum Anonymity {
        fullanonymous,
        nonanonymous,
        semianonymous;

    }
}

