/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.RepositoryException;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.repository.IMucRepository;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class MockMucRepository
implements IMucRepository {
    private final Map<BareJID, InternalRoom> allRooms = new HashMap<BareJID, InternalRoom>();
    private final RoomConfig.RoomConfigListener roomConfigListener;
    private final HashMap<BareJID, Room> rooms = new HashMap();
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private RoomConfig defaultConfig = new RoomConfig(null);

    public MockMucRepository() throws RepositoryException {
        this.roomConfigListener = new RoomConfig.RoomConfigListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onConfigChanged(RoomConfig roomConfig, Set<String> modifiedVars) {
                try {
                    InternalRoom ir;
                    if (modifiedVars.contains("muc#roomconfig_publicroom") && (ir = (InternalRoom)MockMucRepository.this.allRooms.get(roomConfig.getRoomJID())) != null) {
                        ir.isPublic = roomConfig.isRoomconfigPublicroom();
                    }
                    if (modifiedVars.contains("muc#roomconfig_persistentroom")) {
                        if (roomConfig.isPersistentRoom()) {
                            MockMucRepository.this.log.log(Level.FINEST, "now is PERSISTENT");
                            ir = MockMucRepository.this.getRoom(roomConfig.getRoomJID());
                            return;
                        } else {
                            MockMucRepository.this.log.log(Level.FINEST, "now is NOT! PERSISTENT");
                        }
                        return;
                    }
                    if (!roomConfig.isPersistentRoom()) return;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void onInitialRoomConfig(RoomConfig roomConfig) {
                try {
                    InternalRoom ir;
                    if (roomConfig.isRoomconfigPublicroom() && (ir = (InternalRoom)MockMucRepository.this.allRooms.get(roomConfig.getRoomJID())) != null) {
                        ir.isPublic = roomConfig.isRoomconfigPublicroom();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public Room createNewRoom(BareJID roomJID, JID senderJid) throws RepositoryException {
        this.log.fine("Creating new room '" + roomJID + "'");
        RoomConfig rc = new RoomConfig(roomJID);
        rc.copyFrom(this.getDefaultRoomConfig(), false);
        Room room = new Room(rc, new Date(), senderJid.getBareJID());
        room.getConfig().addListener(this.roomConfigListener);
        this.rooms.put(roomJID, room);
        this.allRooms.put(roomJID, new InternalRoom());
        return room;
    }

    public void destroyRoom(Room room, Element destroyElement) throws RepositoryException {
        BareJID roomJID = room.getRoomJID();
        this.rooms.remove(roomJID);
        this.allRooms.remove(roomJID);
    }

    public Map<BareJID, Room> getActiveRooms() {
        return Collections.unmodifiableMap(this.rooms);
    }

    public RoomConfig getDefaultRoomConfig() throws RepositoryException {
        return this.defaultConfig;
    }

    public BareJID[] getPublicVisibleRoomsIdList() throws RepositoryException {
        ArrayList<BareJID> result = new ArrayList<BareJID>();
        for (Map.Entry<BareJID, InternalRoom> entry : this.allRooms.entrySet()) {
            if (!entry.getValue().isPublic) continue;
            result.add(entry.getKey());
        }
        return result.toArray(new BareJID[0]);
    }

    public Map<BareJID, String> getPublicVisibleRooms(String domain) throws RepositoryException {
        HashMap<BareJID, String> result = new HashMap<BareJID, String>();
        for (Map.Entry<BareJID, InternalRoom> entry : this.allRooms.entrySet()) {
            String name;
            if (!entry.getValue().isPublic) continue;
            BareJID jid = entry.getKey();
            Room room = this.getRoom(jid);
            String string = name = room != null ? room.getConfig().getRoomName() : null;
            if (name != null && name.isEmpty()) {
                name = null;
            }
            if (name == null) {
                name = jid.getLocalpart();
            }
            result.put(jid, name);
        }
        return result;
    }

    public Room getRoom(BareJID roomJID) throws RepositoryException {
        Room room = this.rooms.get(roomJID);
        return room;
    }

    public boolean isRoomIdExists(String newRoomName) {
        return this.allRooms.containsKey(newRoomName);
    }

    public void leaveRoom(Room room) {
        BareJID roomJID = room.getRoomJID();
        this.log.fine("Removing room '" + roomJID + "' from memory");
        this.rooms.remove(roomJID);
        if (!room.getConfig().isPersistentRoom()) {
            this.allRooms.remove(roomJID);
        }
    }

    public void updateDefaultRoomConfig(RoomConfig config) throws RepositoryException {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    private class InternalRoom {
        boolean isPublic = true;

        private InternalRoom() {
        }
    }
}

