/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import org.junit.Before;
import org.junit.Test;
import tigase.component.exceptions.RepositoryException;
import tigase.muc.Affiliation;
import tigase.muc.MUCComponent;
import tigase.muc.MockMucRepository;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.TestMUCCompoent;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.ModeratorModule;
import tigase.muc.utils.ArrayWriter;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class ModeratorModuleTest {
    private JID admin;
    private JID member;
    private ModeratorModule moderatorModule;
    private MUCComponent mucComponent;
    private Room room;

    @Before
    public void init() throws RepositoryException, TigaseStringprepException {
        ArrayWriter writer = new ArrayWriter();
        this.mucComponent = new TestMUCCompoent(writer, new MockMucRepository());
        this.mucComponent.setName("muc");
        this.admin = JID.jidInstance((String)"admin@example.com/res1");
        this.member = JID.jidInstance((String)"member@example.com/res1");
        this.room = this.mucComponent.getMucRepository().createNewRoom(BareJID.bareJIDInstance((String)"darkcave@macbeth.shakespeare.lit"), this.admin);
        this.room.addAffiliationByJid(this.admin.getBareJID(), Affiliation.admin);
        this.room.addAffiliationByJid(this.member.getBareJID(), Affiliation.member);
        this.moderatorModule = new ModeratorModule();
    }

    @Test(expected=MUCException.class)
    public void checkEmptyItem() throws Exception {
        Element item = new Element("item");
        this.moderatorModule.checkItem(this.room, item, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test(expected=MUCException.class)
    public void checkModifyVoiceItemRoleWithoutNick() throws Exception {
        Element item1 = new Element("item", new String[]{"jid", "role"}, new String[]{"member@example.com", Role.participant.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test(expected=MUCException.class)
    public void checkModifyVoiceItemRoleWithoutNickAndWithAffiliation() throws Exception {
        Element item1 = new Element("item", new String[]{"role", "affiliation"}, new String[]{Role.none.toString(), Affiliation.owner.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test(expected=MUCException.class)
    public void checkModifyVoiceItemRoleOnly() throws Exception {
        Element item1 = new Element("item", new String[]{"role"}, new String[]{Role.participant.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test(expected=MUCException.class)
    public void checkModifyOwnerItemAffiliationWithoutJid() throws Exception {
        Element item1 = new Element("item", new String[]{"nick", "affiliation"}, new String[]{"member_user", Affiliation.owner.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test(expected=MUCException.class)
    public void checkModifyOwnerItemAffiliationOnly() throws Exception {
        Element item1 = new Element("item", new String[]{"affiliation"}, new String[]{Affiliation.owner.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test
    public void checkModifyVoiceItem() throws Exception {
        Element item1 = new Element("item", new String[]{"nick", "role"}, new String[]{"member_user", Role.participant.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }

    @Test
    public void checkModifyOwnerItem() throws Exception {
        Element item1 = new Element("item", new String[]{"jid", "affiliation"}, new String[]{"member@example.com", Affiliation.owner.toString()});
        this.moderatorModule.checkItem(this.room, item1, this.admin, Affiliation.admin, Role.moderator);
    }
}

