/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Before;
import org.junit.Test;
import tigase.component.PacketWriter;
import tigase.component.exceptions.RepositoryException;
import tigase.component.responses.AsyncCallback;
import tigase.conf.ConfigurationException;
import tigase.muc.MUCComponent;
import tigase.muc.MockMucRepository;
import tigase.muc.TestMUCCompoent;
import tigase.server.Packet;
import tigase.test.junit.JUnitXMLIO;
import tigase.test.junit.XMPPTestCase;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;

public class PresenceTestNAMultiPresenceTest
extends XMPPTestCase {
    private MUCComponent pubsub;
    private JUnitXMLIO xmlio;

    @Before
    public void init() throws RepositoryException, TigaseStringprepException, ConfigurationException {
        final ArrayWriter writer = new ArrayWriter();
        this.pubsub = new TestMUCCompoent(writer, new MockMucRepository());
        this.pubsub.setName("xxx");
        Map props = this.pubsub.getDefaults(new HashMap());
        props.put("multi-user-chat", BareJID.bareJIDInstance((String)"multi-user-chat"));
        props.put("message-filter-enabled", Boolean.TRUE);
        props.put("presence-filter-enabled", Boolean.FALSE);
        props.put("muc-multi-item-allowed", Boolean.TRUE);
        props.put("room-log-directory", "./");
        this.xmlio = new JUnitXMLIO(){

            public void close() {
            }

            public void setIgnorePresence(boolean arg0) {
            }

            public void write(Element data) throws IOException {
                try {
                    writer.clear();
                    Packet p = Packet.packetInstance((Element)data);
                    p.setXMLNS("jabber:client");
                    PresenceTestNAMultiPresenceTest.this.pubsub.processPacket(p);
                    this.send(writer.elements);
                }
                catch (TigaseStringprepException e) {
                    e.printStackTrace();
                }
            }
        };
        try {
            this.pubsub.setProperties(props);
        }
        catch (ConfigurationException ex) {
            ex.printStackTrace();
        }
    }

    @Test
    public void test_presences2_non_anonymous() {
        PresenceTestNAMultiPresenceTest.test((String)"src/test/scripts/processPresence2-nonanonymous-multipresence.cor", (JUnitXMLIO)this.xmlio);
    }

    private final class ArrayWriter
    implements PacketWriter {
        private final ArrayList<Element> elements = new ArrayList();

        private ArrayWriter() {
        }

        public void clear() {
            this.elements.clear();
        }

        public void write(Collection<Packet> elements) {
            for (Packet packet : elements) {
                this.elements.add(packet.getElement());
            }
        }

        public void write(Packet element) {
            this.elements.add(element.getElement());
        }

        public void write(Packet packet, AsyncCallback callback) {
            this.write(packet);
        }
    }
}

