/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.Affiliation;
import tigase.muc.MucContext;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractMucModule;
import tigase.muc.modules.PresenceModuleImpl;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class ModeratorModule
extends AbstractMucModule {
    public static final String ID = "admin";
    protected static final Criteria CRIT = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"query", (String)"http://jabber.org/protocol/muc#admin"));

    protected static Affiliation getAffiliation(Element item) throws MUCException {
        String tmp = item.getAttributeStaticStr("affiliation");
        try {
            return tmp == null ? null : Affiliation.valueOf(tmp);
        }
        catch (IllegalArgumentException e) {
            throw new MUCException(Authorization.BAD_REQUEST, "Unknown affiliation value: " + tmp);
        }
    }

    protected static String getReason(Element item) {
        Element r = item.getChild("reason");
        return r == null ? null : r.getCData();
    }

    protected static Role getRole(Element item) {
        String tmp = item.getAttributeStaticStr("role");
        return tmp == null ? null : Role.valueOf(tmp);
    }

    protected void checkItem(Room room, Element item, JID senderJid, Affiliation senderaAffiliation, Role senderRole) throws MUCException, TigaseStringprepException {
        Role newRole = ModeratorModule.getRole(item);
        Affiliation newAffiliation = ModeratorModule.getAffiliation(item);
        HashSet<String> occupantNicknames = new HashSet<String>();
        String nick = item.getAttributeStaticStr("nick");
        String jid = item.getAttributeStaticStr("jid");
        if (newRole != null && nick != null) {
            occupantNicknames.add(nick);
        } else if (newAffiliation != null && jid != null) {
            occupantNicknames.addAll(room.getOccupantsNicknames(BareJID.bareJIDInstance((String)jid)));
        } else {
            throw new MUCException(Authorization.BAD_REQUEST);
        }
        for (String occupantNickname : occupantNicknames) {
            Affiliation occupantAffiliation = room.getAffiliation(occupantNickname);
            if (newRole != null && newAffiliation == null) {
                if (newRole == Role.none && !senderRole.isKickParticipantsAndVisitors()) {
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("User " + senderJid + " (a:" + (Object)((Object)senderaAffiliation) + "; r:" + (Object)((Object)senderRole) + ") is not allowed to kick user " + occupantNickname + " (a:" + (Object)((Object)occupantAffiliation) + ")");
                    }
                    throw new MUCException(Authorization.NOT_ALLOWED, "You cannot kick");
                }
                if (newRole == Role.none && occupantAffiliation.getWeight() > senderaAffiliation.getWeight()) {
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("User " + senderJid + " (a:" + (Object)((Object)senderaAffiliation) + "; r:" + (Object)((Object)senderRole) + ") is not allowed to kick user " + occupantNickname + " (a:" + (Object)((Object)occupantAffiliation) + ") because of lower affiliation.");
                    }
                    throw new MUCException(Authorization.NOT_ALLOWED, "You cannot kick occupant with higher affiliation");
                }
                if (newRole == Role.participant && !senderRole.isGrantVoice()) {
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("User " + senderJid + " (a:" + (Object)((Object)senderaAffiliation) + "; r:" + (Object)((Object)senderRole) + ") is not allowed to grant voice to user " + occupantNickname + " (a:" + (Object)((Object)occupantAffiliation) + ") because of lower affiliation.");
                    }
                    throw new MUCException(Authorization.NOT_ALLOWED, "You cannot grant voice");
                }
                if (newRole == Role.visitor && !senderRole.isRevokeVoice()) {
                    throw new MUCException(Authorization.NOT_ALLOWED, "You cannot revoke voice");
                }
                if (newRole == Role.visitor && occupantAffiliation.getWeight() >= senderaAffiliation.getWeight()) {
                    throw new MUCException(Authorization.NOT_ALLOWED, "You revoke voice occupant with higher affiliation");
                }
                if (newRole != Role.moderator || senderaAffiliation.isEditModeratorList()) continue;
                throw new MUCException(Authorization.NOT_ALLOWED, "You cannot grant moderator provileges");
            }
            if (newRole == null && newAffiliation != null) {
                if (item.getAttributeStaticStr("jid") == null) {
                    throw new MUCException(Authorization.BAD_REQUEST);
                }
                if (newAffiliation == Affiliation.outcast && !senderaAffiliation.isBanMembersAndUnaffiliatedUsers()) {
                    throw new MUCException(Authorization.NOT_ALLOWED, "You cannot ban");
                }
                if (newAffiliation == Affiliation.outcast && occupantAffiliation.getWeight() >= senderaAffiliation.getWeight()) {
                    throw new MUCException(Authorization.NOT_ALLOWED, "You ban occupant with higher affiliation");
                }
                if (newAffiliation == Affiliation.member && !senderaAffiliation.isEditMemberList()) {
                    throw new MUCException(Authorization.NOT_ALLOWED, "You cannot grant membership");
                }
                if (newAffiliation == Affiliation.admin && !senderaAffiliation.isEditAdminList()) {
                    throw new MUCException(Authorization.NOT_ALLOWED, "You cannot grant admin provileges");
                }
                if (newAffiliation == Affiliation.owner && !senderaAffiliation.isEditOwnerList()) {
                    throw new MUCException(Authorization.NOT_ALLOWED, "You cannot grant owner provileges");
                }
                if (newAffiliation != Affiliation.none || occupantAffiliation.getWeight() <= senderaAffiliation.getWeight()) continue;
                throw new MUCException(Authorization.NOT_ALLOWED, "You cannot remove affiliation occupant with higher affiliation");
            }
            throw new MUCException(Authorization.BAD_REQUEST);
        }
    }

    public String[] getFeatures() {
        return null;
    }

    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public void kickWithoutBroadcast(Room room, String occupantNick, String reason, String actor) throws TigaseStringprepException {
        ArrayList<String> codes = new ArrayList<String>();
        BareJID occupantJid = room.getOccupantsJidByNickname(occupantNick);
        Affiliation occupantAffiliation = room.getAffiliation(occupantJid);
        codes.add("307");
        boolean isUnavailable = true;
        Collection<JID> occupantJids = room.getOccupantsJidsByNickname(occupantNick);
        for (JID jid : occupantJids) {
            Packet occupantKickPresence = this.makePresence(jid, room.getRoomJID(), room, occupantJid, isUnavailable, occupantAffiliation, Role.none, occupantNick, reason, actor, codes.toArray(new String[0]));
            this.write(occupantKickPresence);
        }
        room.removeOccupant(occupantNick);
    }

    protected Packet makePresence(JID destinationJid, BareJID roomJID, Room room, BareJID occupantJid, boolean unavailable, Affiliation affiliation, Role role, String nick, String reason, String actor, String ... codes) throws TigaseStringprepException {
        Element presence = unavailable ? new Element("presence", new String[]{"type"}, new String[]{"unavailable"}) : room.getLastPresenceCopyByJid(occupantJid);
        try {
            presence.setAttribute("from", JID.jidInstance((BareJID)roomJID, (String)nick).toString());
        }
        catch (TigaseStringprepException e) {
            presence.setAttribute("from", roomJID.toString() + "/" + nick);
        }
        presence.setAttribute("to", destinationJid.toString());
        Element x = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
        presence.addChild((XMLNodeIfc)x);
        Element item = new Element("item");
        x.addChild((XMLNodeIfc)item);
        if (role != null) {
            item.setAttribute("role", role.name());
        }
        if (affiliation != null) {
            item.setAttribute("affiliation", affiliation.name());
        }
        if (nick != null) {
            item.setAttribute("nick", nick);
        }
        if (actor != null) {
            item.addChild((XMLNodeIfc)new Element("actor", new String[]{"jid"}, new String[]{actor}));
        }
        if (reason != null) {
            item.addChild((XMLNodeIfc)new Element("reason", reason));
        }
        if (codes != null) {
            for (String code : codes) {
                if (code == null) continue;
                x.addChild((XMLNodeIfc)new Element("status", new String[]{"code"}, new String[]{code}));
            }
        }
        Packet result = Packet.packetInstance((Element)presence);
        result.setXMLNS("jabber:client");
        return result;
    }

    public void process(Packet element) throws MUCException {
        block6: {
            try {
                StanzaType type = element.getType();
                if (ModeratorModule.getNicknameFromJid(element.getTo()) != null) {
                    throw new MUCException(Authorization.BAD_REQUEST);
                }
                if (type == StanzaType.set) {
                    this.processSet(element);
                    break block6;
                }
                if (type == StanzaType.get) {
                    this.processGet(element);
                    break block6;
                }
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            catch (MUCException e1) {
                throw e1;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    protected void processGet(Packet element) throws RepositoryException, MUCException {
        try {
            BareJID roomJID = BareJID.bareJIDInstance((String)element.getAttributeStaticStr("to"));
            Room room = ((MucContext)this.context).getMucRepository().getRoom(roomJID);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND);
            }
            List items = element.getElemChildrenStaticStr(new String[]{"iq", "query"});
            JID senderJID = JID.jidInstance((String)element.getAttributeStaticStr("from"));
            String senderNickname = room.getOccupantsNickname(senderJID);
            Affiliation senderAffiliation = room.getAffiliation(senderJID.getBareJID());
            Role senderRole = room.getRole(senderNickname);
            HashSet<Item> resultItems = new HashSet<Item>();
            HashSet<Enum> filter = new HashSet<Enum>();
            for (Element element2 : items) {
                if (!element2.getName().equals("item")) {
                    throw new MUCException(Authorization.NOT_ACCEPTABLE);
                }
                String tmp = element2.getAttributeStaticStr("role");
                if (tmp != null && tmp.equals("all")) {
                    for (Enum enum_ : Role.values()) {
                        filter.add(enum_);
                    }
                    continue;
                }
                tmp = element2.getAttributeStaticStr("affiliation");
                if (tmp != null && tmp.equals("all")) {
                    for (Enum enum_ : Affiliation.values()) {
                        filter.add(enum_);
                    }
                    continue;
                }
                Role filterRole = ModeratorModule.getRole(element2);
                Affiliation filterAffiliation = ModeratorModule.getAffiliation(element2);
                if (filterRole != null) {
                    filter.add(filterRole);
                }
                if (filterAffiliation == null) continue;
                filter.add(filterAffiliation);
            }
            for (Object e : filter) {
                Role filterRole = e instanceof Role ? (Role)((Object)e) : null;
                Affiliation filterAffiliation = e instanceof Affiliation ? (Affiliation)((Object)e) : null;
                boolean allowed = false;
                allowed = allowed || senderAffiliation == Affiliation.admin;
                allowed = allowed || senderAffiliation == Affiliation.owner;
                boolean bl = allowed = allowed || room.getConfig().getRoomAnonymity() == RoomConfig.Anonymity.nonanonymous && senderRole.isPresentInRoom();
                if (!allowed) {
                    throw new MUCException(Authorization.FORBIDDEN);
                }
                this.processMatchingItems(element, room, filterAffiliation, filterRole, resultItems);
            }
            Element responseQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#admin"});
            for (Item resultItem : resultItems) {
                responseQuery.addChild((XMLNodeIfc)resultItem);
            }
            this.write(element.okResult(responseQuery, 0));
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected void processMatchingItems(Packet iq, Room room, Affiliation filterAffiliation, Role filterRole, Collection<Item> resultItems) throws RepositoryException, MUCException {
        for (BareJID jid : room.getAffiliations()) {
            Item i;
            Affiliation affiliation = room.getAffiliation(jid);
            if (filterAffiliation == null || affiliation != filterAffiliation || resultItems.contains((Object)(i = new Item(affiliation, jid, null, null)))) continue;
            resultItems.add(i);
        }
        for (String occupantNickname : room.getOccupantsNicknames()) {
            Role role = room.getRole(occupantNickname);
            BareJID occupantBareJid = room.getOccupantsJidByNickname(occupantNickname);
            Affiliation affiliation = room.getAffiliation(occupantBareJid);
            if ((filterRole == null || role != filterRole) && (filterAffiliation == null || affiliation != filterAffiliation)) continue;
            BareJID jid = room.getConfig().getRoomAnonymity() != RoomConfig.Anonymity.fullanonymous ? occupantBareJid : null;
            Item i = new Item(affiliation, jid, occupantNickname, role);
            resultItems.remove((Object)i);
            resultItems.add(i);
        }
    }

    protected void processSet(Packet element) throws RepositoryException, MUCException {
        try {
            BareJID roomJID = BareJID.bareJIDInstance((String)element.getAttributeStaticStr("to"));
            Room room = ((MucContext)this.context).getMucRepository().getRoom(roomJID);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND);
            }
            JID senderJid = JID.jidInstance((String)element.getAttributeStaticStr("from"));
            String nickName = room.getOccupantsNickname(senderJid);
            Affiliation senderAffiliation = room.getAffiliation(senderJid.getBareJID());
            Role senderRole = nickName == null ? PresenceModuleImpl.getDefaultRole(room.getConfig(), senderAffiliation) : room.getRole(nickName);
            Element query = element.getElement().getChild("query");
            List items = query.getChildren();
            if (items == null) {
                throw new MUCException(Authorization.NOT_ACCEPTABLE);
            }
            for (Element item : items) {
                this.checkItem(room, item, senderJid, senderAffiliation, senderRole);
            }
            for (Element item : items) {
                Role newRole = ModeratorModule.getRole(item);
                Affiliation newAffiliation = ModeratorModule.getAffiliation(item);
                String reason = ModeratorModule.getReason(item);
                String actor = senderJid.toString();
                if (newAffiliation != null) {
                    this.processSetAffiliation(room, item, newAffiliation, newRole, reason, actor);
                }
                if (newRole == null) continue;
                String occupantNick = item.getAttributeStaticStr("nick");
                this.processSetRole(room, occupantNick, newRole, reason, actor);
            }
            this.write(element.okResult((Element)null, 0));
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected void processSetAffiliation(Room room, Element item, Affiliation newAffiliation, Role newRole, String reason, String actor) throws RepositoryException, TigaseStringprepException {
        Collection<JID> occupantJids;
        BareJID occupantBareJid = JID.jidInstance((String)item.getAttributeStaticStr("jid")).getBareJID();
        Affiliation previousAffiliation = room.getAffiliation(occupantBareJid);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Set affiliation of " + occupantBareJid + " to " + (Object)((Object)newAffiliation) + " (from: " + (Object)((Object)previousAffiliation) + ")");
        }
        if (room.getConfig().isRoomMembersOnly() && previousAffiliation.getWeight() <= Affiliation.none.getWeight() && newAffiliation.getWeight() >= Affiliation.member.getWeight()) {
            this.sendInvitation(room, occupantBareJid, actor);
        }
        room.addAffiliationByJid(occupantBareJid, newAffiliation);
        boolean isUnavailable = false;
        HashSet<String> codes = new HashSet<String>();
        Collection<String> occupantsNicknames = room.getOccupantsNicknames(occupantBareJid);
        boolean kick = newAffiliation == Affiliation.outcast;
        if (kick |= room.getConfig().isRoomMembersOnly() && newAffiliation == Affiliation.none) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Kicking occupant " + occupantBareJid + " (" + occupantsNicknames + ")");
            }
            for (String occupantNick : occupantsNicknames) {
                codes.add("301");
                isUnavailable = true;
                occupantJids = room.getOccupantsJidsByNickname(occupantNick);
                for (JID jid : occupantJids) {
                    Packet occupantKickPresence = this.makePresence(jid, room.getRoomJID(), room, occupantBareJid, isUnavailable, newAffiliation, newRole, occupantNick, reason, actor, codes.toArray(new String[0]));
                    this.write(occupantKickPresence);
                }
                room.removeOccupant(occupantNick);
                ((MucContext)this.context).getGhostbuster().remove(occupantJids, room);
            }
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Sending new affiliation of " + occupantBareJid + " to occupants " + room.getOccupantsNicknames());
        }
        for (String nickname : room.getOccupantsNicknames()) {
            occupantJids = room.getOccupantsJidsByNickname(nickname);
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Sending new affiliation of " + occupantBareJid + " to occupant " + nickname + " (" + occupantJids + ")");
            }
            for (JID jid : occupantJids) {
                for (String changedNickname : occupantsNicknames) {
                    Role currentRole = room.getRole(changedNickname);
                    Packet occupantPresence = this.makePresence(jid, room.getRoomJID(), room, occupantBareJid, isUnavailable, newAffiliation, currentRole, changedNickname, reason, null, codes.toArray(new String[0]));
                    this.write(occupantPresence);
                }
            }
        }
    }

    protected void processSetRole(Room room, String occupantNick, Role newRole, String reason, String actor) throws TigaseStringprepException {
        BareJID occupantJid = room.getOccupantsJidByNickname(occupantNick);
        Affiliation occupantAffiliation = room.getAffiliation(occupantJid);
        boolean isUnavailable = false;
        ArrayList<String> codes = new ArrayList<String>();
        if (newRole == Role.none) {
            codes.add("307");
            isUnavailable = true;
            Collection<JID> occupantJids = room.getOccupantsJidsByNickname(occupantNick);
            for (JID jid : occupantJids) {
                Packet occupantKickPresence = this.makePresence(jid, room.getRoomJID(), room, occupantJid, isUnavailable, occupantAffiliation, newRole, occupantNick, reason, actor, codes.toArray(new String[0]));
                this.write(occupantKickPresence);
            }
            room.removeOccupant(occupantNick);
            ((MucContext)this.context).getGhostbuster().remove(occupantJids, room);
        } else {
            room.setNewRole(occupantNick, newRole);
        }
        for (String nickname : room.getOccupantsNicknames()) {
            Collection<JID> occupantJids = room.getOccupantsJidsByNickname(nickname);
            for (JID jid : occupantJids) {
                Packet occupantPresence = this.makePresence(jid, room.getRoomJID(), room, occupantJid, isUnavailable, occupantAffiliation, newRole, occupantNick, reason, null, codes.toArray(new String[0]));
                this.write(occupantPresence);
            }
        }
    }

    protected void sendInvitation(Room room, BareJID occupantBareJid, String actor) throws TigaseStringprepException {
        Packet message = Packet.packetInstance((Element)new Element("message", new String[]{"from", "to"}, new String[]{room.getRoomJID().toString(), occupantBareJid.toString()}));
        message.setXMLNS("jabber:client");
        Element x = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
        message.getElement().addChild((XMLNodeIfc)x);
        Element invite = new Element("invite", new String[]{"from"}, new String[]{actor});
        x.addChild((XMLNodeIfc)invite);
        if (room.getConfig().isPasswordProtectedRoom()) {
            x.addChild((XMLNodeIfc)new Element("password", room.getConfig().getPassword()));
        }
        this.write(message);
    }

    static class Item
    extends Element {
        private final Affiliation affiliation;
        private final BareJID jid;
        private final String nick;
        private final Role role;

        private Item(Affiliation affiliation, BareJID jid, String nick, Role role) {
            super("item");
            this.affiliation = affiliation;
            if (this.affiliation != null) {
                this.setAttribute("affiliation", affiliation.name());
            }
            this.jid = jid;
            if (this.jid != null) {
                this.setAttribute("jid", jid.toString());
            }
            this.nick = nick;
            if (this.nick != null) {
                this.setAttribute("nick", nick);
            }
            this.role = role;
            if (this.role != null) {
                this.setAttribute("role", role.name());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Item item = (Item)((Object)o);
            if (this.jid != null && item.jid != null) {
                return this.jid.equals((Object)item.jid);
            }
            return this.nick != null ? this.nick.equals(item.nick) : item.nick == null;
        }

        public int hashCode() {
            if (this.jid != null) {
                return this.jid.hashCode();
            }
            if (this.nick != null) {
                return this.nick.hashCode();
            }
            return super.hashCode();
        }
    }
}

