/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.component.exceptions.RepositoryException;
import tigase.conf.ConfigurationException;
import tigase.muc.MUCComponent;
import tigase.muc.MockMucRepository;
import tigase.muc.Room;
import tigase.muc.TestMUCCompoent;
import tigase.muc.utils.ArrayWriter;
import tigase.server.Packet;
import tigase.test.junit.JUnitXMLIO;
import tigase.test.junit.XMPPTestCase;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class RoomTest
extends XMPPTestCase {
    private MUCComponent pubsub;
    private JUnitXMLIO xmlio;

    @Before
    public void init() throws RepositoryException, TigaseStringprepException, ConfigurationException {
        final ArrayWriter writer = new ArrayWriter();
        this.pubsub = new TestMUCCompoent(writer, new MockMucRepository());
        this.pubsub.setName("xxx");
        Map props = this.pubsub.getDefaults(new HashMap());
        props.put("multi-user-chat", BareJID.bareJIDInstance((String)"multi-user-chat"));
        props.put("message-filter-enabled", Boolean.TRUE);
        props.put("presence-filter-enabled", Boolean.FALSE);
        props.put("room-log-directory", "./");
        this.xmlio = new JUnitXMLIO(){

            public void close() {
            }

            public void setIgnorePresence(boolean arg0) {
            }

            public void write(Element data) throws IOException {
                try {
                    writer.clear();
                    Packet p = Packet.packetInstance((Element)data);
                    p.setXMLNS("jabber:client");
                    RoomTest.this.pubsub.processPacket(p);
                    this.send(writer.getElements());
                }
                catch (TigaseStringprepException e) {
                    e.printStackTrace();
                }
            }
        };
        try {
            this.pubsub.setProperties(props);
        }
        catch (ConfigurationException ex) {
            ex.printStackTrace();
        }
    }

    @Test
    public void test_destroyRoom() {
        RoomTest.test((String)"src/test/scripts/destroying-room.cor", (JUnitXMLIO)this.xmlio);
        try {
            Room room = this.pubsub.getMucRepository().getRoom(BareJID.bareJIDInstance((String)"darkcave@macbeth.shakespeare.lit"));
            Assert.assertNull((String)"Room should be destroyed", (Object)room);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void test_getting_members_list() {
        RoomTest.test((String)"src/test/scripts/gettingMembersList-ext.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_ghostUser() {
        RoomTest.test((String)"src/test/scripts/ghostUser.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_hiddenRoomProblem() {
        RoomTest.test((String)"src/test/scripts/hidden-room-problem.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_invitations_allowed() {
        RoomTest.test((String)"src/test/scripts/invitation_allowed.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_invitations_allowed_membersonly() {
        RoomTest.test((String)"src/test/scripts/invitation_allowed_membersonly.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_invitations_notallowed() {
        RoomTest.test((String)"src/test/scripts/invitation_not_allowed.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_invitations_notallowed_membersonly() {
        RoomTest.test((String)"src/test/scripts/invitation_not_allowed_membersonly.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_members_only_subject() {
        RoomTest.test((String)"src/test/scripts/members-only-subject.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_room_config() {
        RoomTest.test((String)"src/test/scripts/room-configuration.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_messages() {
        RoomTest.test((String)"src/test/scripts/messagesGroupchat.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_nonpersistentRoomProblem() {
        RoomTest.test((String)"src/test/scripts/nonpersistent-room-problem.cor", (JUnitXMLIO)this.xmlio);
        try {
            Room room = this.pubsub.getMucRepository().getRoom(BareJID.bareJIDInstance((String)"darkcave@macbeth.shakespeare.lit"));
            Assert.assertNull((String)"Room should be destroyed", (Object)room);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void test_pings() {
        RoomTest.test((String)"src/test/scripts/ping.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_presences2() {
        RoomTest.test((String)"src/test/scripts/processPresence2.cor", (JUnitXMLIO)this.xmlio);
    }

    @Test
    public void test_presences2_exiting() throws Exception {
        RoomTest.test((String)"src/test/scripts/processPresence2-exiting.cor", (JUnitXMLIO)this.xmlio);
        Room room = this.pubsub.getMucRepository().getRoom(BareJID.bareJIDInstanceNS((String)"darkcave@macbeth.shakespeare.lit"));
        Assert.assertNotNull((Object)room);
        Collection nicknames = room.getOccupantsNicknames();
        Assert.assertEquals((long)1L, (long)nicknames.size());
        Assert.assertTrue((boolean)nicknames.contains("firstwitch"));
        Assert.assertEquals((Object)"firstwitch", (Object)room.getOccupantsNickname(JID.jidInstanceNS((String)"crone1@shakespeare.lit/desktop")));
        Assert.assertEquals((Object)BareJID.bareJIDInstance((String)"crone1@shakespeare.lit"), (Object)room.getOccupantsJidByNickname("firstwitch"));
    }

    @Test
    public void test_presences2_non_anonymous() {
        RoomTest.test((String)"src/test/scripts/processPresence2-nonanonymous.cor", (JUnitXMLIO)this.xmlio);
    }
}

