/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import tigase.component.exceptions.RepositoryException;
import tigase.muc.Ghostbuster2;
import tigase.muc.MockMucRepository;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.modules.PresenceModule;
import tigase.muc.modules.PresenceModuleImpl;
import tigase.server.Packet;
import tigase.server.ReceiverTimeoutHandler;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.PacketErrorTypeException;

public class Ghostbuster2Test {
    @Test
    public void testPingForOver1000() throws Exception {
        MUCComponent mucComponent = new MUCComponent();
        final AtomicBoolean timeouts = new AtomicBoolean(true);
        PresenceModuleImpl presenceModule = new PresenceModuleImpl(){

            public void doQuit(Room room, JID senderJID) throws TigaseStringprepException {
                room.removeOccupant(senderJID);
            }
        };
        Ghostbuster2 ghostbuster2 = new Ghostbuster2((tigase.muc.MUCComponent)mucComponent);
        ghostbuster2.setPresenceModule((PresenceModule)presenceModule);
        ConcurrentHashMap<BareJID, Room> activeRooms = new ConcurrentHashMap<BareJID, Room>();
        for (int i = 0; i < 4000; ++i) {
            JID jid = JID.jidInstance((String)("user-" + i + "@test"));
            Room room = new Room(new RoomConfig(BareJID.bareJIDInstance((String)("room-" + i + "@muc.test"))), new Date(), jid.getBareJID());
            room.addOccupantByJid(jid, jid.getLocalpart(), Role.moderator, new Element("presence", new String[]{"from", "to"}, new String[]{jid.toString(), room.getRoomJID().toString()}));
            activeRooms.put(room.getRoomJID(), room);
            ghostbuster2.add(jid, room);
        }
        mucComponent.setActiveRooms(activeRooms);
        final AtomicInteger packetCounter = new AtomicInteger();
        mucComponent.handler = new PacketHandler(){

            @Override
            public void handle(Packet packet, ReceiverTimeoutHandler handler) throws PacketErrorTypeException {
                int value = packetCounter.incrementAndGet();
                if (value % 2 == 0) {
                    if (timeouts.get() && value % 3 == 0) {
                        handler.timeOutExpired(packet);
                    } else {
                        Packet response = Authorization.SERVICE_UNAVAILABLE.getResponseMessage(packet, "Service not available.", true);
                        handler.responseReceived(packet, response);
                    }
                } else if (value % 3 == 0) {
                    Packet response = Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, "Feature not implemented", true);
                    handler.responseReceived(packet, response);
                } else {
                    handler.responseReceived(packet, packet.okResult((Element)null, 0));
                }
            }
        };
        ghostbuster2.ping();
        Assert.assertEquals((long)0L, (long)packetCounter.get());
        for (Ghostbuster2.MonitoredObject monitor : ghostbuster2.monitoredObjects.values()) {
            Field f = Ghostbuster2.MonitoredObject.class.getDeclaredField("lastActivity");
            f.setAccessible(true);
            long lastActivity = f.getLong(monitor);
            f.setLong(monitor, lastActivity - 3900000L);
        }
        ghostbuster2.ping();
        Assert.assertEquals((long)1000L, (long)packetCounter.get());
        Assert.assertEquals((long)3666L, (long)ghostbuster2.monitoredObjects.size());
        packetCounter.set(0);
        ghostbuster2.ping();
        Assert.assertEquals((long)1000L, (long)packetCounter.get());
        Assert.assertEquals((long)3332L, (long)ghostbuster2.monitoredObjects.size());
        packetCounter.set(0);
        ghostbuster2.ping();
        Assert.assertEquals((long)1000L, (long)packetCounter.get());
        Assert.assertEquals((long)2998L, (long)ghostbuster2.monitoredObjects.size());
        packetCounter.set(0);
        ghostbuster2.ping();
        Assert.assertEquals((long)1000L, (long)packetCounter.get());
        Assert.assertEquals((long)2664L, (long)ghostbuster2.monitoredObjects.size());
        packetCounter.set(0);
        timeouts.set(false);
        ghostbuster2.ping();
        Assert.assertEquals((long)664L, (long)packetCounter.get());
        Assert.assertEquals((long)2332L, (long)ghostbuster2.monitoredObjects.size());
        packetCounter.set(0);
        ghostbuster2.ping();
        Assert.assertEquals((long)0L, (long)packetCounter.get());
    }

    private static interface PacketHandler {
        public void handle(Packet var1, ReceiverTimeoutHandler var2) throws PacketErrorTypeException;
    }

    private class MUCComponent
    extends tigase.muc.MUCComponent {
        private PacketHandler handler;

        private MUCComponent() {
        }

        public boolean addOutPacketWithTimeout(Packet packet, ReceiverTimeoutHandler handler, long delay, TimeUnit unit) {
            try {
                this.handler.handle(packet, handler);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            return true;
        }

        public void setActiveRooms(final Map<BareJID, Room> activeRooms) throws RepositoryException {
            this.mucRepository = new MockMucRepository(){

                @Override
                public Map<BareJID, Room> getActiveRooms() {
                    return activeRooms;
                }
            };
        }
    }
}

