/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.logging.Level;
import tigase.component.exceptions.ComponentException;
import tigase.component.exceptions.RepositoryException;
import tigase.muc.Affiliation;
import tigase.muc.MucContext;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.DefaultDiscoItemsFilter;
import tigase.muc.modules.DiscoItemsFilter;
import tigase.server.Packet;
import tigase.util.DateTimeFormatter;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class DiscoveryModule
extends tigase.component.modules.impl.DiscoveryModule<MucContext> {
    private final DateTimeFormatter dtf = new DateTimeFormatter();
    private DiscoItemsFilter filter = new DefaultDiscoItemsFilter();

    private static void addFeature(Element query, String feature) {
        query.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{feature}));
    }

    private void addField(Element form, String type, String var, String label, Object ... value) {
        if (value == null) {
            return;
        }
        Element f = new Element("field");
        if (type != null) {
            f.setAttribute("type", type);
        }
        if (var != null) {
            f.setAttribute("var", var);
        }
        if (label != null) {
            f.setAttribute("label", label);
        }
        for (Object o : value) {
            Element v = new Element("value");
            if (o instanceof Boolean) {
                v.setCData((Boolean)o != false ? "1" : "0");
            } else if (o != null) {
                v.setCData(o.toString());
            }
            f.addChild((XMLNodeIfc)v);
        }
        form.addChild((XMLNodeIfc)f);
    }

    private void addRoomInfoForm(Element resultQuery, Room room, JID senderJID) {
        RoomConfig config = room.getConfig();
        Affiliation senderAffiliation = room.getAffiliation(senderJID.getBareJID());
        boolean allowedToViewAll = !room.getOccupantsNicknames(senderJID.getBareJID()).isEmpty() ? true : senderAffiliation.isEnterMembersOnlyRoom();
        if (!config.isRoomconfigPublicroom() && !allowedToViewAll) {
            return;
        }
        if (config.isRoomMembersOnly() && !allowedToViewAll) {
            return;
        }
        Element form = new Element("x", new String[]{"xmlns", "type"}, new String[]{"jabber:x:data", "result"});
        this.addField(form, "FORM_TYPE", "hidden", null, "http://jabber.org/protocol/muc#roominfo");
        this.addField(form, "muc#roominfo_creationdate", null, "Room creation date", this.dtf.formatDateTime(room.getCreationDate()));
        this.addField(form, "muc#roominfo_occupants", null, "Number of occupants", room.getOccupantsCount());
        this.addField(form, "muc#roominfo_subject", null, "Current discussion topic", room.getSubject());
        this.addField(form, "muc#roomconfig_allowinvites", null, "Whether occupants allowed to invite others", true);
        this.addField(form, "muc#roomconfig_changesubject", null, "Whether occupants may change the subject", config.isChangeSubject());
        this.addField(form, "muc#roomconfig_enablelogging", null, "Whether logging is enabled", config.isLoggingEnabled());
        this.addField(form, "muc#roomconfig_lang", null, "Natural language room name", config.getRoomName());
        this.addField(form, "muc#roomconfig_maxusers", null, "Maximum number of room occupants", config.getMaxUsers());
        this.addField(form, "muc#roomconfig_membersonly", null, "Whether room is members-only", config.isRoomMembersOnly());
        this.addField(form, "muc#roomconfig_moderatedroom", null, "Whether room is moderated", config.isRoomModerated());
        this.addField(form, "muc#roomconfig_passwordprotectedroom", null, "Whether a password is required to enter", config.isPasswordProtectedRoom());
        this.addField(form, "muc#roomconfig_persistentroom", null, "Whether room is persistent", config.isPersistentRoom());
        this.addField(form, "muc#roomconfig_presencebroadcast", null, "Roles for which presence is broadcast", Role.moderator.name(), Role.participant.name(), Role.visitor.name());
        this.addField(form, "muc#roomconfig_publicroom", null, "Whether room is publicly searchable", config.isRoomconfigPublicroom());
        this.addField(form, "muc#roomconfig_roomadmins", null, "Full list of room admins", room.getAffiliations().stream().filter(jid -> room.getAffiliation((BareJID)jid) == Affiliation.admin).toArray());
        this.addField(form, "muc#roomconfig_roomdesc", null, "Short description of room", config.getRoomDesc());
        this.addField(form, "muc#roomconfig_roomname", null, "Natural language room name", config.getRoomName());
        this.addField(form, "muc#roomconfig_roomowners", null, "Full list of room owners", room.getAffiliations().stream().filter(jid -> room.getAffiliation((BareJID)jid) == Affiliation.owner).toArray());
        if (allowedToViewAll && config.isPasswordProtectedRoom()) {
            this.addField(form, "muc#roomconfig_roomsecret", null, "The room password", config.getPassword());
        }
        RoomConfig.Anonymity anonymity = config.getRoomAnonymity();
        switch (anonymity) {
            case nonanonymous: {
                String[] stringArray = new String[]{Affiliation.owner.name(), Affiliation.admin.name(), Affiliation.member.name(), Affiliation.none.name()};
            }
            case semianonymous: {
                String[] stringArray = new String[]{Affiliation.owner.name(), Affiliation.admin.name()};
            }
        }
        Object[] whois = null;
        this.addField(form, "muc#roomconfig_whois", null, "Affiliations that may discover real jIDs of occupants", whois);
        resultQuery.addChild((XMLNodeIfc)form);
    }

    public DiscoItemsFilter getFilter() {
        return this.filter;
    }

    public void setFilter(DiscoItemsFilter filter) {
        this.filter = filter;
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer("New discoItems filter is set: " + filter);
        }
    }

    protected void processDiscoInfo(Packet packet, JID requestedJID, String node, JID senderJID) throws ComponentException, RepositoryException {
        if (node == null && requestedJID.getLocalpart() == null && requestedJID.getResource() == null) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Requested component info");
            }
            super.processDiscoInfo(packet, requestedJID, node, senderJID);
        } else if (node == null && requestedJID.getLocalpart() != null && requestedJID.getResource() == null) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Requested room " + requestedJID.getBareJID() + " info");
            }
            Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#info"});
            Room room = ((MucContext)this.context).getMucRepository().getRoom(requestedJID.getBareJID());
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND);
            }
            String roomName = room.getConfig().getRoomName();
            Element resultIdentity = new Element("identity", new String[]{"category", "name", "type"}, new String[]{"conference", roomName == null ? "" : roomName, "text"});
            resultQuery.addChild((XMLNodeIfc)resultIdentity);
            DiscoveryModule.addFeature(resultQuery, "http://jabber.org/protocol/muc");
            switch (room.getConfig().getRoomAnonymity()) {
                case fullanonymous: {
                    DiscoveryModule.addFeature(resultQuery, "muc_fullyanonymous");
                    break;
                }
                case semianonymous: {
                    DiscoveryModule.addFeature(resultQuery, "muc_semianonymous");
                    break;
                }
                case nonanonymous: {
                    DiscoveryModule.addFeature(resultQuery, "muc_nonanonymous");
                }
            }
            if (room.getConfig().isRoomModerated()) {
                DiscoveryModule.addFeature(resultQuery, "muc_moderated");
            } else {
                DiscoveryModule.addFeature(resultQuery, "muc_unmoderated");
            }
            if (room.getConfig().isRoomMembersOnly()) {
                DiscoveryModule.addFeature(resultQuery, "muc_membersonly");
            } else {
                DiscoveryModule.addFeature(resultQuery, "muc_open");
            }
            if (room.getConfig().isPersistentRoom()) {
                DiscoveryModule.addFeature(resultQuery, "muc_persistent");
            } else {
                DiscoveryModule.addFeature(resultQuery, "muc_temporary");
            }
            if (!room.getConfig().isRoomconfigPublicroom()) {
                DiscoveryModule.addFeature(resultQuery, "muc_hidden");
            } else {
                DiscoveryModule.addFeature(resultQuery, "muc_public");
            }
            if (room.getConfig().isPasswordProtectedRoom()) {
                DiscoveryModule.addFeature(resultQuery, "muc_passwordprotected");
            } else {
                DiscoveryModule.addFeature(resultQuery, "muc_unsecured");
            }
            this.addRoomInfoForm(resultQuery, room, senderJID);
            this.write(packet.okResult(resultQuery, 0));
        } else if (node == null && requestedJID.getLocalpart() != null && requestedJID.getResource() != null) {
            this.write(packet.okResult((Element)null, 0));
        } else {
            throw new MUCException(Authorization.BAD_REQUEST);
        }
    }

    protected void processDiscoItems(Packet packet, JID requestedJID, String node, JID senderJID) throws ComponentException, RepositoryException {
        Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#items"});
        Packet result = packet.okResult(resultQuery, 0);
        if (node == null && requestedJID.getLocalpart() == null && requestedJID.getResource() == null) {
            BareJID[] roomsId;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Requested  list of rooms");
            }
            for (BareJID jid : roomsId = ((MucContext)this.context).getMucRepository().getPublicVisibleRoomsIdList()) {
                if (!jid.getDomain().equals(requestedJID.getDomain())) continue;
                String name = ((MucContext)this.context).getMucRepository().getRoomName(jid.toString());
                Room room = ((MucContext)this.context).getMucRepository().getRoom(jid);
                if (this.log.isLoggable(Level.FINEST) && this.filter != null) {
                    boolean fa = this.filter.allowed(senderJID, room);
                    this.log.finest("Using filter " + this.filter + "; result(" + senderJID + ", " + room.getRoomJID() + ")=" + fa);
                }
                if (room == null) {
                    this.log.warning("Room " + jid + " is not available!");
                    continue;
                }
                if (room.getConfig() == null) {
                    this.log.warning("Room " + jid + " hasn't configuration!");
                    continue;
                }
                if (this.filter != null && !this.filter.allowed(senderJID, room)) {
                    this.log.fine("Room " + jid + " is filtered off");
                    continue;
                }
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer("Room " + jid + " is added to response.");
                }
                resultQuery.addChild((XMLNodeIfc)new Element("item", new String[]{"jid", "name"}, new String[]{jid.toString(), name != null ? name : jid.getLocalpart()}));
            }
        } else if (node == null && requestedJID.getLocalpart() != null && requestedJID.getResource() == null) {
            Room room;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Requested items list of room " + requestedJID.getBareJID());
            }
            if ((room = ((MucContext)this.context).getMucRepository().getRoom(requestedJID.getBareJID())) == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND);
            }
            String nickname = room.getOccupantsNickname(packet.getStanzaFrom());
            if (nickname == null) {
                throw new MUCException(Authorization.FORBIDDEN);
            }
            for (String nick : room.getOccupantsNicknames()) {
                resultQuery.addChild((XMLNodeIfc)new Element("item", new String[]{"jid", "name"}, new String[]{room.getRoomJID() + "/" + nick, nick}));
            }
        } else if (node == null && requestedJID.getLocalpart() != null && requestedJID.getResource() != null) {
            this.write(packet.okResult((Element)null, 0));
        } else {
            throw new MUCException(Authorization.BAD_REQUEST);
        }
        this.write(result);
    }
}

