/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.logger;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import tigase.muc.MucContext;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.logger.MucLogger;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class RoomChatLogger
implements MucLogger {
    private static final String JOIN_HTML_FORMAT = "<a name=\"%1$s\" href=\"#%1$s\" class=\"mj\">[%1$s]</a>%2$s joins the room<br/>\n";
    private static final String JOIN_PLAIN_FORMAT = "[%1$s] %2$s joins the room\n";
    private static final String LEAVE_HTML_FORMAT = "<a name=\"%1$s\" href=\"#%1$s\" class=\"ml\">[%1$s]</a>%2$s leaves the room<br/>\n";
    private static final String LEAVE_PLAIN_FORMAT = "[%1$s] %2$s leaves the room\n";
    private static final String MESSAGE_HTML_FORMAT = "<a name=\"%1$s\" href=\"%1$s\" class=\"ts\">[%1$s]</a> <font class=\"mn\">&lt;%2$s&gt;</font>%3$s<br/>\n";
    private static final String MESSAGE_PLAIN_FORMAT = "[%1$s] <%2$s> %3$s\n";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("hh:mm:ss");
    private static final String SUBJECT_HTML_FORMAT = "<a name=\"%1$s\" href=\"#%1$s\" class=\"msc\">[%1$s]</a>%2$s has set the subject to: %3$s<br/>\n";
    private static final String SUBJECT_PLAIN_FORMAT = "[%1$s] %2$s has set the subject to: %3$s\n";
    private MucContext context;
    private final Worker worker = new Worker();

    @Override
    public void addJoinEvent(Room room, Date date, JID senderJID, String nickName) {
        String pattern;
        switch (room.getConfig().getLoggingFormat()) {
            case html: {
                pattern = JOIN_HTML_FORMAT;
                break;
            }
            case xml: {
                pattern = JOIN_PLAIN_FORMAT;
                break;
            }
            case plain: {
                pattern = JOIN_PLAIN_FORMAT;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported log format: " + (Object)((Object)room.getConfig().getLoggingFormat()));
            }
        }
        this.addLine(pattern, room.getConfig().getLoggingFormat(), room.getRoomJID(), date, nickName, null);
    }

    @Override
    public void addLeaveEvent(Room room, Date date, JID senderJID, String nickName) {
        String pattern;
        switch (room.getConfig().getLoggingFormat()) {
            case html: {
                pattern = LEAVE_HTML_FORMAT;
                break;
            }
            case xml: {
                pattern = LEAVE_PLAIN_FORMAT;
                break;
            }
            case plain: {
                pattern = LEAVE_PLAIN_FORMAT;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported log format: " + (Object)((Object)room.getConfig().getLoggingFormat()));
            }
        }
        this.addLine(pattern, room.getConfig().getLoggingFormat(), room.getRoomJID(), date, nickName, null);
    }

    private void addLine(String pattern, RoomConfig.LogFormat logFormat, BareJID roomJID, Date date, String nickName, String text) {
        String ext;
        String d = sdf.format(date);
        Object[] values = new String[]{d, nickName, text};
        String line = String.format(pattern, values);
        switch (logFormat) {
            case html: {
                ext = ".html";
                break;
            }
            case xml: {
                ext = ".xml";
                break;
            }
            case plain: {
                ext = ".txt";
                break;
            }
            default: {
                throw new RuntimeException("Unsupported log format: " + logFormat.name());
            }
        }
        Item it = new Item(new File(this.context.getChatLoggingDirectory() + "/" + roomJID + ext), line);
        this.worker.items.add(it);
    }

    @Override
    public void addMessage(Room room, String message, JID senderJid, String senderNickname, Date time) {
        String pattern;
        switch (room.getConfig().getLoggingFormat()) {
            case html: {
                pattern = MESSAGE_HTML_FORMAT;
                break;
            }
            case xml: {
                pattern = MESSAGE_PLAIN_FORMAT;
                break;
            }
            case plain: {
                pattern = MESSAGE_PLAIN_FORMAT;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported log format: " + (Object)((Object)room.getConfig().getLoggingFormat()));
            }
        }
        this.addLine(pattern, room.getConfig().getLoggingFormat(), room.getRoomJID(), time, senderNickname, message);
    }

    @Override
    public void addSubjectChange(Room room, String message, JID senderJid, String senderNickname, Date time) {
        String pattern;
        switch (room.getConfig().getLoggingFormat()) {
            case html: {
                pattern = SUBJECT_HTML_FORMAT;
                break;
            }
            case xml: {
                pattern = SUBJECT_PLAIN_FORMAT;
                break;
            }
            case plain: {
                pattern = SUBJECT_PLAIN_FORMAT;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported log format: " + (Object)((Object)room.getConfig().getLoggingFormat()));
            }
        }
        this.addLine(pattern, room.getConfig().getLoggingFormat(), room.getRoomJID(), time, senderNickname, message);
    }

    @Override
    public void init(MucContext context) {
        this.context = context;
        this.worker.start();
    }

    private static class Worker
    extends Thread {
        private final LinkedList<Item> items = new LinkedList();

        private Worker() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Item it;
                    if ((it = this.items.poll()) == null) {
                        Worker.sleep(1000L);
                        continue;
                    }
                    FileWriter fw = new FileWriter(it.file, true);
                    fw.append(it.data);
                    fw.close();
                    Worker.sleep(15L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static class Item {
        final String data;
        final File file;

        public Item(File file, String text) {
            this.file = file;
            this.data = text;
        }
    }
}

