/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.cluster;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.component.exceptions.RepositoryException;
import tigase.component.modules.Module;
import tigase.conf.ConfigurationException;
import tigase.licence.LicenceChecker;
import tigase.muc.MUCComponent;
import tigase.muc.MucContext;
import tigase.muc.cluster.InMemoryMucRepositoryClustered;
import tigase.muc.cluster.RoomClustered;
import tigase.muc.cluster.ShardingStrategy;
import tigase.muc.cluster.StrategyIfc;
import tigase.muc.repository.IMucRepository;
import tigase.muc.repository.MucDAO;
import tigase.osgi.ModulesManagerImpl;
import tigase.server.ComponentInfo;
import tigase.server.Packet;
import tigase.server.XMPPServer;
import tigase.xmpp.JID;

public class MUCComponentClustered
extends MUCComponent
implements ClusteredComponentIfc {
    private static final Logger a = Logger.getLogger(MUCComponentClustered.class.getCanonicalName());
    private static final String b = ShardingStrategy.class.getCanonicalName();
    private static final String c = "muc-strategy-class";
    private StrategyIfc d;
    protected LicenceChecker licenceChecker = LicenceChecker.getLicenceChecker((String)"acs");
    private ComponentInfo e = null;
    private ClusterControllerIfc f;

    public MUCComponentClustered() {
        RoomClustered.initialize();
    }

    public boolean addOutPacket(Packet packet) {
        return super.addOutPacket(packet);
    }

    @Override
    protected IMucRepository createMucRepository(MucContext componentConfig, MucDAO dao) throws RepositoryException {
        InMemoryMucRepositoryClustered inMemoryMucRepositoryClustered = new InMemoryMucRepositoryClustered(componentConfig, dao);
        this.d.setMucRepository(inMemoryMucRepositoryClustered);
        return inMemoryMucRepositoryClustered;
    }

    public void nodeConnected(String node) {
        JID jID = JID.jidInstanceNS((String)this.getName(), (String)node, null);
        this.d.nodeConnected(jID);
    }

    public void nodeDisconnected(String node) {
        JID jID = JID.jidInstanceNS((String)this.getName(), (String)node, null);
        this.d.nodeDisconnected(jID);
    }

    @Override
    public void processPacket(Packet packet) {
        boolean bl = this.d.processPacket(packet);
        if (!bl) {
            super.processPacket(packet);
        }
    }

    public void setClusterController(ClusterControllerIfc cl_controller) {
        this.f = cl_controller;
        if (this.d != null) {
            this.d.setClusterController(cl_controller);
        }
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> map = super.getDefaults(params);
        map.put(c, b);
        return map;
    }

    @Override
    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        if (props.size() > 1 && props.containsKey(c)) {
            String string = (String)props.get(c);
            try {
                this.d = (StrategyIfc)ModulesManagerImpl.getInstance().forName(string).newInstance();
                this.d.setMucComponentClustered(this);
                if (this.f != null) {
                    this.d.setClusterController(this.f);
                }
            }
            catch (Exception exception) {
                if (!XMPPServer.isOSGi()) {
                    a.log(Level.SEVERE, "Cannot instance clustering strategy class: " + string, exception);
                }
                throw new ConfigurationException("Cannot instance clustering strategy class: " + string);
            }
        }
        super.setProperties(props);
    }

    public void start() {
        super.start();
    }

    public void stop() {
        this.d.stop();
        super.stop();
    }

    public ComponentInfo getComponentInfo() {
        this.e = super.getComponentInfo();
        this.e.getComponentData().put("MUCClusteringStrategy", this.d != null ? this.d.getClass() : null);
        return this.e;
    }

    protected <T extends Module> T getModule(String id) {
        return (T)this.modulesManager.getModule(id);
    }
}

