/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.cluster;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.component.exceptions.RepositoryException;
import tigase.muc.Affiliation;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.cluster.AbstractClusteredRoomStrategy;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.PresenceModule;
import tigase.muc.modules.PresenceModuleImpl;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class ClusteredRoomStrategy
extends AbstractClusteredRoomStrategy {
    private static final Logger a = Logger.getLogger(ClusteredRoomStrategy.class.getCanonicalName());
    private static final String b = "muc-occupant-presence-cmd";
    private final a c = new a();

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        if (this.cl_controller != null) {
            this.cl_controller.removeCommandListener((CommandListener)this.c);
        }
        super.setClusterController(cl_controller);
        if (cl_controller != null) {
            cl_controller.setCommandListener((CommandListener)this.c);
        }
    }

    @Override
    public void onOccupantChangedPresence(Room room, JID occupantJid, String nickname, Element presence, boolean newOccupant) {
        List<JID> list = this.getAllNodes();
        list.remove(this.localNodeJid);
        if (occupantJid != null && presence == null) {
            presence = new Element("presence", new String[]{"type", "xmlns"}, new String[]{"unavailable", "jabber:client"});
        }
        if (occupantJid == null) {
            occupantJid = JID.jidInstanceNS((String)presence.getAttributeStaticStr("from"));
        }
        Affiliation affiliation = room.getAffiliation(occupantJid.getBareJID());
        Role role = room.getRole(nickname);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("room", room.getRoomJID().toString());
        hashMap.put("userId", occupantJid.toString());
        hashMap.put("nickname", nickname);
        hashMap.put("affiliation", affiliation.name());
        hashMap.put("role", role.name());
        if (newOccupant) {
            hashMap.put("new-occupant", String.valueOf(newOccupant));
        }
        if (a.isLoggable(Level.FINEST)) {
            StringBuilder stringBuilder = new StringBuilder(100);
            for (JID jID : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(jID.toString());
            }
            a.log(Level.FINEST, "room = {0}, notifing nodes [{1}] that occupant {2} in room {3} changed presence = {4}", new Object[]{room, stringBuilder, occupantJid, room, presence});
        }
    }

    private class a
    extends CommandListenerAbstract {
        public a() {
            super(ClusteredRoomStrategy.b);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            try {
                BareJID bareJID = BareJID.bareJIDInstanceNS((String)data.get("room"));
                JID jID = JID.jidInstanceNS((String)data.get("userId"));
                String string = data.get("nickname");
                Affiliation affiliation = Affiliation.valueOf(data.get("affiliation"));
                Role role = Role.valueOf(data.get("role"));
                boolean bl = data.containsKey("new-occupant");
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "executig OccupantChangedPresenceCmd command for room = {0}, occupantJID = {1},nickname: {2}, occupantAffiliation = {3}, occupantRole = {4}, newOccupant = {5} ", new Object[]{bareJID, jID, string, affiliation, role, bl});
                }
                PresenceModule presenceModule = (PresenceModule)ClusteredRoomStrategy.this.muc.getModule("presences");
                Room room = ClusteredRoomStrategy.this.muc.getMucRepository().getRoom(bareJID);
                for (Element element : packets) {
                    for (JID jID2 : room.getAllOccupantsJID()) {
                        Element element2 = element.clone();
                        PresenceModule.PresenceWrapper presenceWrapper = PresenceModule.PresenceWrapper.preparePresenceW(room, jID2, element2, jID.getBareJID(), Collections.singleton(jID), string, affiliation, role);
                        if (!"unavailable".equals(element2.getAttributeStaticStr("type"))) {
                            PresenceModuleImpl.addCodes(presenceWrapper, false, string);
                        }
                        ClusteredRoomStrategy.this.muc.addOutPacket(presenceWrapper.getPacket());
                    }
                }
                if (bl) {
                    presenceModule.sendPresencesToNewOccupant(room, jID);
                }
            }
            catch (RepositoryException repositoryException) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, repositoryException);
            }
            catch (MUCException mUCException) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, (Throwable)((Object)mUCException));
            }
            catch (TigaseStringprepException tigaseStringprepException) {
                Logger.getLogger(AbstractClusteredRoomStrategy.class.getName()).log(Level.SEVERE, null, tigaseStringprepException);
            }
        }
    }
}

