/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.Collection;
import tigase.component.ElementWriter;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.MucConfig;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractModule;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class PrivateMessageModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"message", (String)"chat");

    public PrivateMessageModule(MucConfig config, ElementWriter writer, IMucRepository mucRepository) {
        super(config, writer, mucRepository);
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public void process(Packet element) throws MUCException {
        try {
            JID senderJID = JID.jidInstance((String)element.getAttributeStaticStr("from"));
            BareJID roomJID = BareJID.bareJIDInstance((String)element.getAttributeStaticStr("to"));
            String recipientNickname = PrivateMessageModule.getNicknameFromJid(JID.jidInstance((String)element.getAttributeStaticStr("to")));
            if (recipientNickname == null) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            Room room = this.repository.getRoom(roomJID);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND);
            }
            String senderNickname = room.getOccupantsNickname(senderJID);
            Role senderRole = room.getRole(senderNickname);
            if (!senderRole.isSendPrivateMessages()) {
                throw new MUCException(Authorization.NOT_ALLOWED);
            }
            Collection<JID> recipientJids = room.getOccupantsJidsByNickname(recipientNickname);
            if (recipientJids.isEmpty()) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND, "Unknown recipient");
            }
            for (JID jid : recipientJids) {
                Element message = element.getElement().clone();
                message.setAttribute("from", JID.jidInstance((BareJID)roomJID, (String)senderNickname).toString());
                message.setAttribute("to", jid.toString());
                Packet p = Packet.packetInstance((Element)message);
                p.setXMLNS("jabber:client");
                this.writer.write(p);
            }
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (TigaseStringprepException e) {
            throw new MUCException(Authorization.BAD_REQUEST);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

