/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.UserRepository;
import tigase.form.Field;
import tigase.form.Form;
import tigase.muc.MucConfig;
import tigase.xmpp.BareJID;

public class RoomConfig {
    private static final String LOGGING_FORMAT_KEY = "logging_format";
    public static final String MUC_ROOMCONFIG_ANONYMITY_KEY = "muc#roomconfig_anonymity";
    public static final String MUC_ROOMCONFIG_CHANGESUBJECT_KEY = "muc#roomconfig_changesubject";
    public static final String MUC_ROOMCONFIG_ENABLELOGGING_KEY = "muc#roomconfig_enablelogging";
    public static final String MUC_ROOMCONFIG_MAXHISTORY_KEY = "muc#maxhistoryfetch";
    public static final String MUC_ROOMCONFIG_MEMBERSONLY_KEY = "muc#roomconfig_membersonly";
    public static final String MUC_ROOMCONFIG_MODERATEDROOM_KEY = "muc#roomconfig_moderatedroom";
    public static final String MUC_ROOMCONFIG_PASSWORDPROTECTEDROOM_KEY = "muc#roomconfig_passwordprotectedroom";
    public static final String MUC_ROOMCONFIG_PERSISTENTROOM_KEY = "muc#roomconfig_persistentroom";
    public static final String MUC_ROOMCONFIG_PUBLICROOM_KEY = "muc#roomconfig_publicroom";
    public static final String MUC_ROOMCONFIG_ROOMDESC_KEY = "muc#roomconfig_roomdesc";
    public static final String MUC_ROOMCONFIG_ROOMNAME_KEY = "muc#roomconfig_roomname";
    public static final String MUC_ROOMCONFIG_ROOMSECRET_KEY = "muc#roomconfig_roomsecret";
    protected final Set<String> blacklist = new HashSet<String>();
    protected final Form form = new Form("form", null, null);
    private final ArrayList<RoomConfigListener> listeners = new ArrayList();
    private final boolean publicLoggingAvailable;
    private final BareJID roomJID;

    protected static String[] asStringTable(Enum<?>[] values) {
        String[] result = new String[values.length];
        int i = 0;
        for (Enum<?> v : values) {
            result[i++] = v.name();
        }
        return result;
    }

    public RoomConfig(BareJID roomJID, boolean publicLoggingAvailable) {
        this.roomJID = roomJID;
        this.publicLoggingAvailable = publicLoggingAvailable;
        this.init();
    }

    public void addListener(RoomConfigListener listener) {
        this.listeners.add(listener);
    }

    private boolean asBoolean(Boolean value, boolean defaultValue) {
        return value == null ? defaultValue : value;
    }

    private String asString(String value, String defaultValue) {
        return value == null ? defaultValue : value;
    }

    public RoomConfig clone() {
        RoomConfig rc = new RoomConfig(this.getRoomJID(), this.publicLoggingAvailable);
        rc.blacklist.addAll(this.blacklist);
        rc.form.copyValuesFrom(this.form);
        return rc;
    }

    public String[] compareTo(RoomConfig oldConfig) {
        HashSet<String> result = new HashSet<String>();
        Set<String> vars = this.equals(oldConfig.form);
        for (String var : vars) {
            if (MUC_ROOMCONFIG_ANONYMITY_KEY.equals(var)) {
                switch (this.getRoomAnonymity()) {
                    case nonanonymous: {
                        result.add("172");
                        break;
                    }
                    case semianonymous: {
                        result.add("173");
                        break;
                    }
                    case fullanonymous: {
                        result.add("174");
                    }
                }
                continue;
            }
            if (MUC_ROOMCONFIG_ENABLELOGGING_KEY.equals(var)) {
                result.add(this.isLoggingEnabled() ? "170" : "171");
                continue;
            }
            result.add("104");
        }
        return result.size() == 0 ? null : result.toArray(new String[0]);
    }

    public void copyFrom(Form configForm) {
        this.copyFrom(configForm, true);
    }

    public void copyFrom(Form configForm, boolean fireEvents) {
        Set<String> modifiedVars = fireEvents ? this.equals(configForm) : null;
        this.form.copyValuesFrom(configForm);
        if (modifiedVars != null && modifiedVars.size() > 0) {
            this.fireConfigChanged(modifiedVars);
        }
    }

    public void copyFrom(RoomConfig c) {
        this.copyFrom(c.form, true);
    }

    public void copyFrom(RoomConfig c, boolean fireEvents) {
        this.copyFrom(c.form, fireEvents);
    }

    private Set<String> equals(Form form) {
        HashSet<String> result = new HashSet<String>();
        for (Field field : form.getAllFields()) {
            Field of = this.form.get(field.getVar());
            if (of == null) {
                result.add(field.getVar());
                continue;
            }
            boolean tmp = Arrays.equals(field.getValues(), of.getValues());
            if (tmp) continue;
            result.add(field.getVar());
        }
        return result;
    }

    private void fireConfigChanged(Set<String> modifiedVars) {
        for (RoomConfigListener listener : this.listeners) {
            listener.onConfigChanged(this, modifiedVars);
        }
    }

    public Form getConfigForm() {
        return this.form;
    }

    public LogFormat getLoggingFormat() {
        try {
            String tmp = this.form.getAsString(LOGGING_FORMAT_KEY);
            return tmp == null ? LogFormat.html : LogFormat.valueOf(tmp);
        }
        catch (Exception e) {
            return LogFormat.html;
        }
    }

    public Integer getMaxHistory() {
        try {
            return this.form.getAsInteger(MUC_ROOMCONFIG_MAXHISTORY_KEY);
        }
        catch (Exception e) {
            return 50;
        }
    }

    public String getPassword() {
        return this.asString(this.form.getAsString(MUC_ROOMCONFIG_ROOMSECRET_KEY), "");
    }

    public Anonymity getRoomAnonymity() {
        try {
            String tmp = this.form.getAsString(MUC_ROOMCONFIG_ANONYMITY_KEY);
            return tmp == null ? Anonymity.semianonymous : Anonymity.valueOf(tmp);
        }
        catch (Exception e) {
            return Anonymity.semianonymous;
        }
    }

    public String getRoomDesc() {
        return this.form.getAsString(MUC_ROOMCONFIG_ROOMDESC_KEY);
    }

    public BareJID getRoomJID() {
        return this.roomJID;
    }

    public String getRoomName() {
        return this.form.getAsString(MUC_ROOMCONFIG_ROOMNAME_KEY);
    }

    protected void init() {
        this.form.addField(Field.fieldTextSingle((String)MUC_ROOMCONFIG_ROOMNAME_KEY, (String)"", (String)"Natural-Language Room Name"));
        this.form.addField(Field.fieldTextSingle((String)MUC_ROOMCONFIG_ROOMDESC_KEY, (String)"", (String)"Short Description of Room"));
        this.form.addField(Field.fieldBoolean((String)MUC_ROOMCONFIG_PERSISTENTROOM_KEY, (Boolean)Boolean.FALSE, (String)"Make Room Persistent?"));
        this.form.addField(Field.fieldBoolean((String)MUC_ROOMCONFIG_PUBLICROOM_KEY, (Boolean)Boolean.TRUE, (String)"Make Room Publicly Searchable?"));
        this.form.addField(Field.fieldBoolean((String)MUC_ROOMCONFIG_MODERATEDROOM_KEY, (Boolean)Boolean.FALSE, (String)"Make Room Moderated?"));
        this.form.addField(Field.fieldBoolean((String)MUC_ROOMCONFIG_MEMBERSONLY_KEY, (Boolean)Boolean.FALSE, (String)"Make Room Members Only?"));
        this.form.addField(Field.fieldBoolean((String)MUC_ROOMCONFIG_PASSWORDPROTECTEDROOM_KEY, (Boolean)Boolean.FALSE, (String)"Password Required to Enter?"));
        this.form.addField(Field.fieldTextSingle((String)MUC_ROOMCONFIG_ROOMSECRET_KEY, (String)"", (String)"Password"));
        this.form.addField(Field.fieldListSingle((String)MUC_ROOMCONFIG_ANONYMITY_KEY, (String)Anonymity.semianonymous.name(), (String)"Room anonymity level:", (String[])new String[]{"Non-Anonymous Room", "Semi-Anonymous Room", "Fully-Anonymous Room"}, (String[])new String[]{Anonymity.nonanonymous.name(), Anonymity.semianonymous.name(), Anonymity.fullanonymous.name()}));
        this.form.addField(Field.fieldBoolean((String)MUC_ROOMCONFIG_CHANGESUBJECT_KEY, (Boolean)Boolean.FALSE, (String)"Allow Occupants to Change Subject?"));
        if (this.publicLoggingAvailable) {
            this.form.addField(Field.fieldBoolean((String)MUC_ROOMCONFIG_ENABLELOGGING_KEY, (Boolean)Boolean.FALSE, (String)"Enable Public Logging?"));
            this.form.addField(Field.fieldListSingle((String)LOGGING_FORMAT_KEY, (String)LogFormat.html.name(), (String)"Logging format:", (String[])new String[]{"HTML", "Plain text"}, (String[])new String[]{LogFormat.html.name(), LogFormat.plain.name()}));
        }
        this.form.addField(Field.fieldTextSingle((String)MUC_ROOMCONFIG_MAXHISTORY_KEY, (String)"50", (String)"Maximum Number of History Messages Returned by Room"));
    }

    public boolean isChangeSubject() {
        return this.asBoolean(this.form.getAsBoolean(MUC_ROOMCONFIG_CHANGESUBJECT_KEY), false);
    }

    public boolean isLoggingEnabled() {
        return this.asBoolean(this.form.getAsBoolean(MUC_ROOMCONFIG_ENABLELOGGING_KEY), false);
    }

    public boolean isPasswordProtectedRoom() {
        return this.asBoolean(this.form.getAsBoolean(MUC_ROOMCONFIG_PASSWORDPROTECTEDROOM_KEY), false);
    }

    public boolean isPersistentRoom() {
        return this.asBoolean(this.form.getAsBoolean(MUC_ROOMCONFIG_PERSISTENTROOM_KEY), false);
    }

    public boolean isRoomconfigPublicroom() {
        return this.asBoolean(this.form.getAsBoolean(MUC_ROOMCONFIG_PUBLICROOM_KEY), true);
    }

    public boolean isRoomMembersOnly() {
        return this.asBoolean(this.form.getAsBoolean(MUC_ROOMCONFIG_MEMBERSONLY_KEY), false);
    }

    public boolean isRoomModerated() {
        return this.asBoolean(this.form.getAsBoolean(MUC_ROOMCONFIG_MODERATEDROOM_KEY), false);
    }

    public void notifyConfigUpdate() {
        HashSet<String> vars = new HashSet<String>();
        for (Field f : this.form.getAllFields()) {
            vars.add(f.getVar());
        }
        this.fireConfigChanged(vars);
    }

    public void read(UserRepository repository, MucConfig config, String subnode) throws UserNotFoundException, TigaseDBException {
        String[] keys = repository.getKeys(config.getServiceName(), subnode);
        if (keys != null) {
            for (String key : keys) {
                String[] values = repository.getDataList(config.getServiceName(), subnode, key);
                this.setValues(key, values);
            }
        }
    }

    public void removeListener(RoomConfigListener listener) {
        this.listeners.remove(listener);
    }

    private void setValue(String var, Object data) {
        Field f = this.form.get(var);
        if (f == null) {
            return;
        }
        if (data == null) {
            f.setValues(new String[0]);
        } else if (data instanceof String) {
            String str = (String)data;
            if (!(f.getType() != Field.FieldType.bool || "0".equals(str) || "1".equals(str) || "true".equalsIgnoreCase(str) || "false".equalsIgnoreCase(str))) {
                throw new RuntimeException("Boolean fields allows only '1', 'true', '0', 'false' values");
            }
            f.setValues(new String[]{str});
        } else if (data instanceof Boolean && f.getType() == Field.FieldType.bool) {
            boolean b = (Boolean)data;
            f.setValues(new String[]{b ? "1" : "0"});
        } else if (data instanceof String[] && (f.getType() == Field.FieldType.list_multi || f.getType() == Field.FieldType.text_multi)) {
            String[] d = (String[])data;
            f.setValues(d);
        } else {
            throw new RuntimeException("Cannot match type " + data.getClass().getCanonicalName() + " to field type " + f.getType().name());
        }
    }

    private void setValues(String var, String[] data) {
        if (data == null || data.length > 1) {
            this.setValue(var, data);
        } else if (data.length == 0) {
            this.setValue(var, null);
        } else {
            this.setValue(var, data[0]);
        }
    }

    public void write(UserRepository repo, MucConfig config, String subnode) throws UserNotFoundException, TigaseDBException {
        List fields = this.form.getAllFields();
        for (Field field : fields) {
            if (field.getVar() == null || this.blacklist.contains(field.getVar())) continue;
            String[] values = field.getValues();
            String value = field.getValue();
            if (values == null || values.length == 0) {
                repo.removeData(config.getServiceName(), subnode, field.getVar());
                continue;
            }
            if (values.length == 1) {
                repo.setData(config.getServiceName(), subnode, field.getVar(), value);
                continue;
            }
            repo.setDataList(config.getServiceName(), subnode, field.getVar(), values);
        }
    }

    public static interface RoomConfigListener {
        public void onConfigChanged(RoomConfig var1, Set<String> var2);
    }

    public static enum LogFormat {
        html,
        plain,
        xml;

    }

    public static enum Anonymity {
        fullanonymous,
        nonanonymous,
        semianonymous;

    }
}

