/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.component.AbstractComponent;
import tigase.component.ElementWriter;
import tigase.conf.Configurable;
import tigase.db.RepositoryFactory;
import tigase.db.UserRepository;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.form.Field;
import tigase.muc.Ghostbuster2;
import tigase.muc.MucConfig;
import tigase.muc.MucVersion;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.history.HistoryManagerFactory;
import tigase.muc.history.HistoryProvider;
import tigase.muc.history.MemoryHistoryProvider;
import tigase.muc.logger.MucLogger;
import tigase.muc.modules.DiscoInfoModule;
import tigase.muc.modules.DiscoItemsModule;
import tigase.muc.modules.GroupchatMessageModule;
import tigase.muc.modules.MediatedInvitationModule;
import tigase.muc.modules.ModeratorModule;
import tigase.muc.modules.PresenceModule;
import tigase.muc.modules.PrivateMessageModule;
import tigase.muc.modules.RoomConfigurationModule;
import tigase.muc.modules.SoftwareVersionModule;
import tigase.muc.modules.UniqueRoomNameModule;
import tigase.muc.modules.XmppPingModule;
import tigase.muc.repository.IMucRepository;
import tigase.muc.repository.MucDAO;
import tigase.muc.repository.inmemory.InMemoryMucRepository;
import tigase.server.DisableDisco;
import tigase.server.Packet;
import tigase.server.ReceiverTimeoutHandler;
import tigase.util.DNSResolver;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.JID;

public class MUCComponent
extends AbstractComponent<MucConfig>
implements PresenceModule.DelayDeliveryThread.DelDeliverySend,
XMPPService,
Configurable,
DisableDisco {
    public static final String ADMINS_KEY = "admins";
    public static final String DEFAULT_ROOM_CONFIG_PREFIX_KEY = "default_room_config/";
    public static final String LOG_DIR_KEY = "room-log-directory";
    public static final String MESSAGE_FILTER_ENABLED_KEY = "message-filter-enabled";
    public static final String MUC_ALLOW_CHAT_STATES_KEY = "muc-allow-chat-states";
    public static final String MUC_LOCK_NEW_ROOM_KEY = "muc-lock-new-room";
    public static final String MUC_MULTI_ITEM_ALLOWED_KEY = "muc-multi-item-allowed";
    protected static final String MUC_REPO_CLASS_PROP_KEY = "muc-repo-class";
    protected static final String MUC_REPO_URL_PROP_KEY = "muc-repo-url";
    private static final String MUC_REPOSITORY_VAR = "mucRepository";
    private static final String OWNER_MODULE_VAR = "ownerModule";
    @Deprecated
    public static final String PING_EVERY_MINUTE_KEY = "ping-every-minute";
    public static final String PRESENCE_FILTER_ENABLED_KEY = "presence-filter-enabled";
    private static final String PRESENCE_MODULE_VAR = "presenceModule";
    public static final String SEARCH_GHOSTS_EVERY_MINUTE_KEY = "search-ghosts-every-minute";
    private MucDAO dao;
    private final Ghostbuster2 ghostbuster;
    private HistoryProvider historyProvider;
    public String[] HOSTNAMES_PROP_VAL = new String[]{"localhost", "hostname"};
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private GroupchatMessageModule messageModule;
    private ModeratorModule moderatorModule;
    private IMucRepository mucRepository;
    private RoomConfigurationModule ownerModule;
    private PresenceModule presenceModule;
    private MucLogger roomLogger;
    private boolean searchGhostsEveryMinute = false;
    private ServiceEntity serviceEntity;
    private UserRepository userRepository;

    public MUCComponent() {
        this.ghostbuster = new Ghostbuster2(this);
    }

    public MUCComponent(ElementWriter writer) {
        super(writer);
        this.ghostbuster = new Ghostbuster2(this);
    }

    boolean addOutPacket(Packet packet, ReceiverTimeoutHandler handler, long delay, TimeUnit unit) {
        return super.addOutPacketWithTimeout(packet, handler, delay, unit);
    }

    @Override
    protected MucConfig createComponentConfigInstance(AbstractComponent<?> abstractComponent) {
        return new MucConfig(abstractComponent);
    }

    public synchronized void everyHour() {
        super.everyHour();
        if (!this.searchGhostsEveryMinute) {
            this.executePingInThread();
        }
    }

    public synchronized void everyMinute() {
        super.everyMinute();
        if (this.searchGhostsEveryMinute) {
            this.executePingInThread();
        }
    }

    private void executePingInThread() {
        if (this.ghostbuster != null) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        MUCComponent.this.ghostbuster.ping();
                    }
                    catch (Exception e) {
                        MUCComponent.this.log.log(Level.SEVERE, "Can't ping known JIDs", e);
                    }
                }
            }.start();
        }
    }

    public MucConfig getConfig() {
        return (MucConfig)this.componentConfig;
    }

    @Override
    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map<String, Object> props = super.getDefaults(params);
        this.HOSTNAMES_PROP_VAL = params.get("--virt-hosts") != null ? ((String)params.get("--virt-hosts")).split(",") : DNSResolver.getDefHostNames();
        props.put(MESSAGE_FILTER_ENABLED_KEY, Boolean.TRUE);
        props.put(PRESENCE_FILTER_ENABLED_KEY, Boolean.FALSE);
        props.put(SEARCH_GHOSTS_EVERY_MINUTE_KEY, Boolean.FALSE);
        String[] hostnames = new String[this.HOSTNAMES_PROP_VAL.length];
        int i = 0;
        for (String host : this.HOSTNAMES_PROP_VAL) {
            hostnames[i++] = this.getName() + "." + host;
        }
        props.put("hostnames", hostnames);
        String repo_class = params.get("--user-db") != null ? (String)params.get("--user-db") : "tigase.db.jdbc.JDBCRepository";
        String repo_uri = params.get("--user-db-uri") != null ? (String)params.get("--user-db-uri") : "jdbc:derby:tigase-derbydb;create=true";
        props.put(MUC_REPO_CLASS_PROP_KEY, repo_class);
        props.put(MUC_REPO_URL_PROP_KEY, repo_uri);
        props.put("history-db", repo_class);
        props.put("history-db-uri", repo_uri);
        String[] admins = params.get("--admins") != null ? ((String)params.get("--admins")).split(",") : new String[]{"admin@" + this.getDefHostName()};
        props.put(ADMINS_KEY, admins);
        props.put(LOG_DIR_KEY, new String("./logs/"));
        props.put(MUC_ALLOW_CHAT_STATES_KEY, Boolean.FALSE);
        props.put(MUC_LOCK_NEW_ROOM_KEY, Boolean.TRUE);
        props.put(MUC_MULTI_ITEM_ALLOWED_KEY, Boolean.TRUE);
        return props;
    }

    public List<Element> getDiscoFeatures() {
        return null;
    }

    public Element getDiscoInfo(String node, JID jid) {
        return null;
    }

    public List<Element> getDiscoItems(String node, JID jid) {
        if (node == null) {
            Element result = this.serviceEntity.getDiscoItem(null, this.getName() + "." + jid.toString());
            return Arrays.asList(result);
        }
        return null;
    }

    public Set<String> getFeaturesFromModule() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.modulesManager.getFeatures());
        return result;
    }

    public IMucRepository getMucRepository() {
        return this.mucRepository;
    }

    protected void init() {
        ElementWriter writer = this.getWriter();
        this.presenceModule = new PresenceModule((MucConfig)this.componentConfig, writer, this.mucRepository, this.historyProvider, this, this.roomLogger, this.ghostbuster);
        this.ghostbuster.setPresenceModule(this.presenceModule);
        this.modulesManager.register(new PrivateMessageModule((MucConfig)this.componentConfig, writer, this.mucRepository));
        this.messageModule = this.modulesManager.register(new GroupchatMessageModule((MucConfig)this.componentConfig, writer, this.mucRepository, this.historyProvider, this.roomLogger));
        this.modulesManager.register(this.presenceModule);
        this.ownerModule = this.modulesManager.register(new RoomConfigurationModule((MucConfig)this.componentConfig, writer, this.mucRepository, this.historyProvider, this.messageModule));
        this.moderatorModule = this.modulesManager.register(new ModeratorModule((MucConfig)this.componentConfig, writer, this.mucRepository, this.ghostbuster));
        this.modulesManager.register(new SoftwareVersionModule(writer));
        this.modulesManager.register(new XmppPingModule(writer));
        this.modulesManager.register(new DiscoItemsModule((MucConfig)this.componentConfig, writer, this.mucRepository, this.scriptCommands, this));
        this.modulesManager.register(new DiscoInfoModule((MucConfig)this.componentConfig, writer, this.mucRepository, this));
        this.modulesManager.register(new MediatedInvitationModule((MucConfig)this.componentConfig, writer, this.mucRepository));
        this.modulesManager.register(new UniqueRoomNameModule((MucConfig)this.componentConfig, writer, this.mucRepository));
    }

    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put(PRESENCE_MODULE_VAR, (Object)this.presenceModule);
        binds.put(OWNER_MODULE_VAR, (Object)this.ownerModule);
        binds.put(MUC_REPOSITORY_VAR, (Object)this.mucRepository);
    }

    public boolean isSubdomain() {
        return true;
    }

    public int processingInThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    public int processingOutThreads() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    protected void processStanzaPacket(Packet packet) {
        try {
            this.ghostbuster.update(packet);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "There is no Dana, there is only Zuul", e);
        }
        super.processStanzaPacket(packet);
    }

    @Override
    public void sendDelayedPacket(Packet packet) {
        this.addOutPacket(packet);
    }

    public void setMucRepository(IMucRepository mucRepository) {
        this.mucRepository = mucRepository;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        if (props.size() == 1) {
            return;
        }
        this.searchGhostsEveryMinute = props.containsKey(PING_EVERY_MINUTE_KEY) ? ((Boolean)props.get(PING_EVERY_MINUTE_KEY)).booleanValue() : ((Boolean)props.get(SEARCH_GHOSTS_EVERY_MINUTE_KEY)).booleanValue();
        this.serviceEntity = new ServiceEntity(this.getName(), null, "Multi User Chat");
        this.serviceEntity.addIdentities(new ServiceIdentity[]{new ServiceIdentity("conference", "text", "Multi User Chat")});
        this.serviceEntity.addFeatures(new String[]{"http://jabber.org/protocol/muc"});
        try {
            this.historyProvider = HistoryManagerFactory.getHistoryManager(props);
            this.historyProvider.init(props);
        }
        catch (Exception e) {
            this.historyProvider = new MemoryHistoryProvider();
            throw new RuntimeException(e);
        }
        if (props.containsKey("muc-logger-class")) {
            String loggerClassName = (String)props.get("muc-logger-class");
            try {
                if (this.log.isLoggable(Level.CONFIG)) {
                    this.log.config("Using Room Logger: " + loggerClassName);
                }
                this.roomLogger = (MucLogger)Class.forName(loggerClassName).newInstance();
                this.roomLogger.init(props);
            }
            catch (Exception e) {
                System.err.println("");
                System.err.println("  --------------------------------------");
                System.err.println("  ERROR! Terminating the server process.");
                System.err.println("  Problem initializing the MUC Component: " + e);
                System.err.println("  Please fix the problem and start the server again.");
                e.printStackTrace();
                System.exit(1);
            }
        }
        ((MucConfig)this.componentConfig).setProperties(props);
        ((MucConfig)this.componentConfig).setPublicLoggingEnabled(this.roomLogger != null || this.historyProvider.isPersistent());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Public Logging Allowed: " + ((MucConfig)this.componentConfig).isPublicLoggingEnabled());
        }
        if (this.userRepository == null) {
            this.userRepository = (UserRepository)props.get("shared-user-repo");
            try {
                if (this.userRepository == null) {
                    String cls_name = (String)props.get(MUC_REPO_CLASS_PROP_KEY);
                    String res_uri = (String)props.get(MUC_REPO_URL_PROP_KEY);
                    this.userRepository = RepositoryFactory.getUserRepository((String)cls_name, (String)res_uri, null);
                    this.userRepository.initRepository(res_uri, null);
                }
                this.dao = new MucDAO((MucConfig)this.componentConfig, this.userRepository);
                this.mucRepository = new InMemoryMucRepository((MucConfig)this.componentConfig, this.dao);
            }
            catch (Exception e) {
                if (this.log.isLoggable(Level.SEVERE)) {
                    this.log.severe("Can't initialize MUC repository: " + e);
                }
                e.printStackTrace();
            }
            this.init();
            try {
                RoomConfig defaultRoomConfig = this.mucRepository.getDefaultRoomConfig();
                boolean changed = false;
                for (Map.Entry<String, Object> x : props.entrySet()) {
                    if (!x.getKey().startsWith(DEFAULT_ROOM_CONFIG_PREFIX_KEY)) continue;
                    String var = x.getKey().substring(DEFAULT_ROOM_CONFIG_PREFIX_KEY.length());
                    Field field = defaultRoomConfig.getConfigForm().get(var);
                    if (field != null) {
                        changed = true;
                        field.setValues(new String[]{(String)x.getValue()});
                        continue;
                    }
                    if (!this.log.isLoggable(Level.WARNING)) continue;
                    this.log.warning("Default config room doesn't contains variable '" + var + "'!");
                }
                if (changed) {
                    if (this.log.isLoggable(Level.CONFIG)) {
                        this.log.config("Default room configuration is udpated");
                    }
                    this.mucRepository.updateDefaultRoomConfig(defaultRoomConfig);
                }
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "Can't set default room ronfiguration", e);
            }
        }
        this.messageModule.setChatStateAllowed((Boolean)props.get(MUC_ALLOW_CHAT_STATES_KEY));
        this.presenceModule.setLockNewRoom((Boolean)props.get(MUC_LOCK_NEW_ROOM_KEY));
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Tigase MUC Component ver. " + MucVersion.getVersion() + " started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            for (Room room : this.mucRepository.getActiveRooms().values()) {
                for (String nickname : room.getOccupantsNicknames()) {
                    try {
                        this.moderatorModule.kickWithoutBroadcast(room, nickname, "MUC component is going down.", null);
                    }
                    catch (TigaseStringprepException e) {
                        this.log.log(Level.WARNING, "Can't throw out occupant from room", e);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Problem on throwing out occupants", e);
        }
        finally {
            super.stop();
        }
    }
}

