/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.List;
import tigase.component.ElementWriter;
import tigase.component.exceptions.RepositoryException;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.criteria.Or;
import tigase.muc.Affiliation;
import tigase.muc.MucConfig;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractModule;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class MediatedInvitationModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"message").add(ElementCriteria.name((String)"x", (String)"http://jabber.org/protocol/muc#user").add((Criteria)new Or(new Criteria[]{ElementCriteria.name((String)"invite"), ElementCriteria.name((String)"decline")})));

    public MediatedInvitationModule(MucConfig config, ElementWriter writer, IMucRepository mucRepository) {
        super(config, writer, mucRepository);
    }

    private void doDecline(Element decline, BareJID roomJID, JID senderJID) throws TigaseStringprepException {
        Element reason = decline.getChild("reason");
        JID recipient = JID.jidInstance((String)decline.getAttributeStaticStr("to"));
        Packet resultMessage = Packet.packetInstance((Element)new Element("message", new String[]{"from", "to"}, new String[]{roomJID.toString(), recipient.toString()}));
        resultMessage.setXMLNS("jabber:client");
        Element resultX = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
        resultMessage.getElement().addChild((XMLNodeIfc)resultX);
        Element resultDecline = new Element("decline", new String[]{"from"}, new String[]{senderJID.toString()});
        resultX.addChild((XMLNodeIfc)resultDecline);
        if (reason != null) {
            resultDecline.addChild((XMLNodeIfc)reason.clone());
        }
        this.writer.write(resultMessage);
    }

    private void doInvite(Element invite, Room room, BareJID roomJID, JID senderJID, Affiliation senderAffiliation) throws RepositoryException, TigaseStringprepException {
        Element reason = invite.getChild("reason");
        Element cont = invite.getChild("continue");
        JID recipient = JID.jidInstance((String)invite.getAttributeStaticStr("to"));
        Packet resultMessage = Packet.packetInstance((Element)new Element("message", new String[]{"from", "to"}, new String[]{roomJID.toString(), recipient.toString()}));
        resultMessage.setXMLNS("jabber:client");
        Element resultX = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
        resultMessage.getElement().addChild((XMLNodeIfc)resultX);
        if (room.getConfig().isRoomMembersOnly() && senderAffiliation.isEditMemberList()) {
            room.addAffiliationByJid(recipient.getBareJID(), Affiliation.member);
        }
        Element resultInvite = new Element("invite", new String[]{"from"}, new String[]{senderJID.toString()});
        resultX.addChild((XMLNodeIfc)resultInvite);
        if (room.getConfig().isPasswordProtectedRoom()) {
            resultX.addChild((XMLNodeIfc)new Element("password", room.getConfig().getPassword()));
        }
        if (reason != null) {
            resultInvite.addChild((XMLNodeIfc)reason.clone());
        }
        if (cont != null) {
            resultInvite.addChild((XMLNodeIfc)cont.clone());
        }
        this.writer.write(resultMessage);
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public void process(Packet element) throws MUCException {
        try {
            JID senderJID = JID.jidInstance((String)element.getAttributeStaticStr("from"));
            BareJID roomJID = BareJID.bareJIDInstance((String)element.getAttributeStaticStr("to"));
            if (MediatedInvitationModule.getNicknameFromJid(JID.jidInstance((String)element.getAttributeStaticStr("to"))) != null) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            Room room = this.repository.getRoom(roomJID);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND);
            }
            String nickName = room.getOccupantsNickname(senderJID);
            Role senderRole = room.getRole(nickName);
            if (!senderRole.isInviteOtherUsers()) {
                throw new MUCException(Authorization.NOT_ALLOWED);
            }
            Affiliation senderAffiliation = room.getAffiliation(senderJID.getBareJID());
            if (room.getConfig().isRoomMembersOnly() && !senderAffiliation.isEditMemberList()) {
                throw new MUCException(Authorization.FORBIDDEN);
            }
            Element x = element.getElement().getChild("x", "http://jabber.org/protocol/muc#user");
            List ch = x.getChildren();
            for (Element child : ch) {
                if ("invite".equals(child.getName())) {
                    this.doInvite(child, room, roomJID, senderJID, senderAffiliation);
                    continue;
                }
                if (!"decline".equals(child.getName())) continue;
                this.doDecline(child, roomJID, senderJID);
            }
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

