/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.ElementWriter;
import tigase.muc.Module;
import tigase.muc.MucVersion;
import tigase.muc.exceptions.MUCException;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.JID;

public class SoftwareVersionModule
implements Module {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"query", (String)"jabber:iq:version"));
    protected final ElementWriter writer;

    public SoftwareVersionModule(ElementWriter writer) {
        this.writer = writer;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"jabber:iq:version"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public boolean isProcessedByModule(Element element) {
        try {
            JID jid = JID.jidInstance((String)element.getAttribute("to"));
            return jid != null && jid.getResource() == null;
        }
        catch (TigaseStringprepException e) {
            return false;
        }
    }

    @Override
    public void process(Packet iq) throws MUCException {
        Element query = new Element("query", new String[]{"xmlns"}, new String[]{"jabber:iq:version"});
        query.addChild((XMLNodeIfc)new Element("name", "Tigase Multi-User Chat Component"));
        query.addChild((XMLNodeIfc)new Element("version", MucVersion.getVersion()));
        query.addChild((XMLNodeIfc)new Element("os", System.getProperty("os.name") + "-" + System.getProperty("os.arch") + "-" + System.getProperty("os.version") + ", " + System.getProperty("java.vm.name") + "-" + System.getProperty("java.version") + " " + System.getProperty("java.vm.vendor")));
        this.writer.write(iq.okResult(query, 0));
    }
}

