/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.logging.Level;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.form.Form;
import tigase.muc.Affiliation;
import tigase.muc.ElementWriter;
import tigase.muc.MucConfig;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.exceptions.MUCException;
import tigase.muc.history.HistoryProvider;
import tigase.muc.modules.AbstractModule;
import tigase.muc.modules.GroupchatMessageModule;
import tigase.muc.modules.PresenceModule;
import tigase.muc.repository.IMucRepository;
import tigase.muc.repository.RepositoryException;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class RoomConfigurationModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"query", (String)"http://jabber.org/protocol/muc#owner"));
    private final HistoryProvider historyProvider;
    private final GroupchatMessageModule messageModule;

    public RoomConfigurationModule(MucConfig config, ElementWriter writer, IMucRepository mucRepository, HistoryProvider historyProvider, GroupchatMessageModule messageModule) {
        super(config, writer, mucRepository);
        this.messageModule = messageModule;
        this.historyProvider = historyProvider;
    }

    private void destroy(Room room, Element destroyElement) throws TigaseStringprepException, RepositoryException {
        for (String occupantNickname : room.getOccupantsNicknames()) {
            for (JID occupantJid : room.getOccupantsJidsByNickname(occupantNickname)) {
                Element p = new Element("presence");
                p.addAttribute("type", "unavailable");
                PresenceModule.PresenceWrapper presence = PresenceModule.preparePresenceW(room, occupantJid, p, occupantJid.getBareJID(), occupantNickname, Affiliation.none, Role.none);
                presence.x.addChild((XMLNodeIfc)destroyElement);
                this.writer.write(presence.packet);
            }
        }
        this.repository.destroyRoom(room);
        if (this.historyProvider != null) {
            this.historyProvider.removeHistory(room);
        }
    }

    public void destroy(Room room, String jid, String reason) throws TigaseStringprepException, RepositoryException {
        Element destroy = new Element("destroy");
        if (jid != null) {
            destroy.addAttribute("jid", jid);
        }
        if (reason != null) {
            destroy.addChild((XMLNodeIfc)new Element("reason", reason));
        }
        this.destroy(room, destroy);
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    private Element makeConfigFormIq(Element request, RoomConfig roomConfig) {
        Element response = RoomConfigurationModule.createResultIQ(request);
        Element query = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#owner"});
        response.addChild((XMLNodeIfc)query);
        query.addChild((XMLNodeIfc)roomConfig.getConfigForm().getElement());
        return response;
    }

    @Override
    public void process(Packet element) throws MUCException {
        block6: {
            try {
                StanzaType type = element.getType();
                if (RoomConfigurationModule.getNicknameFromJid(element.getTo()) != null) {
                    throw new MUCException(Authorization.BAD_REQUEST);
                }
                if (type == StanzaType.set) {
                    this.processSet(element);
                    break block6;
                }
                if (type == StanzaType.get) {
                    this.processGet(element);
                    break block6;
                }
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            catch (MUCException e1) {
                throw e1;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    private void processGet(Packet element) throws RepositoryException, MUCException {
        try {
            BareJID roomJID = BareJID.bareJIDInstance((String)element.getAttribute("to"));
            JID senderJID = JID.jidInstance((String)element.getAttribute("from"));
            Room room = this.repository.getRoom(roomJID);
            if (room == null) {
                this.writer.write(Packet.packetInstance((Element)this.makeConfigFormIq(element.getElement(), this.repository.getDefaultRoomConfig())));
            }
            if (room.getAffiliation(senderJID.getBareJID()) != Affiliation.owner) {
                throw new MUCException(Authorization.FORBIDDEN);
            }
            Element response = this.makeConfigFormIq(element.getElement(), room.getConfig());
            this.writer.write(Packet.packetInstance((Element)response));
        }
        catch (TigaseStringprepException e) {
            throw new MUCException(Authorization.BAD_REQUEST);
        }
    }

    private void processSet(Packet element) throws RepositoryException, MUCException {
        block13: {
            try {
                JID roomJID = JID.jidInstance((String)element.getAttribute("to"));
                JID senderJID = JID.jidInstance((String)element.getAttribute("from"));
                Element query = element.getElement().getChild("query", "http://jabber.org/protocol/muc#owner");
                Room room = this.repository.getRoom(roomJID.getBareJID());
                if (room == null) {
                    room = this.repository.createNewRoom(roomJID.getBareJID(), senderJID);
                }
                Affiliation affiliation = room.getAffiliation(senderJID.getBareJID());
                if (room.getAffiliation(senderJID.getBareJID()) != Affiliation.owner) {
                    throw new MUCException(Authorization.FORBIDDEN);
                }
                Element x = query.getChild("x", "jabber:x:data");
                Element destroy = query.getChild("destroy");
                if (destroy != null) {
                    if (!affiliation.isDestroyRoom()) {
                        throw new MUCException(Authorization.FORBIDDEN);
                    }
                    this.destroy(room, destroy);
                    this.writer.write(element.okResult((Element)null, 0));
                    break block13;
                }
                if (x != null) {
                    Form form = new Form(x);
                    if ("submit".equals(form.getType())) {
                        String ps = form.getAsString("muc#roomconfig_roomsecret");
                        if (form.getAsBoolean("muc#roomconfig_passwordprotectedroom") == Boolean.TRUE && (ps == null || ps.length() == 0)) {
                            throw new MUCException(Authorization.NOT_ACCEPTABLE, "Passwords cannot be empty");
                        }
                        this.writer.write(element.okResult((Element)null, 0));
                        RoomConfig oldConfig = room.getConfig().clone();
                        if (room.isRoomLocked()) {
                            room.setRoomLocked(false);
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine("Room " + room.getRoomJID() + " is now unlocked");
                            }
                            this.sendMucMessage(room, room.getOccupantsNickname(senderJID), "Room is now unlocked");
                        }
                        room.getConfig().copyFrom(form);
                        room.addAffiliationByJid(senderJID.getBareJID(), Affiliation.owner);
                        String[] compareResult = room.getConfig().compareTo(oldConfig);
                        if (compareResult != null) {
                            Element z = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
                            for (String code : compareResult) {
                                z.addChild((XMLNodeIfc)new Element("status", new String[]{"code"}, new String[]{code}));
                            }
                            this.messageModule.sendMessagesToAllOccupants(room, roomJID, z);
                        }
                    }
                    break block13;
                }
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            catch (TigaseStringprepException e) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
        }
    }
}

