/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.Affiliation;
import tigase.muc.DateUtil;
import tigase.muc.ElementWriter;
import tigase.muc.MucConfig;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.exceptions.MUCException;
import tigase.muc.history.HistoryProvider;
import tigase.muc.logger.MucLogger;
import tigase.muc.modules.AbstractModule;
import tigase.muc.repository.IMucRepository;
import tigase.muc.repository.RepositoryException;
import tigase.server.Packet;
import tigase.server.Priority;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class PresenceModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"presence");
    protected static final Logger log = Logger.getLogger(PresenceModule.class.getName());
    private final Set<Criteria> allowedElements = new HashSet<Criteria>();
    private boolean filterEnabled = true;
    private final HistoryProvider historyProvider;
    private boolean lockNewRoom = true;
    private final MucLogger mucLogger;

    private static Role getDefaultRole(RoomConfig config, Affiliation affiliation) {
        Role newRole;
        if (config.isRoomModerated() && affiliation == Affiliation.none) {
            newRole = Role.visitor;
        } else {
            switch (affiliation) {
                case admin: {
                    newRole = Role.moderator;
                    break;
                }
                case member: {
                    newRole = Role.participant;
                    break;
                }
                case none: {
                    newRole = Role.participant;
                    break;
                }
                case outcast: {
                    newRole = Role.none;
                    break;
                }
                case owner: {
                    newRole = Role.moderator;
                    break;
                }
                default: {
                    newRole = Role.none;
                }
            }
        }
        return newRole;
    }

    static PresenceWrapper preparePresenceW(Room room, JID destinationJID, Element presence, BareJID occupantJID, String occupantNickname, Affiliation occupantAffiliation, Role occupantRole) throws TigaseStringprepException {
        RoomConfig.Anonymity anonymity = room.getConfig().getRoomAnonymity();
        Affiliation destinationAffiliation = room.getAffiliation(destinationJID.getBareJID());
        try {
            presence.setAttribute("from", JID.jidInstance((BareJID)room.getRoomJID(), (String)occupantNickname).toString());
        }
        catch (TigaseStringprepException e) {
            presence.setAttribute("from", room.getRoomJID() + "/" + occupantNickname);
        }
        presence.setAttribute("to", destinationJID.toString());
        Element x = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
        Element item = new Element("item", new String[]{"affiliation", "role", "nick"}, new String[]{occupantAffiliation.name(), occupantRole.name(), occupantNickname});
        x.addChild((XMLNodeIfc)item);
        presence.addChild((XMLNodeIfc)x);
        Packet packet = Packet.packetInstance((Element)presence);
        PresenceWrapper wrapper = new PresenceWrapper(packet, x, item);
        if (occupantJID.equals((Object)destinationJID.getBareJID())) {
            wrapper.packet.setPriority(Priority.HIGH);
            wrapper.addStatusCode(110);
            if (anonymity == RoomConfig.Anonymity.nonanonymous) {
                wrapper.addStatusCode(100);
            }
            if (room.getConfig().isLoggingEnabled()) {
                wrapper.addStatusCode(170);
            }
        }
        if (anonymity == RoomConfig.Anonymity.nonanonymous || anonymity == RoomConfig.Anonymity.semianonymous && destinationAffiliation.isViewOccupantsJid()) {
            item.setAttribute("jid", occupantJID.toString());
        }
        return wrapper;
    }

    static PresenceWrapper preparePresenceW(Room room, JID destinationJID, Element presence, JID occupantJID) throws TigaseStringprepException {
        String occupantNickname = room.getOccupantsNickname(occupantJID);
        return PresenceModule.preparePresenceW(room, destinationJID, presence, occupantNickname);
    }

    static PresenceWrapper preparePresenceW(Room room, JID destinationJID, Element presence, String occupantNickname) throws TigaseStringprepException {
        BareJID occupantJID = room.getOccupantsJidByNickname(occupantNickname);
        Affiliation occupantAffiliation = room.getAffiliation(occupantJID);
        Role occupantRole = room.getRole(occupantNickname);
        return PresenceModule.preparePresenceW(room, destinationJID, presence, occupantJID, occupantNickname, occupantAffiliation, occupantRole);
    }

    private static Integer toInteger(String v, Integer defaultValue) {
        if (v == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public PresenceModule(MucConfig config, ElementWriter writer, IMucRepository mucRepository, HistoryProvider historyProvider, DelayDeliveryThread.DelDeliverySend sender, MucLogger mucLogger) {
        super(config, writer, mucRepository);
        this.historyProvider = historyProvider;
        this.mucLogger = mucLogger;
        this.filterEnabled = config.isPresenceFilterEnabled();
        this.allowedElements.add((Criteria)ElementCriteria.name((String)"show"));
        this.allowedElements.add((Criteria)ElementCriteria.name((String)"status"));
        this.allowedElements.add((Criteria)ElementCriteria.name((String)"priority"));
        this.allowedElements.add((Criteria)ElementCriteria.xmlns((String)"http://jabber.org/protocol/caps"));
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Filtering presence children is " + (this.filterEnabled ? "enabled" : "disabled"));
        }
    }

    private void addJoinToHistory(Room room, Date date, JID senderJID, String nickName) {
        if (this.historyProvider != null) {
            this.historyProvider.addJoinEvent(room, date, senderJID, nickName);
        }
        if (this.mucLogger != null && room.getConfig().isLoggingEnabled()) {
            this.mucLogger.addJoinEvent(room, date, senderJID, nickName);
        }
    }

    private void addLeaveToHistory(Room room, Date date, JID senderJID, String nickName) {
        if (this.historyProvider != null) {
            this.historyProvider.addLeaveEvent(room, date, senderJID, nickName);
        }
        if (this.mucLogger != null && room.getConfig().isLoggingEnabled()) {
            this.mucLogger.addLeaveEvent(room, date, senderJID, nickName);
        }
    }

    protected Element clonePresence(Element element) {
        Element toRemove;
        List cc;
        Element presence = new Element(element);
        if (this.filterEnabled && (cc = element.getChildren()) != null) {
            ArrayList<Element> children = new ArrayList<Element>();
            block0: for (Element c : cc) {
                for (Criteria crit : this.allowedElements) {
                    if (!crit.match(c)) continue;
                    children.add(c);
                    continue block0;
                }
            }
            presence.setChildren(children);
        }
        if ((toRemove = presence.getChild("x", "http://jabber.org/protocol/muc")) != null) {
            presence.removeChild(toRemove);
        }
        return presence;
    }

    public void doQuit(Room room, JID senderJID) throws TigaseStringprepException {
        String leavingNickname = room.getOccupantsNickname(senderJID);
        Affiliation leavingAffiliation = room.getAffiliation(leavingNickname);
        Role leavingRole = room.getRole(leavingNickname);
        Element presenceElement = new Element("presence");
        presenceElement.setAttribute("type", "unavailable");
        PresenceWrapper selfPresence = PresenceModule.preparePresenceW(room, senderJID, presenceElement, senderJID);
        boolean nicknameGone = room.removeOccupant(senderJID);
        room.updatePresenceByJid(senderJID, null);
        this.writer.write(selfPresence.packet);
        if (nicknameGone) {
            for (String occupantNickname : room.getOccupantsNicknames()) {
                for (JID occupantJid : room.getOccupantsJidsByNickname(occupantNickname)) {
                    presenceElement = new Element("presence");
                    presenceElement.setAttribute("type", "unavailable");
                    PresenceWrapper presence = PresenceModule.preparePresenceW(room, occupantJid, presenceElement, senderJID.getBareJID(), leavingNickname, leavingAffiliation, leavingRole);
                    this.writer.write(presence.packet);
                }
            }
            if (room.getConfig().isLoggingEnabled()) {
                this.addLeaveToHistory(room, new Date(), senderJID, leavingNickname);
            }
        }
        if (room.getOccupantsCount() == 0) {
            if (this.historyProvider != null && !room.getConfig().isPersistentRoom()) {
                this.historyProvider.removeHistory(room);
            }
            this.repository.leaveRoom(room);
        }
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public boolean isLockNewRoom() {
        return this.lockNewRoom;
    }

    private PresenceWrapper preparePresence(JID destinationJID, Element presence, Room room, JID occupantJID, boolean newRoomCreated, String newNickName) throws TigaseStringprepException {
        PresenceWrapper wrapper = PresenceModule.preparePresenceW(room, destinationJID, presence, occupantJID);
        if (newRoomCreated) {
            wrapper.addStatusCode(201);
        }
        if (newNickName != null) {
            wrapper.addStatusCode(303);
            wrapper.item.setAttribute("nick", newNickName);
        }
        return wrapper;
    }

    @Override
    public void process(Packet element) throws MUCException, TigaseStringprepException {
        JID senderJID = JID.jidInstance((String)element.getAttribute("from"));
        BareJID roomJID = BareJID.bareJIDInstance((String)element.getAttribute("to"));
        String nickName = PresenceModule.getNicknameFromJid(JID.jidInstance((String)element.getAttribute("to")));
        String presenceType = element.getAttribute("type");
        if (presenceType != null && "error".equals(presenceType)) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Ignoring presence with type='" + presenceType + "' from " + senderJID);
            }
            return;
        }
        if (nickName == null) {
            throw new MUCException(Authorization.JID_MALFORMED);
        }
        try {
            boolean probablyReEnter;
            String knownNickname;
            boolean roomCreated;
            Room room = this.repository.getRoom(roomJID);
            if (presenceType != null && "unavailable".equals(presenceType)) {
                this.processExit(room, element.getElement(), senderJID);
                return;
            }
            if (room == null) {
                if (log.isLoggable(Level.INFO)) {
                    log.info("Creating new room '" + roomJID + "' by user " + nickName + "' <" + senderJID.toString() + ">");
                }
                room = this.repository.createNewRoom(roomJID, senderJID);
                room.addAffiliationByJid(senderJID.getBareJID(), Affiliation.owner);
                room.setRoomLocked(this.lockNewRoom);
                roomCreated = true;
                knownNickname = null;
            } else {
                roomCreated = false;
                knownNickname = room.getOccupantsNickname(senderJID);
            }
            boolean bl = probablyReEnter = element.getElement().getChild("x", "http://jabber.org/protocol/muc") != null;
            if (knownNickname != null && !knownNickname.equals(nickName)) {
                this.processChangeNickname(room, element.getElement(), senderJID, knownNickname, nickName);
            } else if (probablyReEnter || knownNickname == null) {
                this.processEntering(room, roomCreated, element.getElement(), senderJID, nickName);
            } else if (knownNickname.equals(nickName)) {
                this.processChangeAvailabilityStatus(room, element.getElement(), senderJID, knownNickname);
            }
        }
        catch (MUCException e) {
            throw e;
        }
        catch (TigaseStringprepException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    protected void processChangeAvailabilityStatus(Room room, Element presenceElement, JID senderJID, String nickname) throws TigaseStringprepException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing stanza " + presenceElement.toString());
        }
        room.updatePresenceByJid(null, this.clonePresence(presenceElement));
        Element pe = room.getLastPresenceCopyByJid(senderJID.getBareJID());
        this.sendPresenceToAllOccupants(pe, room, senderJID, false, null);
    }

    protected void processChangeNickname(Room room, Element element, JID senderJID, String senderNickname, String newNickName) throws TigaseStringprepException, MUCException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing stanza " + element.toString());
        }
        throw new MUCException(Authorization.FEATURE_NOT_IMPLEMENTED, "Will me done soon");
    }

    protected void processEntering(Room room, boolean roomCreated, Element element, JID senderJID, String nickname) throws MUCException, TigaseStringprepException {
        Element hist;
        Element password;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing stanza " + element.toString());
        }
        Affiliation affiliation = room.getAffiliation(senderJID.getBareJID());
        Element xElement = element.getChild("x", "http://jabber.org/protocol/muc");
        Element element2 = password = xElement == null ? null : xElement.getChild("password");
        if (room.getConfig().isPasswordProtectedRoom()) {
            String psw = password == null ? null : password.getCData();
            String roomPassword = room.getConfig().getPassword();
            if (psw == null || !psw.equals(roomPassword)) {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Password '" + psw + "' is not match to room password '" + roomPassword + "' ");
                }
                throw new MUCException(Authorization.NOT_AUTHORIZED);
            }
        }
        if (room.isRoomLocked() && affiliation != Affiliation.owner) {
            throw new MUCException(Authorization.ITEM_NOT_FOUND);
        }
        if (!affiliation.isEnterOpenRoom()) {
            if (log.isLoggable(Level.INFO)) {
                log.info("User " + nickname + "' <" + senderJID.toString() + "> is on rooms '" + room.getRoomJID() + "' blacklist");
            }
            throw new MUCException(Authorization.FORBIDDEN);
        }
        if (room.getConfig().isRoomMembersOnly() && !affiliation.isEnterMembersOnlyRoom()) {
            if (log.isLoggable(Level.INFO)) {
                log.info("User " + nickname + "' <" + senderJID.toString() + "> is NOT on rooms '" + room.getRoomJID() + "' member list.");
            }
            throw new MUCException(Authorization.REGISTRATION_REQUIRED);
        }
        BareJID currentOccupantJid = room.getOccupantsJidByNickname(nickname);
        if (currentOccupantJid != null && !currentOccupantJid.equals((Object)senderJID.getBareJID())) {
            throw new MUCException(Authorization.CONFLICT);
        }
        for (String occupantNickname : room.getOccupantsNicknames()) {
            BareJID occupantJid = room.getOccupantsJidByNickname(occupantNickname);
            Element op = room.getLastPresenceCopyByJid(occupantJid);
            PresenceWrapper l = PresenceModule.preparePresenceW(room, senderJID, op, occupantNickname);
            this.writer.write(l.packet);
        }
        Role newRole = PresenceModule.getDefaultRole(room.getConfig(), affiliation);
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Occupant '" + nickname + "' <" + senderJID.toString() + "> is entering room " + room.getRoomJID() + " as role=" + newRole.name() + ", affiliation=" + affiliation.name());
        }
        room.addOccupantByJid(senderJID, nickname, newRole);
        Element pe = this.clonePresence(element);
        room.updatePresenceByJid(null, pe);
        if (currentOccupantJid == null) {
            this.sendPresenceToAllOccupants(room, senderJID, roomCreated, null);
        }
        Integer maxchars = null;
        Integer maxstanzas = null;
        Integer seconds = null;
        Date since = null;
        Element element3 = hist = xElement == null ? null : xElement.getChild("history");
        if (hist != null) {
            maxchars = PresenceModule.toInteger(hist.getAttribute("maxchars"), null);
            maxstanzas = PresenceModule.toInteger(hist.getAttribute("maxstanzas"), null);
            seconds = PresenceModule.toInteger(hist.getAttribute("seconds"), null);
            since = DateUtil.parse(hist.getAttribute("since"));
        }
        this.sendHistoryToUser(room, senderJID, maxchars, maxstanzas, seconds, since, this.writer);
        if (room.getSubject() != null && room.getSubjectChangerNick() != null && room.getSubjectChangeDate() != null) {
            Element message = new Element("message", new String[]{"type", "from", "to"}, new String[]{"groupchat", room.getRoomJID() + "/" + room.getSubjectChangerNick(), senderJID.toString()});
            message.addChild((XMLNodeIfc)new Element("subject", room.getSubject()));
            String stamp = DateUtil.formatDatetime(room.getSubjectChangeDate());
            Element delay = new Element("delay", new String[]{"xmlns", "stamp"}, new String[]{"urn:xmpp:delay", stamp});
            delay.setAttribute("jid", room.getRoomJID() + "/" + room.getSubjectChangerNick());
            Element x = new Element("x", new String[]{"xmlns", "stamp"}, new String[]{"jabber:x:delay", DateUtil.formatOld(room.getSubjectChangeDate())});
            message.addChild((XMLNodeIfc)delay);
            message.addChild((XMLNodeIfc)x);
            this.writer.writeElement(message);
        }
        if (room.isRoomLocked()) {
            this.sendMucMessage(room, room.getOccupantsNickname(senderJID), "Room is locked. Please configure.");
        }
        if (roomCreated) {
            StringBuilder sb = new StringBuilder();
            sb.append("Welcome! You created new Multi User Chat Room.");
            if (room.isRoomLocked()) {
                sb.append(" Room is locked now. Configure it please!");
            } else {
                sb.append(" Room is unlocked and ready for occupants!");
            }
            this.sendMucMessage(room, room.getOccupantsNickname(senderJID), sb.toString());
        }
        if (room.getConfig().isLoggingEnabled()) {
            this.addJoinToHistory(room, new Date(), senderJID, nickname);
        }
    }

    protected void processExit(Room room, Element presenceElement, JID senderJID) throws MUCException, TigaseStringprepException {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Processing stanza " + presenceElement.toString());
        }
        if (room == null) {
            throw new MUCException(Authorization.ITEM_NOT_FOUND, "Unkown room");
        }
        String leavingNickname = room.getOccupantsNickname(senderJID);
        if (leavingNickname == null) {
            throw new MUCException(Authorization.ITEM_NOT_FOUND, "Unkown occupant");
        }
        this.doQuit(room, senderJID);
    }

    private void sendHistoryToUser(Room room, JID senderJID, Integer maxchars, Integer maxstanzas, Integer seconds, Date since, ElementWriter writer) {
        if (this.historyProvider != null) {
            this.historyProvider.getHistoryMessages(room, senderJID, maxchars, maxstanzas, seconds, since, writer);
        }
    }

    private void sendPresenceToAllOccupants(Element $presence, Room room, JID senderJID, boolean newRoomCreated, String newNickName) throws TigaseStringprepException {
        for (String occupantNickname : room.getOccupantsNicknames()) {
            for (JID occupantJid : room.getOccupantsJidsByNickname(occupantNickname)) {
                PresenceWrapper presence = this.preparePresence(occupantJid, $presence.clone(), room, senderJID, newRoomCreated, newNickName);
                this.writer.write(presence.packet);
            }
        }
    }

    private void sendPresenceToAllOccupants(Room room, JID senderJID, boolean newRoomCreated, String newNickName) throws TigaseStringprepException {
        Element presence;
        if (newNickName != null) {
            presence = new Element("presence");
            presence.setAttribute("type", "unavailable");
        } else if (room.getOccupantsNickname(senderJID) == null) {
            presence = new Element("presence");
            presence.setAttribute("type", "unavailable");
        } else {
            presence = room.getLastPresenceCopyByJid(senderJID.getBareJID());
        }
        this.sendPresenceToAllOccupants(presence, room, senderJID, newRoomCreated, newNickName);
    }

    public void setLockNewRoom(boolean lockNewRoom) {
        this.lockNewRoom = lockNewRoom;
    }

    public static class PresenceWrapper {
        final Element item;
        final Packet packet;
        final Element x;

        PresenceWrapper(Packet packet, Element x, Element item) {
            this.packet = packet;
            this.x = x;
            this.item = item;
        }

        void addStatusCode(int code) {
            this.x.addChild((XMLNodeIfc)new Element("status", new String[]{"code"}, new String[]{"" + code}));
        }
    }

    public static class DelayDeliveryThread
    extends Thread {
        private final LinkedList<Element[]> items = new LinkedList();
        private final DelDeliverySend sender;

        public DelayDeliveryThread(DelDeliverySend component) {
            this.sender = component;
        }

        public void put(Collection<Element> elements) {
            if (elements != null && elements.size() > 0) {
                this.items.push(elements.toArray(new Element[0]));
            }
        }

        public void put(Element element) {
            this.items.add(new Element[]{element});
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                block4: while (true) {
                    DelayDeliveryThread.sleep(553L);
                    if (this.items.size() <= 0 || (toSend = this.items.poll()) == null) continue;
                    arr$ = toSend;
                    len$ = arr$.length;
                    i$ = 0;
                    while (true) {
                        block6: {
                            if (i$ < len$) ** break;
                            continue block4;
                            element = arr$[i$];
                            try {
                                this.sender.sendDelayedPacket(Packet.packetInstance((Element)element));
                            }
                            catch (TigaseStringprepException ex) {
                                if (!PresenceModule.log.isLoggable(Level.INFO)) break block6;
                                PresenceModule.log.info("Packet addressing problem, stringprep failed: " + element);
                            }
                        }
                        ++i$;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return;
            }
        }

        public static interface DelDeliverySend {
            public void sendDelayedPacket(Packet var1);
        }
    }
}

