/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.Affiliation;
import tigase.muc.ElementWriter;
import tigase.muc.MucConfig;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractModule;
import tigase.muc.repository.IMucRepository;
import tigase.muc.repository.RepositoryException;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class ModeratorModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"query", (String)"http://jabber.org/protocol/muc#admin"));

    private static Affiliation getAffiliation(Element item) throws MUCException {
        String tmp = item.getAttribute("affiliation");
        try {
            return tmp == null ? null : Affiliation.valueOf(tmp);
        }
        catch (IllegalArgumentException e) {
            throw new MUCException(Authorization.BAD_REQUEST, "Unknown affiliation value: " + tmp);
        }
    }

    private static String getReason(Element item) {
        Element r = item.getChild("reason");
        return r == null ? null : r.getCData();
    }

    private static Role getRole(Element item) {
        String tmp = item.getAttribute("role");
        return tmp == null ? null : Role.valueOf(tmp);
    }

    public ModeratorModule(MucConfig config, ElementWriter writer, IMucRepository mucRepository) {
        super(config, writer, mucRepository);
    }

    private void checkItem(Room room, Element item, Affiliation senderaAffiliation, Role senderRole) throws MUCException, TigaseStringprepException {
        Role newRole = ModeratorModule.getRole(item);
        Affiliation newAffiliation = ModeratorModule.getAffiliation(item);
        HashSet<String> occupantNicknames = new HashSet<String>();
        if (item.getAttribute("nick") != null) {
            occupantNicknames.add(item.getAttribute("nick"));
        }
        if (item.getAttribute("jid") != null) {
            occupantNicknames.addAll(room.getOccupantsNicknames(BareJID.bareJIDInstance((String)item.getAttribute("jid"))));
        }
        for (String occupantNickname : occupantNicknames) {
            Affiliation occupantAffiliation = room.getAffiliation(occupantNickname);
            if (newRole != null && newAffiliation == null) {
                if (newRole == Role.none && !senderRole.isKickParticipantsAndVisitors()) {
                    throw new MUCException(Authorization.NOT_ALLOWED, "You cannot kick");
                }
                if (newRole == Role.none && occupantAffiliation.getWeight() > senderaAffiliation.getWeight()) {
                    throw new MUCException(Authorization.NOT_ALLOWED, "You cannot kick occupant with higher affiliation");
                }
                if (newRole == Role.participant && !senderRole.isGrantVoice()) {
                    throw new MUCException(Authorization.NOT_ALLOWED, "You cannot grant voice");
                }
                if (newRole == Role.visitor && !senderRole.isRevokeVoice()) {
                    throw new MUCException(Authorization.NOT_ALLOWED, "You cannot revoke voice");
                }
                if (newRole == Role.visitor && occupantAffiliation.getWeight() >= senderaAffiliation.getWeight()) {
                    throw new MUCException(Authorization.NOT_ALLOWED, "You revoke voice occupant with higher affiliation");
                }
                if (newRole != Role.moderator || senderaAffiliation.isEditModeratorList()) continue;
                throw new MUCException(Authorization.NOT_ALLOWED, "You cannot grant moderator provileges");
            }
            if (newRole == null && newAffiliation != null) {
                if (item.getAttribute("jid") == null) {
                    throw new MUCException(Authorization.BAD_REQUEST);
                }
                if (newAffiliation == Affiliation.outcast && !senderaAffiliation.isBanMembersAndUnaffiliatedUsers()) {
                    throw new MUCException(Authorization.NOT_ALLOWED, "You cannot ban");
                }
                if (newAffiliation == Affiliation.outcast && occupantAffiliation.getWeight() >= senderaAffiliation.getWeight()) {
                    throw new MUCException(Authorization.NOT_ALLOWED, "You ban occupant with higher affiliation");
                }
                if (newAffiliation == Affiliation.member && !senderaAffiliation.isEditMemberList()) {
                    throw new MUCException(Authorization.NOT_ALLOWED, "You cannot grant membership");
                }
                if (newAffiliation == Affiliation.admin && !senderaAffiliation.isEditAdminList()) {
                    throw new MUCException(Authorization.NOT_ALLOWED, "You cannot grant admin provileges");
                }
                if (newAffiliation == Affiliation.owner && !senderaAffiliation.isEditOwnerList()) {
                    throw new MUCException(Authorization.NOT_ALLOWED, "You cannot grant owner provileges");
                }
                if (newAffiliation != Affiliation.none || occupantAffiliation.getWeight() <= senderaAffiliation.getWeight()) continue;
                throw new MUCException(Authorization.NOT_ALLOWED, "You cannot remove affiliation occupant with higher affiliation");
            }
            throw new MUCException(Authorization.BAD_REQUEST);
        }
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    private Element makePresence(JID destinationJid, BareJID roomJID, Room room, BareJID occupantJid, boolean unavailable, Affiliation affiliation, Role role, String nick, String reason, String actor, String ... codes) {
        Element presence = unavailable ? new Element("presence", new String[]{"type"}, new String[]{"unavailable"}) : room.getLastPresenceCopyByJid(occupantJid);
        try {
            presence.setAttribute("from", JID.jidInstance((BareJID)roomJID, (String)nick).toString());
        }
        catch (TigaseStringprepException e) {
            presence.setAttribute("from", roomJID.toString() + "/" + nick);
        }
        presence.setAttribute("to", destinationJid.toString());
        Element x = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
        presence.addChild((XMLNodeIfc)x);
        Element item = new Element("item");
        x.addChild((XMLNodeIfc)item);
        if (role != null) {
            item.setAttribute("role", role.name());
        }
        if (affiliation != null) {
            item.setAttribute("affiliation", affiliation.name());
        }
        if (nick != null) {
            item.setAttribute("nick", nick);
        }
        if (actor != null) {
            x.addChild((XMLNodeIfc)new Element("actor", new String[]{"jid"}, new String[]{actor}));
        }
        if (reason != null) {
            x.addChild((XMLNodeIfc)new Element("reason", reason));
        }
        if (codes != null) {
            for (String code : codes) {
                if (code == null) continue;
                x.addChild((XMLNodeIfc)new Element("status", new String[]{"code"}, new String[]{code}));
            }
        }
        return presence;
    }

    @Override
    public void process(Packet element) throws MUCException {
        block6: {
            try {
                StanzaType type = element.getType();
                if (ModeratorModule.getNicknameFromJid(element.getTo()) != null) {
                    throw new MUCException(Authorization.BAD_REQUEST);
                }
                if (type == StanzaType.set) {
                    this.processSet(element);
                    break block6;
                }
                if (type == StanzaType.get) {
                    this.processGet(element);
                    break block6;
                }
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            catch (MUCException e1) {
                throw e1;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    private void processGet(Packet element) throws RepositoryException, MUCException {
        block7: {
            try {
                BareJID roomJID = BareJID.bareJIDInstance((String)element.getAttribute("to"));
                Room room = this.repository.getRoom(roomJID);
                if (room == null) {
                    throw new MUCException(Authorization.ITEM_NOT_FOUND);
                }
                Element query = element.getElement().getChild("query");
                Element item = query.getChild("item");
                JID senderJID = JID.jidInstance((String)element.getAttribute("from"));
                Affiliation senderAffiliation = room.getAffiliation(senderJID.getBareJID());
                if (senderAffiliation != Affiliation.admin && senderAffiliation != Affiliation.owner) {
                    throw new MUCException(Authorization.FORBIDDEN);
                }
                Role filterRole = ModeratorModule.getRole(item);
                Affiliation filterAffiliation = ModeratorModule.getAffiliation(item);
                if (filterAffiliation != null && filterRole == null) {
                    this.processGetAffiliations(element, room, filterAffiliation);
                    break block7;
                }
                if (filterAffiliation == null && filterRole != null) {
                    this.processGetRoles(element, room, filterRole);
                    break block7;
                }
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            catch (MUCException e1) {
                throw e1;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }

    private void processGetAffiliations(Packet iq, Room room, Affiliation filter) throws RepositoryException, MUCException {
        Element responseQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#admin"});
        for (BareJID jid : room.getAffiliations()) {
            Affiliation affiliation = room.getAffiliation(jid);
            if (affiliation != filter) continue;
            Element ir = new Element("item", new String[]{"affiliation", "jid"}, new String[]{affiliation.name(), jid.toString()});
            responseQuery.addChild((XMLNodeIfc)ir);
        }
        this.writer.write(iq.okResult(responseQuery, 0));
    }

    private void processGetRoles(Packet iq, Room room, Role filterRole) throws RepositoryException, MUCException {
        Element responseQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#admin"});
        for (String occupantNickname : room.getOccupantsNicknames()) {
            Role role = room.getRole(occupantNickname);
            BareJID occupantBareJid = room.getOccupantsJidByNickname(occupantNickname);
            if (role != filterRole) continue;
            Affiliation affiliation = room.getAffiliation(occupantBareJid);
            Element ir = new Element("item", new String[]{"affiliation", "nick", "role"}, new String[]{affiliation.name(), occupantNickname, role.name()});
            if (room.getConfig().getRoomAnonymity() != RoomConfig.Anonymity.fullanonymous) {
                ir.setAttribute("jid", occupantBareJid.toString());
            }
            responseQuery.addChild((XMLNodeIfc)ir);
        }
        this.writer.write(iq.okResult(responseQuery, 0));
    }

    private void processSet(Packet element) throws RepositoryException, MUCException {
        try {
            BareJID roomJID = BareJID.bareJIDInstance((String)element.getAttribute("to"));
            Room room = this.repository.getRoom(roomJID);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND);
            }
            JID senderJid = JID.jidInstance((String)element.getAttribute("from"));
            String nickName = room.getOccupantsNickname(senderJid);
            Affiliation senderAffiliation = room.getAffiliation(senderJid.getBareJID());
            Role senderRole = room.getRole(nickName);
            Element query = element.getElement().getChild("query");
            List items = query.getChildren();
            for (Element item : items) {
                this.checkItem(room, item, senderAffiliation, senderRole);
            }
            this.writer.write(element.okResult((Element)null, 0));
            for (Element item : items) {
                Role newRole = ModeratorModule.getRole(item);
                Affiliation newAffiliation = ModeratorModule.getAffiliation(item);
                String reason = ModeratorModule.getReason(item);
                String actor = senderJid.toString();
                if (newAffiliation != null) {
                    this.processSetAffiliation(room, item, newAffiliation, newRole, reason, actor);
                }
                if (newRole == null) continue;
                this.processSetRole(room, item, newRole, reason, actor);
            }
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void processSetAffiliation(Room room, Element item, Affiliation newAffiliation, Role newRole, String reason, String actor) throws RepositoryException, TigaseStringprepException {
        Collection<JID> occupantJids;
        BareJID occupantBareJid = JID.jidInstance((String)item.getAttribute("jid")).getBareJID();
        Affiliation previousAffiliation = room.getAffiliation(occupantBareJid);
        if (room.getConfig().isRoomMembersOnly() && previousAffiliation.getWeight() <= Affiliation.none.getWeight() && newAffiliation.getWeight() >= Affiliation.member.getWeight()) {
            this.sendInvitation(room, occupantBareJid, actor);
        }
        room.addAffiliationByJid(occupantBareJid, newAffiliation);
        boolean isUnavailable = false;
        HashSet<String> codes = new HashSet<String>();
        Collection<String> occupantsNicknames = room.getOccupantsNicknames(occupantBareJid);
        for (String occupantNick : occupantsNicknames) {
            if (newAffiliation != Affiliation.outcast) continue;
            codes.add("301");
            isUnavailable = true;
            occupantJids = room.getOccupantsJidsByNickname(occupantNick);
            for (JID jid : occupantJids) {
                Element occupantKickPresence = this.makePresence(jid, room.getRoomJID(), room, occupantBareJid, isUnavailable, newAffiliation, newRole, occupantNick, reason, actor, codes.toArray(new String[0]));
                this.writer.write(Packet.packetInstance((Element)occupantKickPresence));
            }
            room.removeOccupant(occupantNick);
        }
        for (String nickname : room.getOccupantsNicknames()) {
            occupantJids = room.getOccupantsJidsByNickname(nickname);
            for (JID jid : occupantJids) {
                for (String removed : occupantsNicknames) {
                    Role currentRole = room.getRole(removed);
                    Element occupantPresence = this.makePresence(jid, room.getRoomJID(), room, occupantBareJid, isUnavailable, newAffiliation, currentRole, removed, reason, null, codes.toArray(new String[0]));
                    this.writer.write(Packet.packetInstance((Element)occupantPresence));
                }
            }
        }
    }

    private void processSetRole(Room room, Element item, Role newRole, String reason, String actor) throws TigaseStringprepException {
        String occupantNick = item.getAttribute("nick");
        BareJID occupantJid = room.getOccupantsJidByNickname(occupantNick);
        Affiliation occupantAffiliation = room.getAffiliation(occupantJid);
        boolean isUnavailable = false;
        ArrayList<String> codes = new ArrayList<String>();
        if (newRole == Role.none) {
            codes.add("307");
            isUnavailable = true;
            Collection<JID> occupantJids = room.getOccupantsJidsByNickname(occupantNick);
            for (JID jid : occupantJids) {
                Element occupantKickPresence = this.makePresence(jid, room.getRoomJID(), room, occupantJid, isUnavailable, occupantAffiliation, newRole, occupantNick, reason, actor, codes.toArray(new String[0]));
                this.writer.write(Packet.packetInstance((Element)occupantKickPresence));
            }
            room.removeOccupant(occupantNick);
        } else {
            room.setNewRole(occupantNick, newRole);
        }
        for (String nickname : room.getOccupantsNicknames()) {
            Collection<JID> occupantJids = room.getOccupantsJidsByNickname(nickname);
            for (JID jid : occupantJids) {
                Element occupantPresence = this.makePresence(jid, room.getRoomJID(), room, occupantJid, isUnavailable, occupantAffiliation, newRole, occupantNick, reason, null, codes.toArray(new String[0]));
                this.writer.write(Packet.packetInstance((Element)occupantPresence));
            }
        }
    }

    private void sendInvitation(Room room, BareJID occupantBareJid, String actor) {
        Element message = new Element("message", new String[]{"from", "to"}, new String[]{room.getRoomJID().toString(), occupantBareJid.toString()});
        Element x = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
        message.addChild((XMLNodeIfc)x);
        Element invite = new Element("invite", new String[]{"from"}, new String[]{actor});
        x.addChild((XMLNodeIfc)invite);
        if (room.getConfig().isPasswordProtectedRoom()) {
            x.addChild((XMLNodeIfc)new Element("password", room.getConfig().getPassword()));
        }
        this.writer.writeElement(message);
    }
}

