/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.List;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.Affiliation;
import tigase.muc.ElementWriter;
import tigase.muc.MucConfig;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractModule;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class MediatedInvitationModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"message").add(ElementCriteria.name((String)"x", (String)"http://jabber.org/protocol/muc#user").add((Criteria)ElementCriteria.name((String)"invite")));

    public MediatedInvitationModule(MucConfig config, ElementWriter writer, IMucRepository mucRepository) {
        super(config, writer, mucRepository);
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public void process(Packet element) throws MUCException {
        try {
            JID senderJID = JID.jidInstance((String)element.getAttribute("from"));
            BareJID roomJID = BareJID.bareJIDInstance((String)element.getAttribute("to"));
            if (MediatedInvitationModule.getNicknameFromJid(JID.jidInstance((String)element.getAttribute("to"))) != null) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            Room room = this.repository.getRoom(roomJID);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND);
            }
            String nickName = room.getOccupantsNickname(senderJID);
            Role senderRole = room.getRole(nickName);
            if (!senderRole.isInviteOtherUsers()) {
                throw new MUCException(Authorization.NOT_ALLOWED);
            }
            Affiliation senderAffiliation = room.getAffiliation(senderJID.getBareJID());
            if (room.getConfig().isRoomMembersOnly() && !senderAffiliation.isEditMemberList()) {
                throw new MUCException(Authorization.FORBIDDEN);
            }
            Element x = element.getElement().getChild("x", "http://jabber.org/protocol/muc#user");
            List ch = x.getChildren();
            for (Element invite : ch) {
                if (!"invite".equals(invite.getName())) continue;
                Element reason = invite.getChild("reason");
                Element cont = invite.getChild("continue");
                String recipient = invite.getAttribute("to");
                Element resultMessage = new Element("message", new String[]{"from", "to"}, new String[]{roomJID.toString(), recipient});
                Element resultX = new Element("x", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/muc#user"});
                resultMessage.addChild((XMLNodeIfc)resultX);
                if (room.getConfig().isRoomMembersOnly() && senderAffiliation.isEditMemberList()) {
                    room.addAffiliationByJid(JID.jidInstance((String)recipient).getBareJID(), Affiliation.member);
                }
                Element resultInvite = new Element("invite", new String[]{"from"}, new String[]{senderJID.toString()});
                resultX.addChild((XMLNodeIfc)resultInvite);
                if (room.getConfig().isPasswordProtectedRoom()) {
                    resultX.addChild((XMLNodeIfc)new Element("password", room.getConfig().getPassword()));
                }
                if (reason != null) {
                    resultInvite.addChild((XMLNodeIfc)reason.clone());
                }
                if (cont != null) {
                    resultInvite.addChild((XMLNodeIfc)cont.clone());
                }
                this.writer.write(Packet.packetInstance((Element)resultMessage));
            }
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

