/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.Set;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.ElementWriter;
import tigase.muc.MUCComponent;
import tigase.muc.MucConfig;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractModule;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;

public class DiscoInfoModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"query", (String)"http://jabber.org/protocol/disco#info"));
    private final MUCComponent muc;

    private static void addFeature(Element query, String feature) {
        query.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{feature}));
    }

    public DiscoInfoModule(MucConfig config, ElementWriter writer, IMucRepository mucRepository, MUCComponent component) {
        super(config, writer, mucRepository);
        this.muc = component;
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public void process(Packet element) throws MUCException {
        try {
            String toXML = element.getAttribute("to");
            String node = element.getAttribute("/iq/query", "node");
            JID requestedJID = JID.jidInstance((String)toXML);
            Element resultQuery = new Element("query", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/disco#info"});
            Packet result = element.okResult(resultQuery, 0);
            if (node == null && requestedJID.getLocalpart() == null && requestedJID.getResource() == null) {
                Element resultIdentity = new Element("identity", new String[]{"category", "name", "type"}, new String[]{"conference", "Multi User Chat", "text"});
                resultQuery.addChild((XMLNodeIfc)resultIdentity);
                resultQuery.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/muc"}));
                resultQuery.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{"http://jabber.org/protocol/commands"}));
                Set<String> features = this.muc.getFeaturesFromModule();
                if (features != null) {
                    for (String featur : features) {
                        resultQuery.addChild((XMLNodeIfc)new Element("feature", new String[]{"var"}, new String[]{featur}));
                    }
                }
            } else if (node == null && requestedJID.getLocalpart() != null && requestedJID.getResource() == null) {
                Room room = this.repository.getRoom(requestedJID.getBareJID());
                if (room == null) {
                    throw new MUCException(Authorization.ITEM_NOT_FOUND);
                }
                String roomName = room.getConfig().getRoomName();
                Element resultIdentity = new Element("identity", new String[]{"category", "name", "type"}, new String[]{"conference", roomName == null ? "" : roomName, "text"});
                resultQuery.addChild((XMLNodeIfc)resultIdentity);
                DiscoInfoModule.addFeature(resultQuery, "http://jabber.org/protocol/muc");
                switch (room.getConfig().getRoomAnonymity()) {
                    case fullanonymous: {
                        DiscoInfoModule.addFeature(resultQuery, "muc_fullyanonymous");
                        break;
                    }
                    case semianonymous: {
                        DiscoInfoModule.addFeature(resultQuery, "muc_semianonymous");
                        break;
                    }
                    case nonanonymous: {
                        DiscoInfoModule.addFeature(resultQuery, "muc_nonanonymous");
                    }
                }
                if (room.getConfig().isRoomModerated()) {
                    DiscoInfoModule.addFeature(resultQuery, "muc_moderated");
                } else {
                    DiscoInfoModule.addFeature(resultQuery, "muc_unmoderated");
                }
                if (room.getConfig().isRoomMembersOnly()) {
                    DiscoInfoModule.addFeature(resultQuery, "muc_membersonly");
                } else {
                    DiscoInfoModule.addFeature(resultQuery, "muc_open");
                }
                if (room.getConfig().isPersistentRoom()) {
                    DiscoInfoModule.addFeature(resultQuery, "muc_persistent");
                } else {
                    DiscoInfoModule.addFeature(resultQuery, "muc_temporary");
                }
                if (!room.getConfig().isRoomconfigPublicroom()) {
                    DiscoInfoModule.addFeature(resultQuery, "muc_hidden");
                } else {
                    DiscoInfoModule.addFeature(resultQuery, "muc_public");
                }
                if (room.getConfig().isPasswordProtectedRoom()) {
                    DiscoInfoModule.addFeature(resultQuery, "muc_passwordprotected");
                } else {
                    DiscoInfoModule.addFeature(resultQuery, "muc_unsecured");
                }
            } else if (node != null || requestedJID.getLocalpart() == null || requestedJID.getResource() == null) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            this.writer.write(result);
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (TigaseStringprepException e) {
            throw new MUCException(Authorization.BAD_REQUEST);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

