/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.Collection;
import java.util.logging.Logger;
import tigase.muc.ElementWriter;
import tigase.muc.Module;
import tigase.muc.MucConfig;
import tigase.muc.Room;
import tigase.muc.repository.IMucRepository;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.JID;

public abstract class AbstractModule
implements Module {
    protected final MucConfig config;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected final IMucRepository repository;
    protected final ElementWriter writer;

    public static Element createResultIQ(Element iq) {
        return new Element("iq", new String[]{"type", "from", "to", "id"}, new String[]{"result", iq.getAttribute("to"), iq.getAttribute("from"), iq.getAttribute("id")});
    }

    public static String getNicknameFromJid(JID jid) {
        if (jid != null) {
            return jid.getResource();
        }
        return null;
    }

    public AbstractModule(MucConfig config, ElementWriter writer, IMucRepository mucRepository) {
        this.config = config;
        this.repository = mucRepository;
        this.writer = writer;
    }

    @Override
    public boolean isProcessedByModule(Element element) {
        return true;
    }

    protected void sendMucMessage(Room room, String recipientNickame, String message) throws TigaseStringprepException {
        Collection<JID> occupantJids = room.getOccupantsJidsByNickname(recipientNickame);
        for (JID jid : occupantJids) {
            Element msg = new Element("message", new String[]{"from", "to", "type"}, new String[]{room.getRoomJID().toString(), jid.toString(), "groupchat"});
            msg.addChild((XMLNodeIfc)new Element("body", message));
            this.writer.write(Packet.packetInstance((Element)msg));
        }
    }
}

