/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.history;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import tigase.muc.Affiliation;
import tigase.muc.ElementWriter;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.history.AbstractHistoryProvider;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class MemoryHistoryProvider
extends AbstractHistoryProvider {
    private final HashMap<BareJID, LinkedList<HItem>> history = new HashMap();
    private int maxSize = 256;

    @Override
    public void addJoinEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    @Override
    public void addLeaveEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    @Override
    public void addMessage(Room room, String message, JID senderJid, String senderNickname, Date time) {
        LinkedList<HItem> stanzas = this.history.get(room.getRoomJID());
        if (stanzas == null) {
            stanzas = new LinkedList();
            this.history.put(room.getRoomJID(), stanzas);
        }
        if (stanzas.size() >= this.maxSize) {
            stanzas.poll();
        }
        HItem item = new HItem();
        item.message = message;
        item.senderJid = senderJid;
        item.senderNickname = senderNickname;
        item.timestamp = time;
        stanzas.add(item);
    }

    @Override
    public void addSubjectChange(Room room, String message, JID senderJid, String senderNickname, Date time) {
    }

    @Override
    public void getHistoryMessages(Room room, JID senderJID, Integer maxchars, Integer maxstanzas, Integer seconds, Date since, ElementWriter writer) {
        LinkedList<HItem> stanzas = this.history.get(room.getRoomJID());
        if (stanzas == null) {
            stanzas = new LinkedList();
            this.history.put(room.getRoomJID(), stanzas);
        }
        int c = 0;
        Date now = new Date();
        for (HItem item : stanzas) {
            if (since != null) {
                if (item.timestamp.before(since)) {
                    continue;
                }
            } else if (maxstanzas != null) {
                if (c >= maxstanzas) {
                    break;
                }
            } else if (seconds != null) {
                if (item.timestamp.getTime() < now.getTime() - (long)(seconds * 1000)) {
                    continue;
                }
            } else if (c >= 25) break;
            Affiliation recipientAffiliation = room.getAffiliation(senderJID.getBareJID());
            boolean addRealJids = room.getConfig().getRoomAnonymity() == RoomConfig.Anonymity.nonanonymous || room.getConfig().getRoomAnonymity() == RoomConfig.Anonymity.semianonymous && (recipientAffiliation == Affiliation.owner || recipientAffiliation == Affiliation.admin);
            Element message = this.createMessage(room.getRoomJID().toString(), senderJID.toString(), item.senderNickname, item.message, item.senderJid.toString(), addRealJids, item.timestamp);
            writer.writeElement(message);
            ++c;
        }
    }

    @Override
    public void init(Map<String, Object> props) {
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public void removeHistory(Room room) {
        this.history.remove(room.getRoomJID());
    }

    private static class HItem {
        String message;
        JID senderJid;
        String senderNickname;
        Date timestamp;

        private HItem() {
        }
    }
}

