/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.history;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.DataRepository;
import tigase.db.RepositoryFactory;
import tigase.muc.history.DerbySqlHistoryProvider;
import tigase.muc.history.HistoryProvider;
import tigase.muc.history.MemoryHistoryProvider;
import tigase.muc.history.MySqlHistoryProvider;
import tigase.muc.history.PostgreSqlHistoryProvider;

public class HistoryManagerFactory {
    public static final String DB_CLASS_KEY = "history-db";
    public static final String DB_URI_KEY = "history-db-uri";
    protected static final Logger log = Logger.getLogger(HistoryManagerFactory.class.getName());

    public static HistoryProvider getHistoryManager(Map<String, Object> params) {
        try {
            String uri = (String)params.get(DB_URI_KEY);
            String cl = (String)params.get(DB_CLASS_KEY);
            if (log.isLoggable(Level.CONFIG)) {
                log.config("Used History Provider: " + cl);
            }
            if (cl.contains("memory")) {
                return new MemoryHistoryProvider();
            }
            if (cl.contains("mysql")) {
                DataRepository dataRepository = RepositoryFactory.getDataRepository(null, (String)uri, null);
                return new MySqlHistoryProvider(dataRepository);
            }
            if (cl.contains("derby")) {
                DataRepository dataRepository = RepositoryFactory.getDataRepository(null, (String)uri, null);
                return new DerbySqlHistoryProvider(dataRepository);
            }
            if (cl.contains("pgsql")) {
                DataRepository dataRepository = RepositoryFactory.getDataRepository(null, (String)uri, null);
                return new PostgreSqlHistoryProvider(dataRepository);
            }
            throw new RuntimeException("Database not supported");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

