/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.history;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import tigase.db.DataRepository;
import tigase.muc.Affiliation;
import tigase.muc.ElementWriter;
import tigase.muc.Room;
import tigase.muc.RoomConfig;
import tigase.muc.history.AbstractHistoryProvider;
import tigase.xml.Element;
import tigase.xmpp.JID;

public class DerbySqlHistoryProvider
extends AbstractHistoryProvider {
    public static final String ADD_MESSAGE_QUERY = "insert into muc_history (room_name, event_type, timestamp, sender_jid, sender_nickname, body) values (?, 1, ?, ?, ?, ?)";
    public static final String DELETE_MESSAGES_QUERY = "delete from muc_history where room_name=?";
    public static final String GET_MESSAGES_MAXSTANZAS_QUERY = "select room_name, event_type, timestamp, sender_jid, sender_nickname, body from muc_history where room_name=? order by timestamp desc";
    public static final String GET_MESSAGES_SINCE_QUERY = "select room_name, event_type, timestamp, sender_jid, sender_nickname, body from muc_history where room_name=? and timestamp >= ? order by timestamp desc";
    private final String createMucHistoryTable = "create table muc_history (room_name char(128) NOT NULL,\nevent_type int, \ntimestamp TIMESTAMP,\nsender_jid varchar(2049),\nsender_nickname char(128),\nbody varchar(4096) )";
    private final DataRepository dataRepository;

    public DerbySqlHistoryProvider(DataRepository dataRepository) {
        this.dataRepository = dataRepository;
    }

    @Override
    public void addJoinEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    @Override
    public void addLeaveEvent(Room room, Date date, JID senderJID, String nickName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessage(Room room, String message, JID senderJid, String senderNickname, Date time) {
        try {
            PreparedStatement st;
            PreparedStatement preparedStatement = st = this.dataRepository.getPreparedStatement(null, ADD_MESSAGE_QUERY);
            synchronized (preparedStatement) {
                st.setString(1, room.getRoomJID().toString());
                st.setTimestamp(2, time == null ? null : new Timestamp(time.getTime()));
                st.setString(3, senderJid.toString());
                st.setString(4, senderNickname);
                st.setString(5, message);
                st.executeUpdate();
            }
        }
        catch (SQLException e) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.log(Level.WARNING, "Can't add MUC message to database", e);
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void addSubjectChange(Room room, String message, JID senderJid, String senderNickname, Date time) {
    }

    @Override
    public void getHistoryMessages(Room room, JID senderJID, Integer maxchars, Integer maxstanzas, Integer seconds, Date since, ElementWriter writer) {
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            Integer maxStanzas = null;
            if (since != null) {
                st = this.dataRepository.getPreparedStatement(null, GET_MESSAGES_SINCE_QUERY);
                st.setTimestamp(2, new Timestamp(since.getTime()));
            } else if (maxstanzas != null) {
                st = this.dataRepository.getPreparedStatement(null, GET_MESSAGES_MAXSTANZAS_QUERY);
                maxStanzas = maxstanzas;
            } else if (seconds != null) {
                st = this.dataRepository.getPreparedStatement(null, GET_MESSAGES_SINCE_QUERY);
                st.setTimestamp(2, new Timestamp(new Date().getTime() - (long)(seconds * 1000)));
            } else {
                st = this.dataRepository.getPreparedStatement(null, GET_MESSAGES_MAXSTANZAS_QUERY);
                maxStanzas = 20;
            }
            String roomJID = room.getRoomJID().toString();
            st.setString(1, roomJID);
            rs = st.executeQuery();
            Affiliation recipientAffiliation = room.getAffiliation(senderJID.getBareJID());
            boolean addRealJids = room.getConfig().getRoomAnonymity() == RoomConfig.Anonymity.nonanonymous || room.getConfig().getRoomAnonymity() == RoomConfig.Anonymity.semianonymous && (recipientAffiliation == Affiliation.owner || recipientAffiliation == Affiliation.admin);
            ArrayList<Element> result = new ArrayList<Element>();
            for (int i = 0; rs.next() && (maxStanzas == null || maxStanzas > i); ++i) {
                String msgSenderNickname = rs.getString("sender_nickname");
                Timestamp msgTimestamp = rs.getTimestamp("timestamp");
                String msgSenderJid = rs.getString("sender_jid");
                String msg = rs.getString("body");
                Element m = this.createMessage(roomJID, senderJID.toString(), msgSenderNickname, msg, msgSenderJid, addRealJids, msgTimestamp);
                result.add(0, m);
            }
            for (Element element : result) {
                writer.writeElement(element);
            }
        }
        catch (Exception e) {
            try {
                if (this.log.isLoggable(Level.SEVERE)) {
                    this.log.log(Level.SEVERE, "Can't get history", e);
                }
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.dataRepository.release(null, rs);
                throw throwable;
            }
        }
        this.dataRepository.release(null, rs);
    }

    @Override
    public void init(Map<String, Object> props) {
        try {
            this.dataRepository.checkTable("muc_history", "create table muc_history (room_name char(128) NOT NULL,\nevent_type int, \ntimestamp TIMESTAMP,\nsender_jid varchar(2049),\nsender_nickname char(128),\nbody varchar(4096) )");
            this.internalInit();
        }
        catch (SQLException e) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.log(Level.WARNING, "Initializing problem", e);
            }
            try {
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.info("Trying to create tables: create table muc_history (room_name char(128) NOT NULL,\nevent_type int, \ntimestamp TIMESTAMP,\nsender_jid varchar(2049),\nsender_nickname char(128),\nbody varchar(4096) )");
                }
                Statement st = this.dataRepository.createStatement(null);
                st.execute("create table muc_history (room_name char(128) NOT NULL,\nevent_type int, \ntimestamp TIMESTAMP,\nsender_jid varchar(2049),\nsender_nickname char(128),\nbody varchar(4096) )");
                this.internalInit();
            }
            catch (SQLException e1) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.log(Level.WARNING, "Can't initialize muc history", e1);
                }
                throw new RuntimeException(e1);
            }
        }
    }

    private void internalInit() throws SQLException {
        this.dataRepository.initPreparedStatement(ADD_MESSAGE_QUERY, ADD_MESSAGE_QUERY);
        this.dataRepository.initPreparedStatement(DELETE_MESSAGES_QUERY, DELETE_MESSAGES_QUERY);
        this.dataRepository.initPreparedStatement(GET_MESSAGES_SINCE_QUERY, GET_MESSAGES_SINCE_QUERY);
        this.dataRepository.initPreparedStatement(GET_MESSAGES_MAXSTANZAS_QUERY, GET_MESSAGES_MAXSTANZAS_QUERY);
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHistory(Room room) {
        try {
            PreparedStatement st;
            PreparedStatement preparedStatement = st = this.dataRepository.getPreparedStatement(null, DELETE_MESSAGES_QUERY);
            synchronized (preparedStatement) {
                st.setString(1, room.getRoomJID().toString());
                st.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.log.log(Level.WARNING, "Can't delete MUC messages from database", e);
            throw new RuntimeException(e);
        }
    }
}

