/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.exceptions;

import tigase.server.Packet;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;

public class MUCException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Authorization errorCondition;
    private String text;

    public MUCException(Authorization errorCondition) {
        this(errorCondition, (String)null);
    }

    public MUCException(Authorization errorCondition, String message) {
        this.errorCondition = errorCondition;
        this.text = message;
    }

    public String getCode() {
        return String.valueOf(this.errorCondition.getErrorCode());
    }

    public Authorization getErrorCondition() {
        return this.errorCondition;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.errorCondition.name()).append(" ");
        if (this.text != null) {
            sb.append("\"").append(this.text).append("\" ");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getName() {
        return this.errorCondition.getCondition();
    }

    public String getText() {
        return this.text;
    }

    public String getType() {
        return this.errorCondition.getErrorType();
    }

    public Packet makeElement(Packet packet, boolean insertOriginal) throws PacketErrorTypeException {
        Packet result = this.errorCondition.getResponseMessage(packet, this.text, insertOriginal);
        return result;
    }
}

