/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import tigase.collections.TwoHashBidiMap;
import tigase.muc.Affiliation;
import tigase.muc.PresenceStore;
import tigase.muc.Role;
import tigase.muc.RoomConfig;
import tigase.muc.repository.RepositoryException;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class Room {
    private final Map<BareJID, Affiliation> affiliations = new ConcurrentHashMap<BareJID, Affiliation>();
    private final RoomConfig config;
    private final Date creationDate;
    private final BareJID creatorJid;
    private final List<RoomListener> listeners = new CopyOnWriteArrayList<RoomListener>();
    private final TwoHashBidiMap<String, OccupantEntry> occupants = new TwoHashBidiMap();
    private final PresenceStore presences = new PresenceStore();
    private boolean roomLocked;
    private String subject;
    private Date subjectChangeDate;
    private String subjectChangerNick;

    public Room(RoomConfig rc, Date creationDate, BareJID creatorJid) {
        this.config = rc;
        this.creationDate = creationDate;
        this.creatorJid = creatorJid;
    }

    public void addAffiliationByJid(BareJID jid, Affiliation affiliation) throws RepositoryException {
        if (affiliation == Affiliation.none) {
            this.affiliations.remove(jid);
        } else {
            this.affiliations.put(jid, affiliation);
        }
        this.fireOnSetAffiliation(jid, affiliation);
    }

    public void addListener(RoomListener listener) {
        this.listeners.add(listener);
    }

    public void addOccupantByJid(JID senderJid, String nickName, Role role) {
        OccupantEntry entry = (OccupantEntry)this.occupants.get((Object)nickName);
        if (entry == null) {
            entry = new OccupantEntry();
            entry.jid = senderJid.getBareJID();
            this.occupants.put((Object)nickName, (Object)entry);
        }
        entry.role = role;
        entry.jids.add(senderJid);
    }

    public void changeNickName(JID senderJid, String nickName) {
        OccupantEntry occ = this.getBySenderJid(senderJid);
        String oldNickname = (String)this.occupants.getKey((Object)occ);
        this.occupants.remove((Object)oldNickname);
        this.occupants.put((Object)nickName, (Object)occ);
    }

    private void fireOnSetAffiliation(BareJID jid, Affiliation affiliation) {
        for (RoomListener listener : this.listeners) {
            listener.onSetAffiliation(this, jid, affiliation);
        }
    }

    private void fireOnSetSubject(String nick, String subject, Date changeDate) {
        for (RoomListener listener : this.listeners) {
            listener.onChangeSubject(this, nick, subject, changeDate);
        }
    }

    public Affiliation getAffiliation(BareJID jid) {
        Affiliation result = null;
        if (jid != null) {
            result = this.affiliations.get(jid);
        }
        return result == null ? Affiliation.none : result;
    }

    public Affiliation getAffiliation(String nickname) {
        OccupantEntry entry = (OccupantEntry)this.occupants.get((Object)nickname);
        return this.getAffiliation(entry == null ? null : entry.jid);
    }

    public Collection<BareJID> getAffiliations() {
        return this.affiliations.keySet();
    }

    private OccupantEntry getBySenderJid(JID sender) {
        for (Map.Entry e : this.occupants.entrySet()) {
            if (!((OccupantEntry)e.getValue()).jids.contains(sender)) continue;
            return (OccupantEntry)e.getValue();
        }
        return null;
    }

    public RoomConfig getConfig() {
        return this.config;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public BareJID getCreatorJid() {
        return this.creatorJid;
    }

    public Element getLastPresenceCopyByJid(BareJID occupantJid) {
        Element e = this.presences.getBestPresence(occupantJid);
        if (e != null) {
            return e.clone();
        }
        return null;
    }

    public int getOccupantsCount() {
        return this.occupants.size();
    }

    public BareJID getOccupantsJidByNickname(String nickname) {
        OccupantEntry entry = (OccupantEntry)this.occupants.get((Object)nickname);
        if (entry == null) {
            return null;
        }
        if (!entry.jids.isEmpty()) {
            return ((JID)entry.jids.iterator().next()).getBareJID();
        }
        return null;
    }

    public Collection<JID> getOccupantsJidsByNickname(String nickname) {
        OccupantEntry entry = (OccupantEntry)this.occupants.get((Object)nickname);
        if (entry == null) {
            return new ArrayList<JID>();
        }
        return Collections.unmodifiableCollection(entry.jids);
    }

    public String getOccupantsNickname(JID jid) {
        OccupantEntry e = this.getBySenderJid(jid);
        if (e == null) {
            return null;
        }
        String nickname = (String)this.occupants.getKey((Object)e);
        return nickname;
    }

    public Collection<String> getOccupantsNicknames() {
        return Collections.unmodifiableCollection(this.occupants.keySet());
    }

    public Collection<String> getOccupantsNicknames(BareJID bareJid) {
        HashSet result = new HashSet();
        for (Map.Entry e : this.occupants.entrySet()) {
            if (!((OccupantEntry)e.getValue()).jid.equals((Object)bareJid)) continue;
            result.add(e.getKey());
        }
        return Collections.unmodifiableCollection(result);
    }

    public Role getRole(String nickname) {
        OccupantEntry entry = (OccupantEntry)this.occupants.get((Object)nickname);
        if (entry == null) {
            return Role.none;
        }
        return entry.role == null ? Role.none : entry.role;
    }

    public BareJID getRoomJID() {
        return this.config.getRoomJID();
    }

    public String getSubject() {
        return this.subject;
    }

    public Date getSubjectChangeDate() {
        return this.subjectChangeDate;
    }

    public String getSubjectChangerNick() {
        return this.subjectChangerNick;
    }

    public boolean isOccupantInRoom(JID jid) {
        return this.getBySenderJid(jid) != null;
    }

    public boolean isRoomLocked() {
        return this.roomLocked;
    }

    public void removeListener(RoomListener listener) {
        this.listeners.remove(listener);
    }

    public boolean removeOccupant(JID jid) {
        OccupantEntry e = this.getBySenderJid(jid);
        if (e != null) {
            e.jids.remove(jid);
            if (e.jids.isEmpty()) {
                this.occupants.removeValue((Object)e);
                return true;
            }
        }
        return false;
    }

    public void removeOccupant(String occupantNick) {
        this.occupants.remove((Object)occupantNick);
    }

    public void setAffiliations(Map<BareJID, Affiliation> affiliations) {
        this.affiliations.clear();
        this.affiliations.putAll(affiliations);
    }

    public void setNewRole(String nickname, Role newRole) {
        OccupantEntry entry = (OccupantEntry)this.occupants.get((Object)nickname);
        if (entry != null) {
            entry.role = newRole;
        }
    }

    public void setNewSubject(String msg, String senderNickname) throws RepositoryException {
        this.subjectChangerNick = senderNickname;
        this.subject = msg;
        this.subjectChangeDate = new Date();
        this.fireOnSetSubject(senderNickname, msg, this.subjectChangeDate);
    }

    public void setRoomLocked(boolean roomLocked) {
        this.roomLocked = roomLocked;
    }

    public void setSubjectChangeDate(Date subjectChangeDate) {
        this.subjectChangeDate = subjectChangeDate;
    }

    public void updatePresenceByJid(JID jid, Element cp) throws TigaseStringprepException {
        if (cp == null) {
            this.presences.remove(jid);
        } else {
            this.presences.update(cp);
        }
    }

    public static interface RoomListener {
        public void onChangeSubject(Room var1, String var2, String var3, Date var4);

        public void onSetAffiliation(Room var1, BareJID var2, Affiliation var3);
    }

    private static class OccupantEntry {
        public BareJID jid;
        private final Set<JID> jids = new HashSet<JID>();
        private Role role = Role.none;

        private OccupantEntry() {
        }
    }
}

