/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class PresenceStore {
    private Map<BareJID, Presence> bestPresence = new ConcurrentHashMap<BareJID, Presence>();
    private Map<JID, Presence> presenceByJid = new ConcurrentHashMap<JID, Presence>();
    private Map<BareJID, Map<String, Presence>> presencesMapByBareJid = new ConcurrentHashMap<BareJID, Map<String, Presence>>();

    public void clear() {
        this.presenceByJid.clear();
        this.bestPresence.clear();
        this.presencesMapByBareJid.clear();
    }

    public Element getBestPresence(BareJID jid) {
        Presence p = this.bestPresence.get(jid);
        return p == null ? null : p.element;
    }

    public Element getPresence(JID jid) {
        Presence p = this.presenceByJid.get(jid);
        return p == null ? null : p.element;
    }

    private Presence intGetBestPresence(BareJID jid) {
        Map<String, Presence> resourcesPresence = this.presencesMapByBareJid.get(jid);
        Presence result = null;
        if (resourcesPresence != null) {
            for (Presence x : resourcesPresence.values()) {
                Integer p = x.priority;
                if (result != null && (p < result.priority || x.type != null)) continue;
                result = x;
            }
        }
        return result;
    }

    public boolean isAvailable(BareJID jid) {
        boolean result;
        Map<String, Presence> resourcesPresence = this.presencesMapByBareJid.get(jid);
        if (resourcesPresence != null) {
            Presence x;
            Iterator<Presence> it = resourcesPresence.values().iterator();
            for (result = false; it.hasNext() && !result; result |= x.type == null) {
                x = it.next();
            }
        }
        return result;
    }

    public void remove(JID from) throws TigaseStringprepException {
        String resource = from.getResource() == null ? "" : from.getResource();
        this.presenceByJid.remove(from);
        Map<String, Presence> m = this.presencesMapByBareJid.get(from.getBareJID());
        if (m != null) {
            m.remove(resource);
            if (m.isEmpty()) {
                this.presencesMapByBareJid.remove(from.getBareJID());
            }
        }
        this.updateBestPresence(from.getBareJID());
    }

    public void update(Element presence) throws TigaseStringprepException {
        String f = presence.getAttribute("from");
        if (f == null) {
            return;
        }
        JID from = JID.jidInstance((String)f);
        BareJID bareFrom = from.getBareJID();
        String resource = from.getResource() == null ? "" : from.getResource();
        Presence p = new Presence(presence);
        if (p.type != null && p.type.equals("unavailable")) {
            this.presenceByJid.remove(from);
            Map<String, Presence> m = this.presencesMapByBareJid.get(bareFrom);
            if (m != null) {
                m.remove(resource);
                if (m.isEmpty()) {
                    this.presencesMapByBareJid.remove(bareFrom);
                }
            }
        } else {
            this.presenceByJid.put(from, p);
            Map<String, Presence> m = this.presencesMapByBareJid.get(bareFrom);
            if (m == null) {
                m = new ConcurrentHashMap<String, Presence>();
                this.presencesMapByBareJid.put(bareFrom, m);
            }
            m.put(resource, p);
        }
        this.updateBestPresence(bareFrom);
    }

    private void updateBestPresence(BareJID bareFrom) throws TigaseStringprepException {
        Presence x = this.intGetBestPresence(bareFrom);
        if (x == null) {
            this.bestPresence.remove(bareFrom);
        } else {
            this.bestPresence.put(bareFrom, x);
        }
    }

    private class Presence {
        final Element element;
        final int priority;
        final String type;

        public Presence(Element presence) {
            this.element = presence;
            this.type = presence.getAttribute("type");
            String p = presence.getChildCData("/presence/priority");
            int x = 0;
            try {
                x = Integer.parseInt(p);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.priority = x;
        }
    }
}

