/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.criteria.Criteria;
import tigase.muc.ElementWriter;
import tigase.muc.Module;
import tigase.muc.exceptions.MUCException;
import tigase.server.Packet;
import tigase.util.TigaseStringprepException;

public class ModulesManager {
    private Logger log = Logger.getLogger(this.getClass().getName());
    private final ArrayList<Module> modules = new ArrayList();
    private final ElementWriter writer;

    public ModulesManager() {
        this.writer = null;
    }

    public ModulesManager(ElementWriter writer) {
        this.writer = writer;
    }

    public Collection<String> getFeatures() {
        ArrayList<String> features = new ArrayList<String>();
        for (Module m : this.modules) {
            String[] fs = m.getFeatures();
            if (fs == null) continue;
            for (String string : fs) {
                features.add(string);
            }
        }
        return features;
    }

    public boolean process(Packet packet) throws MUCException, TigaseStringprepException {
        return this.process(packet, this.writer);
    }

    public boolean process(Packet packet, ElementWriter writer) throws MUCException, TigaseStringprepException {
        if (writer == null) {
            throw new Error("ElementWriter is null");
        }
        boolean handled = false;
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finest("Processing packet: " + packet.toString());
        }
        for (Module module : this.modules) {
            Criteria criteria = module.getModuleCriteria();
            if (criteria == null || !criteria.match(packet.getElement())) continue;
            handled = true;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Handled by module " + module.getClass());
            }
            module.process(packet);
            if (!this.log.isLoggable(Level.FINEST)) break;
            this.log.finest("Finished " + module.getClass());
            break;
        }
        return handled;
    }

    public <T extends Module> T register(T module) {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Register PubSub module: " + module.getClass().getCanonicalName());
        }
        this.modules.add(module);
        return module;
    }

    public void unregister(Module module) {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Unregister PubSub module: " + module.getClass().getCanonicalName());
        }
        this.modules.remove(module);
    }
}

