/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import tigase.conf.Configurable;
import tigase.db.RepositoryFactory;
import tigase.db.UserRepository;
import tigase.disco.ServiceEntity;
import tigase.disco.ServiceIdentity;
import tigase.disco.XMPPService;
import tigase.muc.ElementWriter;
import tigase.muc.Ghostbuster;
import tigase.muc.ModulesManager;
import tigase.muc.MucConfig;
import tigase.muc.MucVersion;
import tigase.muc.exceptions.MUCException;
import tigase.muc.history.HistoryManagerFactory;
import tigase.muc.history.HistoryProvider;
import tigase.muc.history.MemoryHistoryProvider;
import tigase.muc.logger.MucLogger;
import tigase.muc.modules.DiscoInfoModule;
import tigase.muc.modules.DiscoItemsModule;
import tigase.muc.modules.GroupchatMessageModule;
import tigase.muc.modules.MediatedInvitationModule;
import tigase.muc.modules.ModeratorModule;
import tigase.muc.modules.PresenceModule;
import tigase.muc.modules.PrivateMessageModule;
import tigase.muc.modules.RoomConfigurationModule;
import tigase.muc.modules.SoftwareVersionModule;
import tigase.muc.modules.UniqueRoomNameModule;
import tigase.muc.modules.XmppPingModule;
import tigase.muc.repository.IMucRepository;
import tigase.muc.repository.MucDAO;
import tigase.muc.repository.inmemory.InMemoryMucRepository;
import tigase.server.AbstractMessageReceiver;
import tigase.server.DisableDisco;
import tigase.server.Packet;
import tigase.server.ReceiverTimeoutHandler;
import tigase.util.DNSResolver;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class MUCComponent
extends AbstractMessageReceiver
implements PresenceModule.DelayDeliveryThread.DelDeliverySend,
XMPPService,
Configurable,
DisableDisco {
    public static final String ADMINS_KEY = "admins";
    public static final String LOG_DIR_KEY = "room-log-directory";
    public static final String MESSAGE_FILTER_ENABLED_KEY = "message-filter-enabled";
    public static final String MUC_ALLOW_CHAT_STATES_KEY = "muc-allow-chat-states";
    public static final String MUC_LOCK_NEW_ROOM_KEY = "muc-lock-new-room";
    protected static final String MUC_REPO_CLASS_PROP_KEY = "muc-repo-class";
    protected static final String MUC_REPO_URL_PROP_KEY = "muc-repo-url";
    private static final String MUC_REPOSITORY_VAR = "mucRepository";
    private static final String OWNER_MODULE_VAR = "ownerModule";
    public static final String PING_EVERY_MINUTE_KEY = "ping-every-minute";
    public static final String PRESENCE_FILTER_ENABLED_KEY = "presence-filter-enabled";
    private static final String PRESENCE_MODULE_VAR = "presenceModule";
    private MucConfig config = new MucConfig();
    private MucDAO dao;
    private final Ghostbuster ghostbuster;
    private HistoryProvider historyProvider;
    public String[] HOSTNAMES_PROP_VAL = new String[]{"localhost", "hostname"};
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private GroupchatMessageModule messageModule;
    private final ModulesManager modulesManager = new ModulesManager();
    private IMucRepository mucRepository;
    private RoomConfigurationModule ownerModule;
    private boolean pingEveryMinute = false;
    private PresenceModule presenceModule;
    private MucLogger roomLogger;
    private ServiceEntity serviceEntity;
    private UserRepository userRepository;
    private final ElementWriter writer;

    public MUCComponent() {
        this.ghostbuster = new Ghostbuster(this);
        this.writer = new ElementWriter(){

            @Override
            public void write(Collection<Packet> elements) {
                if (elements != null) {
                    for (Packet element : elements) {
                        if (element == null) continue;
                        this.write(element);
                    }
                }
            }

            @Override
            public void write(Packet packet) {
                if (MUCComponent.this.log.isLoggable(Level.FINER)) {
                    MUCComponent.this.log.finer("Sent: " + packet.getElement());
                }
                MUCComponent.this.addOutPacket(packet);
            }

            @Override
            public void writeElement(Collection<Element> elements) {
                if (elements != null) {
                    for (Element element : elements) {
                        if (element == null) continue;
                        this.writeElement(element);
                    }
                }
            }

            @Override
            public void writeElement(Element element) {
                if (element != null) {
                    try {
                        if (MUCComponent.this.log.isLoggable(Level.FINER)) {
                            MUCComponent.this.log.finer("Sent: " + element);
                        }
                        MUCComponent.this.addOutPacket(Packet.packetInstance((Element)element));
                    }
                    catch (TigaseStringprepException tigaseStringprepException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public MUCComponent(ElementWriter writer) {
        this.ghostbuster = new Ghostbuster(this);
        this.writer = writer;
    }

    boolean addOutPacket(Packet packet, ReceiverTimeoutHandler handler, long delay, TimeUnit unit) {
        return super.addOutPacketWithTimeout(packet, handler, delay, unit);
    }

    public synchronized void everyHour() {
        super.everyHour();
        if (!this.pingEveryMinute) {
            this.executePingInThread();
        }
    }

    public synchronized void everyMinute() {
        super.everyMinute();
        if (this.pingEveryMinute) {
            this.executePingInThread();
        }
    }

    private void executePingInThread() {
        if (this.ghostbuster != null) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        MUCComponent.this.ghostbuster.ping();
                    }
                    catch (Exception e) {
                        MUCComponent.this.log.log(Level.SEVERE, "Can't ping known JIDs", e);
                    }
                }
            }.start();
        }
    }

    public MucConfig getConfig() {
        return this.config;
    }

    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map props = super.getDefaults(params);
        this.HOSTNAMES_PROP_VAL = params.get("--virt-hosts") != null ? ((String)params.get("--virt-hosts")).split(",") : DNSResolver.getDefHostNames();
        props.put(MESSAGE_FILTER_ENABLED_KEY, Boolean.TRUE);
        props.put(PRESENCE_FILTER_ENABLED_KEY, Boolean.FALSE);
        props.put(PING_EVERY_MINUTE_KEY, Boolean.FALSE);
        String[] hostnames = new String[this.HOSTNAMES_PROP_VAL.length];
        int i = 0;
        for (String host : this.HOSTNAMES_PROP_VAL) {
            hostnames[i++] = this.getName() + "." + host;
        }
        props.put("hostnames", hostnames);
        String repo_class = params.get("--user-db") != null ? (String)params.get("--user-db") : "tigase.db.jdbc.JDBCRepository";
        String repo_uri = params.get("--user-db-uri") != null ? (String)params.get("--user-db-uri") : "jdbc:derby:tigase-derbydb;create=true";
        props.put(MUC_REPO_CLASS_PROP_KEY, repo_class);
        props.put(MUC_REPO_URL_PROP_KEY, repo_uri);
        props.put("history-db", repo_class);
        props.put("history-db-uri", repo_uri);
        String[] admins = params.get("--admins") != null ? ((String)params.get("--admins")).split(",") : new String[]{"admin@" + this.getDefHostName()};
        props.put(ADMINS_KEY, admins);
        props.put(LOG_DIR_KEY, new String("./logs/"));
        props.put(MUC_ALLOW_CHAT_STATES_KEY, Boolean.FALSE);
        props.put(MUC_LOCK_NEW_ROOM_KEY, Boolean.TRUE);
        return props;
    }

    public List<Element> getDiscoFeatures() {
        return null;
    }

    public Element getDiscoInfo(String node, JID jid) {
        return null;
    }

    public List<Element> getDiscoItems(String node, JID jid) {
        if (node == null) {
            Element result = this.serviceEntity.getDiscoItem(null, this.getName() + "." + jid.toString());
            return Arrays.asList(result);
        }
        return null;
    }

    public Set<String> getFeaturesFromModule() {
        HashSet<String> result = new HashSet<String>();
        result.addAll(this.modulesManager.getFeatures());
        return result;
    }

    public IMucRepository getMucRepository() {
        return this.mucRepository;
    }

    public String getName() {
        return "muc";
    }

    protected void init() {
        this.presenceModule = new PresenceModule(this.config, this.writer, this.mucRepository, this.historyProvider, this, this.roomLogger);
        this.ghostbuster.setPresenceModule(this.presenceModule);
        this.modulesManager.register(new PrivateMessageModule(this.config, this.writer, this.mucRepository));
        this.messageModule = this.modulesManager.register(new GroupchatMessageModule(this.config, this.writer, this.mucRepository, this.historyProvider, this.roomLogger));
        this.modulesManager.register(this.presenceModule);
        this.ownerModule = this.modulesManager.register(new RoomConfigurationModule(this.config, this.writer, this.mucRepository, this.historyProvider, this.messageModule));
        this.modulesManager.register(new ModeratorModule(this.config, this.writer, this.mucRepository));
        this.modulesManager.register(new SoftwareVersionModule(this.writer));
        this.modulesManager.register(new XmppPingModule(this.writer));
        this.modulesManager.register(new DiscoItemsModule(this.config, this.writer, this.mucRepository, this.scriptCommands, this));
        this.modulesManager.register(new DiscoInfoModule(this.config, this.writer, this.mucRepository, this));
        this.modulesManager.register(new MediatedInvitationModule(this.config, this.writer, this.mucRepository));
        this.modulesManager.register(new UniqueRoomNameModule(this.config, this.writer, this.mucRepository));
    }

    public void initBindings(Bindings binds) {
        super.initBindings(binds);
        binds.put(PRESENCE_MODULE_VAR, (Object)this.presenceModule);
        binds.put(OWNER_MODULE_VAR, (Object)this.ownerModule);
        binds.put(MUC_REPOSITORY_VAR, (Object)this.mucRepository);
    }

    private void processCommandPacket(Packet packet) {
        ArrayDeque results = new ArrayDeque();
        this.processScriptCommand(packet, results);
        if (results.size() > 0) {
            for (Packet res : results) {
                this.addOutPacketNB(res);
            }
        }
    }

    public void processPacket(Packet packet) {
        if (packet.isCommand()) {
            this.processCommandPacket(packet);
        } else {
            this.processStanzaPacket(packet);
        }
    }

    protected void processStanzaPacket(Packet packet) {
        try {
            this.ghostbuster.update(packet);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "There is no Dana, there is only Zuul", e);
        }
        try {
            boolean handled = this.modulesManager.process(packet, this.writer);
            if (!handled) {
                StanzaType type;
                String t = packet.getElement().getAttribute("type");
                StanzaType stanzaType = type = t == null ? null : StanzaType.valueof((String)t);
                if (type != StanzaType.error) {
                    throw new MUCException(Authorization.FEATURE_NOT_IMPLEMENTED);
                }
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.finer(packet.getElemName() + " stanza with type='error' ignored");
                }
            }
        }
        catch (TigaseStringprepException e) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.log(Level.FINER, "Exception thrown for " + packet.toString(), e);
            } else if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "PubSubException on stanza id=" + packet.getAttribute("id") + " " + e.getMessage());
            }
            this.sendException(packet, new MUCException(Authorization.JID_MALFORMED));
        }
        catch (MUCException e) {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.log(Level.FINER, "Exception thrown for " + packet.toString(), e);
            } else if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "PubSubException on stanza id=" + packet.getAttribute("id") + " " + e.getMessage());
            }
            this.sendException(packet, e);
        }
    }

    @Override
    public void sendDelayedPacket(Packet packet) {
        this.addOutPacket(packet);
    }

    private void sendException(Packet packet, MUCException e) {
        block5: {
            try {
                String t = packet.getElement().getAttribute("type");
                if (t != null && t == "error") {
                    if (this.log.isLoggable(Level.FINER)) {
                        this.log.finer(packet.getElemName() + " stanza already with type='error' ignored");
                    }
                    return;
                }
                Packet result = e.makeElement(packet, true);
                Element el = result.getElement();
                el.setAttribute("from", BareJID.bareJIDInstance((String)el.getAttribute("from")).toString());
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.log(Level.FINEST, "Sending back: " + result.toString());
                }
                this.writer.write(result);
            }
            catch (Exception e1) {
                if (!this.log.isLoggable(Level.WARNING)) break block5;
                this.log.log(Level.WARNING, "Problem during generate error response", e1);
            }
        }
    }

    public void setConfig(MucConfig config2) {
        this.config = config2;
    }

    public void setMucRepository(IMucRepository mucRepository) {
        this.mucRepository = mucRepository;
    }

    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        if (props.size() == 1) {
            return;
        }
        this.pingEveryMinute = (Boolean)props.get(PING_EVERY_MINUTE_KEY);
        this.serviceEntity = new ServiceEntity(this.getName(), null, "Multi User Chat");
        this.serviceEntity.addIdentities(new ServiceIdentity[]{new ServiceIdentity("conference", "text", "Multi User Chat")});
        this.serviceEntity.addFeatures(new String[]{"http://jabber.org/protocol/muc"});
        this.config.init(props);
        try {
            this.historyProvider = HistoryManagerFactory.getHistoryManager(props);
            this.historyProvider.init(props);
        }
        catch (Exception e) {
            this.historyProvider = new MemoryHistoryProvider();
            throw new RuntimeException(e);
        }
        if (props.containsKey("muc-logger-class")) {
            String loggerClassName = (String)props.get("muc-logger-class");
            try {
                if (this.log.isLoggable(Level.CONFIG)) {
                    this.log.config("Using Room Logger: " + loggerClassName);
                }
                this.roomLogger = (MucLogger)Class.forName(loggerClassName).newInstance();
                this.roomLogger.init(props);
            }
            catch (Exception e) {
                System.err.println("");
                System.err.println("  --------------------------------------");
                System.err.println("  ERROR! Terminating the server process.");
                System.err.println("  Problem initializing the MUC Component: " + e);
                System.err.println("  Please fix the problem and start the server again.");
                e.printStackTrace();
                System.exit(1);
            }
        }
        this.config.setPublicLoggingEnabled(this.roomLogger != null || this.historyProvider.isPersistent());
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("Public Logging Allowed: " + this.config.isPublicLoggingEnabled());
        }
        if (this.userRepository == null) {
            this.userRepository = (UserRepository)props.get("shared-user-repo");
            try {
                if (this.userRepository == null) {
                    String cls_name = (String)props.get(MUC_REPO_CLASS_PROP_KEY);
                    String res_uri = (String)props.get(MUC_REPO_URL_PROP_KEY);
                    this.userRepository = RepositoryFactory.getUserRepository((String)cls_name, (String)res_uri, null);
                    this.userRepository.initRepository(res_uri, null);
                }
                this.dao = new MucDAO(this.config, this.userRepository);
                this.mucRepository = new InMemoryMucRepository(this.config, this.dao);
            }
            catch (Exception e) {
                if (this.log.isLoggable(Level.SEVERE)) {
                    this.log.severe("Can't initialize MUC repository: " + e);
                }
                e.printStackTrace();
            }
            this.init();
        }
        this.messageModule.setChatStateAllowed((Boolean)props.get(MUC_ALLOW_CHAT_STATES_KEY));
        this.presenceModule.setLockNewRoom((Boolean)props.get(MUC_LOCK_NEW_ROOM_KEY));
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("Tigase MUC Component ver. " + MucVersion.getVersion() + " started.");
        }
    }
}

