/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.muc.MUCComponent;
import tigase.muc.Room;
import tigase.muc.modules.PresenceModule;
import tigase.server.Packet;
import tigase.server.ReceiverTimeoutHandler;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.JID;

public class Ghostbuster {
    private static final Set<String> intReasons = new HashSet<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("gone");
            this.add("item-not-found");
            this.add("recipient-unavailable");
            this.add("redirect");
            this.add("remote-server-not-found");
            this.add("remote-server-timeout");
        }
    };
    public static final Set<String> R = Collections.unmodifiableSet(intReasons);
    private long idCounter;
    private final Map<JIDDomain, Long> lastActivity = new ConcurrentHashMap<JIDDomain, Long>();
    protected Logger log = Logger.getLogger(this.getClass().getName());
    private final MUCComponent mucComponent;
    private final ReceiverTimeoutHandler pingHandler;
    private PresenceModule presenceModule;

    public Ghostbuster(MUCComponent mucComponent) {
        this.mucComponent = mucComponent;
        this.pingHandler = new ReceiverTimeoutHandler(){

            public void responseReceived(Packet data, Packet response) {
                block2: {
                    try {
                        Ghostbuster.this.onPingReceived(response);
                    }
                    catch (Exception e) {
                        if (!Ghostbuster.this.log.isLoggable(Level.WARNING)) break block2;
                        Ghostbuster.this.log.log(Level.WARNING, "Problem on handling ping response", e);
                    }
                }
            }

            public void timeOutExpired(Packet data) {
                block3: {
                    try {
                        if (Ghostbuster.this.log.isLoggable(Level.FINEST)) {
                            Ghostbuster.this.log.finest("Received ping timeout for ping " + data.getElement().getAttribute("id"));
                        }
                        Ghostbuster.this.onPingTimeout(data.getStanzaFrom().getDomain(), data.getStanzaTo());
                    }
                    catch (Exception e) {
                        if (!Ghostbuster.this.log.isLoggable(Level.WARNING)) break block3;
                        Ghostbuster.this.log.log(Level.WARNING, "Problem on handling ping timeout", e);
                    }
                }
            }
        };
    }

    private String checkError(Packet packet) {
        String type = packet.getElement().getAttribute("type");
        if (type == null || !type.equals("error")) {
            return null;
        }
        Element errorElement = packet.getElement().getChild("error");
        if (errorElement == null) {
            return null;
        }
        for (Element reason : errorElement.getChildren()) {
            if (reason.getXMLNS() == null || !reason.getXMLNS().equals("urn:ietf:params:xml:ns:xmpp-stanzas") || !R.contains(reason.getName())) continue;
            return reason.getName();
        }
        return null;
    }

    public PresenceModule getPresenceModule() {
        return this.presenceModule;
    }

    protected void onPingReceived(Packet response) throws TigaseStringprepException {
        JIDDomain k = new JIDDomain(response.getStanzaFrom(), response.getStanzaTo().getDomain());
        if (this.lastActivity.containsKey(k)) {
            String errorCause = this.checkError(response);
            if (errorCause != null) {
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Received error response for ping " + response.getElement().getAttribute("id") + "(" + this.checkError(response) + ") of" + k);
                }
                this.processError(k);
            } else {
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Update last activity for " + k);
                }
                this.lastActivity.put(k, System.currentTimeMillis());
            }
        }
    }

    protected void onPingTimeout(String domain, JID jid) {
        block2: {
            try {
                this.processError(new JIDDomain(jid, domain));
            }
            catch (TigaseStringprepException e) {
                if (!this.log.isLoggable(Level.WARNING)) break block2;
                this.log.log(Level.WARNING, "Invalid jid?", e);
            }
        }
    }

    public void ping() throws TigaseStringprepException {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Pinging 1000 known jids");
        }
        int c = 0;
        long now = System.currentTimeMillis();
        long border = now - 3600000L;
        Iterator<Map.Entry<JIDDomain, Long>> it = this.lastActivity.entrySet().iterator();
        while (it.hasNext() && c < 1000) {
            Map.Entry<JIDDomain, Long> entry = it.next();
            if (entry.getValue() >= border) continue;
            ++c;
            this.ping(entry.getKey().domain, entry.getKey().source);
        }
    }

    private void ping(String fromDomain, JID jid) throws TigaseStringprepException {
        String id = "png-" + ++this.idCounter;
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(Level.FINER, "Pinging " + jid + ". id=" + id);
        }
        Element ping = new Element("iq", new String[]{"type", "id", "from", "to"}, new String[]{"get", id, fromDomain, jid.toString()});
        ping.addChild((XMLNodeIfc)new Element("ping", new String[]{"xmlns"}, new String[]{"urn:xmpp:ping"}));
        Packet packet = Packet.packetInstance((Element)ping);
        this.mucComponent.addOutPacket(packet, this.pingHandler, 1L, TimeUnit.MINUTES);
    }

    private void processError(JIDDomain k) throws TigaseStringprepException {
        if (this.presenceModule == null || this.mucComponent.getMucRepository() == null) {
            return;
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Forced removal last activity of " + k);
        }
        this.lastActivity.remove(k);
        for (Room r : this.mucComponent.getMucRepository().getActiveRooms().values()) {
            if (!r.getRoomJID().getDomain().equals(k.domain) || !r.isOccupantInRoom(k.source)) continue;
            this.presenceModule.doQuit(r, k.source);
        }
    }

    public void setPresenceModule(PresenceModule presenceModule) {
        this.presenceModule = presenceModule;
    }

    public void update(Packet packet) throws TigaseStringprepException {
        if (packet.getStanzaFrom() == null || packet.getStanzaFrom().getResource() == null) {
            return;
        }
        JIDDomain k = new JIDDomain(packet.getStanzaFrom(), packet.getStanzaTo().getDomain());
        String type = packet.getElement().getAttribute("type");
        if (this.checkError(packet) != null) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Received presence error: " + packet.getElement().toString());
            }
            this.processError(k);
        } else if ("presence".equals(packet.getElemName()) && type != null && type.equals("unavailable")) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Removal last activity of " + k);
            }
            this.lastActivity.remove(k);
        } else if (!(this.lastActivity.containsKey(k) || !"presence".equals(packet.getElemName()) || type != null && type.equals("error"))) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Creation last activity entry for " + k);
            }
            this.lastActivity.put(k, System.currentTimeMillis());
            return;
        }
        if (this.lastActivity.containsKey(k)) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Update last activity for " + k);
            }
            this.lastActivity.put(k, System.currentTimeMillis());
        }
    }

    private static class JIDDomain {
        private String cacheKey;
        private final String domain;
        private final JID source;

        public JIDDomain(JID source, String domain) {
            this.source = source;
            this.domain = domain;
            this.cacheKey = (this.source == null ? "-" : this.source.toString()) + ":" + (this.domain == null ? "-" : this.domain.toString());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof JIDDomain)) {
                return false;
            }
            return this.cacheKey.equals(((JIDDomain)obj).cacheKey);
        }

        public int hashCode() {
            return this.cacheKey.hashCode();
        }

        public String toString() {
            return this.cacheKey;
        }
    }
}

