/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc.modules;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.muc.IChatRoomLogger;
import tigase.muc.MucConfig;
import tigase.muc.Role;
import tigase.muc.Room;
import tigase.muc.exceptions.MUCException;
import tigase.muc.modules.AbstractModule;
import tigase.muc.repository.IMucRepository;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;

public class GroupchatMessageModule
extends AbstractModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"message", (String)"groupchat");
    private static final Criteria CRIT_CHAT_STAT = ElementCriteria.xmlns((String)"http://jabber.org/protocol/chatstates");
    private final Set<Criteria> allowedElements = new HashSet<Criteria>();
    private final IChatRoomLogger chatLogger;

    public GroupchatMessageModule(MucConfig config, IMucRepository mucRepository, IChatRoomLogger chatRoomLogger) {
        super(config, mucRepository);
        this.chatLogger = chatRoomLogger;
    }

    @Override
    public String[] getFeatures() {
        ArrayList<String> f = new ArrayList<String>();
        if (this.isChatStateAllowed()) {
            f.add("http://jabber.org/protocol/chatstates");
        }
        return f.toArray(new String[0]);
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    public boolean isChatStateAllowed() {
        return this.allowedElements.contains(CRIT_CHAT_STAT);
    }

    @Override
    public List<Element> process(Element element) throws MUCException {
        try {
            ArrayList<Element> result = new ArrayList<Element>();
            String senderJid = element.getAttribute("from");
            String roomId = GroupchatMessageModule.getRoomId(element.getAttribute("to"));
            if (GroupchatMessageModule.getNicknameFromJid(element.getAttribute("to")) != null) {
                throw new MUCException(Authorization.BAD_REQUEST);
            }
            Room room = this.repository.getRoom(roomId);
            if (room == null) {
                throw new MUCException(Authorization.ITEM_NOT_FOUND);
            }
            Role role = room.getRoleByJid(senderJid);
            if (!role.isSendMessagesToAll() || room.getConfig().isRoomModerated() && role == Role.visitor) {
                throw new MUCException(Authorization.FORBIDDEN);
            }
            Element body = null;
            Element subject = null;
            ArrayList<Element> content = new ArrayList<Element>();
            block3: for (Element c : element.getChildren()) {
                if ("body".equals(c.getName())) {
                    body = c;
                    content.add(c);
                    continue;
                }
                if ("subject".equals(c.getName())) {
                    subject = c;
                    content.add(c);
                    continue;
                }
                for (Criteria crit : this.allowedElements) {
                    if (!crit.match(c)) continue;
                    content.add(c);
                    continue block3;
                }
            }
            String nickName = room.getOccupantsNickname(senderJid);
            String senderRoomJid = roomId + "/" + nickName;
            if (subject != null) {
                if (!(room.getConfig().isChangeSubject() && role == Role.participant || role.isModifySubject())) {
                    throw new MUCException(Authorization.FORBIDDEN);
                }
                String msg = subject.getCData();
                room.setNewSubject(msg, nickName);
            }
            Date sendDate = new Date();
            if (body != null) {
                room.addToHistory(body.getCData(), senderJid, nickName, sendDate);
            }
            if (room.getConfig().isLoggingEnabled()) {
                if (body != null) {
                    this.chatLogger.addMessage(room.getConfig().getLoggingFormat(), room.getRoomId(), sendDate, nickName, body.getCData());
                } else if (subject != null) {
                    this.chatLogger.addSubject(room.getConfig().getLoggingFormat(), room.getRoomId(), sendDate, nickName, subject.getCData());
                }
            }
            result.addAll(this.sendMessagesToAllOccupants(room, senderRoomJid, content.toArray(new Element[0])));
            return result;
        }
        catch (MUCException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public List<Element> sendMessagesToAllOccupants(Room room, String fromJid, Element ... content) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (String occupantsJid : room.getOccupantsJids()) {
            Role role = room.getRoleByJid(occupantsJid);
            if (!role.isReceiveMessages()) continue;
            Element message = new Element("message", new String[]{"type", "from", "to"}, new String[]{"groupchat", fromJid, occupantsJid});
            if (content != null) {
                for (Element sub : content) {
                    if (sub == null) continue;
                    message.addChild((XMLNodeIfc)sub);
                }
            }
            result.add(message);
        }
        return result;
    }

    public void setChatStateAllowed(Boolean allowed) {
        System.out.println("xxx " + allowed);
        if (allowed != null && allowed.booleanValue()) {
            this.log.config("Chat state allowed");
            this.allowedElements.add(CRIT_CHAT_STAT);
        } else {
            this.log.config("Chat state disallowed");
            this.allowedElements.remove(CRIT_CHAT_STAT);
        }
    }
}

